/*
 * Decompiled with CFR 0.152.
 */
package fcs2data;

import java.util.zip.DataFormatException;

public class FCS_parameter {
    private int $PnB_bits = 0;
    private int $PnR_range = 0;
    private String $PnN_name = "";
    private String $PnS_description = "";
    private String $PnF_filter = "";
    private String $PnL_laser = "";
    private String $PnV_voltage = "";
    private String $PnO_excitationOutput = "";
    private String $PnP_percentCollected = "";
    private String $PnT_detector = "";
    private String PnDisplay = "";
    private String $PnD_display = "";
    private boolean logForDisplay = false;
    private String PnBS = "";
    private String PnMS = "";
    private boolean hasLogScale = false;
    private float decades = 0.0f;
    private float offset = 0.0f;
    private int bits = 0;
    private int bytes = 0;
    private int bitMask = 0;

    private FCS_parameter() {
    }

    public FCS_parameter(boolean isFloat, String paramBits, String paramRange, String paramName, String paramDesc, String paramFilter, String paramLaser, String paramVoltage, String paramExc, String paramCollected, String paramDetector, String paramDecadesOffset, String paramDisplay, String paramPnD, String paramBS, String paramMS) throws DataFormatException {
        if (paramBits != null) {
            this.$PnB_bits = Integer.valueOf(paramBits.trim());
        }
        this.bytes = this.$PnB_bits / 8;
        if (this.$PnB_bits % 8 != 0) {
            ++this.bytes;
        }
        this.$PnB_bits = this.bytes * 8;
        if (paramRange != null) {
            if (paramRange.contains(".")) {
                paramRange = paramRange.trim();
                paramRange = paramRange.substring(0, paramRange.indexOf("."));
                this.$PnR_range = Integer.valueOf(paramRange);
                ++this.$PnR_range;
            } else {
                this.$PnR_range = Integer.valueOf(paramRange.trim());
            }
            this.bits = (int)Math.round(Math.log10(this.$PnR_range) / Math.log10(2.0));
            for (int i = 0; i < this.bits; ++i) {
                this.bitMask <<= 1;
                this.bitMask |= 1;
            }
        }
        if (paramName != null) {
            this.$PnN_name = paramName;
        }
        if (paramDesc != null) {
            this.$PnS_description = paramDesc;
        }
        if (paramFilter != null) {
            this.$PnF_filter = paramFilter;
        }
        if (paramLaser != null) {
            this.$PnL_laser = paramLaser.trim();
        }
        if (paramVoltage != null) {
            this.$PnV_voltage = paramVoltage.trim();
        }
        if (paramExc != null) {
            this.$PnO_excitationOutput = paramExc.trim();
        }
        if (paramCollected != null) {
            this.$PnP_percentCollected = paramCollected.trim();
        }
        if (paramDetector != null) {
            this.$PnT_detector = paramDetector.trim();
        }
        if (paramDecadesOffset != null) {
            int i;
            String[] params = paramDecadesOffset.trim().split(",");
            String temp = params[0].trim();
            boolean notZero = false;
            for (i = 0; i < temp.length(); ++i) {
                if (temp.charAt(i) == '0' || temp.charAt(i) == '.') continue;
                notZero = true;
            }
            if (notZero && !isFloat) {
                this.hasLogScale = true;
                temp = params[0].trim();
                this.decades = Float.valueOf(temp).floatValue();
                temp = params[1].trim();
                notZero = false;
                for (i = 0; i < temp.length(); ++i) {
                    if (temp.charAt(i) == '0' || temp.charAt(i) == '.') continue;
                    notZero = true;
                }
                this.offset = notZero ? Float.valueOf(temp).floatValue() : 1.0f;
            }
        }
        if (paramDisplay != null) {
            this.PnDisplay = paramDisplay.trim();
        }
        if (paramPnD != null) {
            this.$PnD_display = paramPnD.trim();
        }
        if (this.PnDisplay.toLowerCase().equals("log") || this.hasLogScale) {
            this.logForDisplay = true;
        }
        if (this.$PnD_display.toLowerCase().startsWith("logarithmic")) {
            this.logForDisplay = true;
        }
        if (this.$PnD_display.toLowerCase().startsWith("linear")) {
            this.logForDisplay = false;
        }
        if (paramBS != null) {
            this.PnBS = paramBS;
        }
        if (paramMS != null) {
            this.PnMS = paramMS;
        }
    }

    public int get$PnB_bits() {
        return this.$PnB_bits;
    }

    public String get$PnF_filter() {
        return this.$PnF_filter;
    }

    public String get$PnL_laser() {
        return this.$PnL_laser;
    }

    public String get$PnN_name() {
        return this.$PnN_name;
    }

    public String get$PnO_excitationOutput() {
        return this.$PnO_excitationOutput;
    }

    public String get$PnP_percentCollected() {
        return this.$PnP_percentCollected;
    }

    public int get$PnR_range() {
        return this.$PnR_range;
    }

    public String get$PnS_description() {
        return this.$PnS_description;
    }

    public String get$PnT_detector() {
        return this.$PnT_detector;
    }

    public String get$PnV_voltage() {
        return this.$PnV_voltage;
    }

    public String getPnDisplay() {
        return this.PnDisplay;
    }

    public boolean displayOnLog() {
        return this.logForDisplay;
    }

    public boolean hasLogScale() {
        return this.hasLogScale;
    }

    public String getPnBS() {
        return this.PnBS;
    }

    public String getPnMS() {
        return this.PnMS;
    }

    public float getDecades() {
        return this.decades;
    }

    public float getOffset() {
        return this.offset;
    }

    public int getBitsforRange() {
        return this.bits;
    }

    public int getBytesForBits() {
        return this.bytes;
    }

    public int getBitMask() {
        return this.bitMask;
    }

    public void setRange(double newRange) {
        this.$PnR_range = (int)newRange;
        if ((double)this.$PnR_range < newRange) {
            ++this.$PnR_range;
        }
    }
}

