/*
 * Decompiled with CFR 0.152.
 */
package org.encog.neural.pattern;

import org.encog.engine.network.activation.ActivationFunction;
import org.encog.mathutil.rbf.RBFEnum;
import org.encog.ml.MLMethod;
import org.encog.neural.pattern.NeuralNetworkPattern;
import org.encog.neural.pattern.PatternError;
import org.encog.neural.rbf.RBFNetwork;

public class RadialBasisPattern
implements NeuralNetworkPattern {
    private RBFEnum rbfType = RBFEnum.Gaussian;
    private int inputNeurons = -1;
    private int outputNeurons = -1;
    private int hiddenNeurons = -1;

    @Override
    public void addHiddenLayer(int count) {
        if (this.hiddenNeurons != -1) {
            throw new PatternError("A RBF network usually has a single hidden layer.");
        }
        this.hiddenNeurons = count;
    }

    @Override
    public void clear() {
        this.hiddenNeurons = -1;
    }

    @Override
    public MLMethod generate() {
        RBFNetwork result = new RBFNetwork(this.inputNeurons, this.hiddenNeurons, this.outputNeurons, this.rbfType);
        return result;
    }

    @Override
    public void setActivationFunction(ActivationFunction activation) {
        throw new PatternError("Can't set the activation function for a radial basis function network.");
    }

    @Override
    public void setInputNeurons(int count) {
        this.inputNeurons = count;
    }

    @Override
    public void setOutputNeurons(int count) {
        this.outputNeurons = count;
    }

    public void setRBF(RBFEnum type) {
        this.rbfType = type;
    }
}

