/*
 * Decompiled with CFR 0.152.
 */
package net.java.sen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.sen.dictionary.Sentence;
import net.java.sen.dictionary.Token;
import net.java.sen.dictionary.Tokenizer;
import net.java.sen.dictionary.Viterbi;
import net.java.sen.filter.StreamFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringTagger {
    private final Viterbi viterbi;
    private List<StreamFilter> filterList = new ArrayList<StreamFilter>();

    private void filterPreProcess(Sentence sentence) {
        for (int i = 0; i < this.filterList.size(); ++i) {
            this.filterList.get(i).preProcess(sentence);
        }
    }

    private List<Token> filterPostProcess(List<Token> tokens) {
        for (int i = this.filterList.size() - 1; i >= 0; --i) {
            StreamFilter filter = this.filterList.get(i);
            tokens = filter.postProcess(tokens);
        }
        return tokens;
    }

    public void addFilter(StreamFilter filter) {
        this.filterList.add(filter);
    }

    public void removeFilters() {
        this.filterList.clear();
    }

    public List<Token> analyze(String surface, List<Token> reuse) throws IOException {
        Sentence sentence = new Sentence(surface.toCharArray());
        this.filterPreProcess(sentence);
        List<Token> tokens = this.viterbi.getBestTokens(sentence, reuse);
        tokens = this.filterPostProcess(tokens);
        return tokens;
    }

    @Deprecated
    public List<Token> analyze(String surface) throws IOException {
        return this.analyze(surface, new ArrayList<Token>());
    }

    public List<Token> analyze(char[] surface, List<Token> reuse) throws IOException {
        Sentence sentence = new Sentence(surface);
        this.filterPreProcess(sentence);
        List<Token> tokens = this.viterbi.getBestTokens(sentence, reuse);
        tokens = this.filterPostProcess(tokens);
        return tokens;
    }

    @Deprecated
    public List<Token> analyze(char[] surface) throws IOException {
        return this.analyze(surface, new ArrayList<Token>());
    }

    public StringTagger(Tokenizer tokenizer) {
        this.viterbi = new Viterbi(tokenizer);
    }
}

