/*
 * Decompiled with CFR 0.152.
 */
package com.ircclouds.irc.api;

import com.ircclouds.irc.api.ApiException;
import com.ircclouds.irc.api.DCCManager;
import com.ircclouds.irc.api.IRCApi;
import com.ircclouds.irc.api.ctcp.DCCReceiveCallback;
import com.ircclouds.irc.api.ctcp.DCCReceiveException;
import com.ircclouds.irc.api.ctcp.DCCReceiveProgressCallback;
import com.ircclouds.irc.api.ctcp.DCCReceiveResult;
import com.ircclouds.irc.api.ctcp.DCCReceiver;
import com.ircclouds.irc.api.ctcp.DCCSendCallback;
import com.ircclouds.irc.api.ctcp.DCCSendException;
import com.ircclouds.irc.api.ctcp.DCCSendProgressCallback;
import com.ircclouds.irc.api.ctcp.DCCSendResult;
import com.ircclouds.irc.api.ctcp.DCCSender;
import java.io.File;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCCManagerImpl
implements DCCManager {
    private static final Logger LOG = LoggerFactory.getLogger(DCCManagerImpl.class);
    public static final int DCC_SEND_TIMEOUT = 10000;
    private IRCApi api;
    private Map<Integer, DCCSender> sendersMap = new HashMap<Integer, DCCSender>();
    private List<DCCReceiver> dccReceivers = new ArrayList<DCCReceiver>();

    public DCCManagerImpl(IRCApi aApi) {
        this.api = aApi;
    }

    void dccSend(String aNick, File aFile, Integer aListeningPort, Integer aTimeout, DCCSendCallback aCallback) {
        DCCSender _dccSender = new DCCSender(aListeningPort, aTimeout, this.addManagerDCCSendCallback(aCallback, aListeningPort));
        this.registerSender(aListeningPort, _dccSender);
        _dccSender.send(aFile);
        this.api.message(aNick, "\u0001DCC SEND " + aFile.getName() + " " + this.getLocalAddressRepresentation() + " " + aListeningPort + " " + aFile.length() + '\u0001');
    }

    void dccAccept(String aNick, File aFile, Integer aPort, Integer aResumePosition, Integer aTimeout, DCCSendCallback aCallback) {
        DCCSender _dccSender = new DCCSender(aTimeout, aPort, aResumePosition, this.addManagerDCCSendCallback(aCallback, aPort));
        if (this.isWaitingForConnection(aPort)) {
            this.sendersMap.get(aPort).setResumePosition(aResumePosition);
        } else {
            this.registerSender(aPort, _dccSender);
            _dccSender.send(aFile);
        }
        this.api.message(aNick, "\u0001DCC ACCEPT " + aFile.getName() + " " + aPort + " " + aResumePosition + '\u0001');
    }

    void dccResume(File aFile, Integer aResumePosition, Integer aSize, SocketAddress aAddress, DCCReceiveCallback aCallback) {
        DCCReceiver _dccReceiver = new DCCReceiver(this.addManagerDCCReceiveCallback(aCallback));
        this.registerReceiver(_dccReceiver);
        _dccReceiver.receive(aFile, aResumePosition, aSize, aAddress);
    }

    @Override
    public int activeDCCSendsCount() {
        return this.sendersMap.size();
    }

    @Override
    public int activeDCCReceivesCount() {
        return this.dccReceivers.size();
    }

    private String getLocalAddressRepresentation() {
        try {
            InetAddress _localHost = InetAddress.getLocalHost();
            byte[] _address = _localHost.getAddress();
            if (_address.length == 4) {
                return new BigInteger(1, _address).toString();
            }
            return _localHost.getHostAddress();
        }
        catch (UnknownHostException aExc) {
            LOG.error("", (Throwable)aExc);
            throw new ApiException(aExc);
        }
    }

    private DCCReceiveCallback addManagerDCCReceiveCallback(final DCCReceiveCallback aCallback) {
        if (aCallback instanceof DCCReceiveProgressCallback) {
            return new DCCReceiveProgressCallback(){

                @Override
                public void onSuccess(DCCReceiveResult aU) {
                    DCCManagerImpl.this.dccReceivers.remove(aU);
                    aCallback.onSuccess(aU);
                }

                @Override
                public void onFailure(DCCReceiveException aV) {
                    DCCManagerImpl.this.dccReceivers.remove(aV);
                    aCallback.onFailure(aV);
                }

                @Override
                public void onProgress(int aBytesTransferred) {
                    ((DCCReceiveProgressCallback)aCallback).onProgress(aBytesTransferred);
                }
            };
        }
        return new DCCReceiveCallback(){

            @Override
            public void onSuccess(DCCReceiveResult aU) {
                DCCManagerImpl.this.dccReceivers.remove(aU);
                aCallback.onSuccess(aU);
            }

            @Override
            public void onFailure(DCCReceiveException aV) {
                DCCManagerImpl.this.dccReceivers.remove(aV);
                aCallback.onFailure(aV);
            }
        };
    }

    private DCCSendCallback addManagerDCCSendCallback(final DCCSendCallback aCallback, final int aPort) {
        if (aCallback instanceof DCCSendProgressCallback) {
            return new DCCSendProgressCallback(){

                @Override
                public void onSuccess(DCCSendResult aU) {
                    DCCManagerImpl.this.sendersMap.remove(aPort);
                    aCallback.onSuccess(aU);
                }

                @Override
                public void onFailure(DCCSendException aV) {
                    DCCManagerImpl.this.sendersMap.remove(aPort);
                    aCallback.onFailure(aV);
                }

                @Override
                public void onProgress(int aBytesTransferred) {
                    ((DCCSendProgressCallback)aCallback).onProgress(aBytesTransferred);
                }
            };
        }
        return new DCCSendCallback(){

            @Override
            public void onSuccess(DCCSendResult aU) {
                DCCManagerImpl.this.sendersMap.remove(aPort);
                aCallback.onSuccess(aU);
            }

            @Override
            public void onFailure(DCCSendException aV) {
                DCCManagerImpl.this.sendersMap.remove(aPort);
                aCallback.onFailure(aV);
            }
        };
    }

    private void registerSender(Integer aListeningPort, DCCSender _dccSender) {
        this.sendersMap.put(aListeningPort, _dccSender);
    }

    private void registerReceiver(DCCReceiver aDCCReceiver) {
        this.dccReceivers.add(aDCCReceiver);
    }

    private boolean isWaitingForConnection(Integer aPort) {
        return this.sendersMap.containsKey(aPort);
    }
}

