/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus;

import org.freedesktop.dbus.Message;

class EfficientQueue {
    private Message[] mv;
    private int start;
    private int end;
    private int init_size;

    public EfficientQueue(int n) {
        this.init_size = n;
        this.shrink();
    }

    private void grow() {
        Message[] messageArray = this.mv;
        this.mv = new Message[messageArray.length * 2];
        System.arraycopy(messageArray, this.start, this.mv, 0, messageArray.length - this.start);
        if (this.end != messageArray.length - 1) {
            System.arraycopy(messageArray, 0, this.mv, messageArray.length - this.start, this.end + 1);
        }
        this.start = 0;
        this.end = messageArray.length;
    }

    public Message[] getKeys() {
        Message[] messageArray;
        if (this.start == this.end) {
            return new Message[0];
        }
        if (this.start < this.end) {
            int n = this.end - this.start;
            messageArray = new Message[n];
            System.arraycopy(this.mv, this.start, messageArray, 0, n);
        } else {
            int n = this.mv.length - this.start + this.end;
            messageArray = new Message[n];
            System.arraycopy(this.mv, this.start, messageArray, 0, this.mv.length - this.start);
            System.arraycopy(this.mv, 0, messageArray, this.mv.length - this.start, this.end);
        }
        return messageArray;
    }

    private void shrink() {
        if (null != this.mv && this.mv.length == this.init_size) {
            return;
        }
        this.mv = new Message[this.init_size];
        this.start = 0;
        this.end = 0;
    }

    public void add(Message message) {
        this.mv[this.end] = message;
        this.end = this.end == this.mv.length - 1 ? 0 : ++this.end;
        if (this.end == this.start) {
            this.grow();
        }
    }

    public Message remove() {
        if (this.start == this.end) {
            return null;
        }
        int n = this.start;
        Message message = this.mv[n];
        this.mv[n] = null;
        this.start = this.start == this.mv.length - 1 ? 0 : ++this.start;
        return message;
    }

    public boolean isEmpty() {
        return this.start == this.end;
    }

    public int size() {
        if (this.end >= this.start) {
            return this.end - this.start;
        }
        return this.mv.length - this.start + this.end;
    }
}

