/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.AbstractExtension;
import com.google.gdata.data.AttributeGenerator;
import com.google.gdata.data.AttributeHelper;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.util.ParseException;

@ExtensionDescription.Default(nsAlias="gd", nsUri="http://schemas.google.com/g/2005", localName="customProperty")
public class CustomProperty
extends AbstractExtension {
    static final String XML_NAME = "customProperty";
    private static final String NAME = "name";
    private static final String TYPE = "type";
    private static final String UNIT = "unit";
    private String name = null;
    private String type = null;
    private String unit = null;
    private String value = null;

    public CustomProperty() {
    }

    public CustomProperty(String name, String type, String unit, String value) {
        this.setName(name);
        this.setType(type);
        this.setUnit(unit);
        this.setValue(value);
        this.setImmutable(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.throwExceptionIfImmutable();
        this.name = name;
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.throwExceptionIfImmutable();
        this.type = type;
    }

    public boolean hasType() {
        return this.getType() != null;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.throwExceptionIfImmutable();
        this.unit = unit;
    }

    public boolean hasUnit() {
        return this.getUnit() != null;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.throwExceptionIfImmutable();
        this.value = value;
    }

    public boolean hasValue() {
        return this.getValue() != null;
    }

    protected void validate() {
        if (this.name == null) {
            CustomProperty.throwExceptionForMissingAttribute(NAME);
        }
        if (this.value == null) {
            throw new IllegalStateException("Missing text content");
        }
    }

    public static ExtensionDescription getDefaultDescription(boolean required, boolean repeatable) {
        ExtensionDescription desc = ExtensionDescription.getDefaultDescription(CustomProperty.class);
        desc.setRequired(required);
        desc.setRepeatable(repeatable);
        return desc;
    }

    protected void putAttributes(AttributeGenerator generator) {
        generator.put(NAME, this.name);
        generator.put(TYPE, this.type);
        generator.put(UNIT, this.unit);
        generator.setContent(this.value);
    }

    protected void consumeAttributes(AttributeHelper helper) throws ParseException {
        this.name = helper.consume(NAME, true);
        this.type = helper.consume(TYPE, false);
        this.unit = helper.consume(UNIT, false);
        this.value = helper.consume(null, true);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!this.sameClassAs(obj)) {
            return false;
        }
        CustomProperty other = (CustomProperty)obj;
        return CustomProperty.eq(this.name, other.name) && CustomProperty.eq(this.type, other.type) && CustomProperty.eq(this.unit, other.unit) && CustomProperty.eq(this.value, other.value);
    }

    public int hashCode() {
        int result = this.getClass().hashCode();
        if (this.name != null) {
            result = 37 * result + this.name.hashCode();
        }
        if (this.type != null) {
            result = 37 * result + this.type.hashCode();
        }
        if (this.unit != null) {
            result = 37 * result + this.unit.hashCode();
        }
        if (this.value != null) {
            result = 37 * result + this.value.hashCode();
        }
        return result;
    }

    public String toString() {
        return "{CustomProperty name=" + this.name + " type=" + this.type + " unit=" + this.unit + " value=" + this.value + "}";
    }
}

