/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.util.Vector;
import java.util.logging.Logger;
import org.ice4j.stack.RawMessage;

class MessageQueue {
    private static final Logger logger = Logger.getLogger(MessageQueue.class.getName());
    private Vector<RawMessage> queue = new Vector();
    private int size = 0;

    MessageQueue() {
    }

    public int getSize() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized void add(RawMessage rawMessage) {
        logger.finest("Adding raw message to queue.");
        this.queue.add(rawMessage);
        ++this.size;
        this.notifyAll();
    }

    public synchronized RawMessage remove() throws InterruptedException {
        this.waitWhileEmpty();
        RawMessage rawMessage = this.queue.remove(0);
        --this.size;
        return rawMessage;
    }

    public synchronized void waitWhileEmpty() throws InterruptedException {
        while (this.isEmpty()) {
            this.wait();
        }
    }
}

