/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.stack;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.ice4j.StunException;
import org.ice4j.StunMessageEvent;
import org.ice4j.message.Message;
import org.ice4j.stack.ErrorHandler;
import org.ice4j.stack.MessageEventHandler;
import org.ice4j.stack.MessageQueue;
import org.ice4j.stack.NetAccessManager;
import org.ice4j.stack.RawMessage;
import org.ice4j.stack.StunStack;

class MessageProcessor
implements Runnable {
    private static final Logger logger = Logger.getLogger(MessageProcessor.class.getName());
    private final ErrorHandler errorHandler;
    private final MessageQueue messageQueue;
    private final MessageEventHandler messageEventHandler;
    private final NetAccessManager netAccessManager;
    private boolean running = false;
    private Thread runningThread = null;

    MessageProcessor(NetAccessManager netAccessManager) throws IllegalArgumentException {
        if (netAccessManager == null) {
            throw new NullPointerException("netAccessManager");
        }
        MessageQueue messageQueue = netAccessManager.getMessageQueue();
        if (messageQueue == null) {
            throw new IllegalArgumentException("The message queue may not be null");
        }
        MessageEventHandler messageEventHandler = netAccessManager.getMessageEventHandler();
        if (messageEventHandler == null) {
            throw new IllegalArgumentException("The message event handler may not be null");
        }
        this.netAccessManager = netAccessManager;
        this.messageQueue = messageQueue;
        this.messageEventHandler = messageEventHandler;
        this.errorHandler = netAccessManager;
    }

    public void run() {
        try {
            StunStack stunStack = this.netAccessManager.getStunStack();
            while (this.running) {
                RawMessage rawMessage;
                try {
                    rawMessage = this.messageQueue.remove();
                }
                catch (InterruptedException ex) {
                    if (this.isRunning()) {
                        logger.log(Level.WARNING, "A net access point has gone useless: ", ex);
                    }
                    rawMessage = null;
                }
                if (!this.isRunning()) {
                    return;
                }
                if (rawMessage == null) continue;
                Message stunMessage = null;
                try {
                    stunMessage = Message.decode(rawMessage.getBytes(), '\u0000', (char)rawMessage.getMessageLength());
                }
                catch (StunException ex) {
                    this.errorHandler.handleError("Failed to decode a stun message!", ex);
                    continue;
                }
                logger.finest("Dispatching a StunMessageEvent.");
                StunMessageEvent stunMessageEvent = new StunMessageEvent(stunStack, rawMessage, stunMessage);
                this.messageEventHandler.handleMessageEvent(stunMessageEvent);
            }
        }
        catch (Throwable err) {
            this.errorHandler.handleFatalError(this, "Unexpected Error!", err);
        }
    }

    void start() {
        this.running = true;
        this.runningThread = new Thread((Runnable)this, "Stun4J Message Processor");
        this.runningThread.setDaemon(true);
        this.runningThread.start();
    }

    void stop() {
        this.running = false;
        this.runningThread.interrupt();
    }

    boolean isRunning() {
        return this.running;
    }
}

