/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.bundlerepository.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.felix.bundlerepository.Capability;
import org.apache.felix.bundlerepository.Repository;
import org.apache.felix.bundlerepository.Requirement;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;

public class ResourceImpl
implements Resource {
    private final Map m_map = new HashMap();
    private final List m_capList = new ArrayList();
    private final List m_reqList = new ArrayList();
    private Repository m_repo;
    private Map m_uris;
    private transient int m_hash;

    public boolean equals(Object o) {
        if (o instanceof Resource) {
            if (this.getSymbolicName() == null || this.getVersion() == null) {
                return this == o;
            }
            return this.getSymbolicName().equals(((Resource)o).getSymbolicName()) && this.getVersion().equals((Object)((Resource)o).getVersion());
        }
        return false;
    }

    public int hashCode() {
        if (this.m_hash == 0) {
            this.m_hash = this.getSymbolicName() == null || this.getVersion() == null ? super.hashCode() : this.getSymbolicName().hashCode() ^ this.getVersion().hashCode();
        }
        return this.m_hash;
    }

    public Repository getRepository() {
        return this.m_repo;
    }

    public void setRepository(Repository repository) {
        this.m_repo = repository;
    }

    public Map getProperties() {
        this.convertURIs();
        return this.m_map;
    }

    public String getPresentationName() {
        return (String)this.m_map.get("presentationname");
    }

    public String getSymbolicName() {
        return (String)this.m_map.get("symbolicname");
    }

    public String getId() {
        return (String)this.m_map.get("id");
    }

    public Version getVersion() {
        Version v = (Version)this.m_map.get("version");
        v = v == null ? Version.emptyVersion : v;
        return v;
    }

    public String getURI() {
        this.convertURIs();
        return (String)this.m_map.get("uri");
    }

    public Long getSize() {
        return (Long)this.m_map.get("size");
    }

    public Requirement[] getRequirements() {
        return this.m_reqList.toArray(new Requirement[this.m_reqList.size()]);
    }

    public void addRequire(Requirement req) {
        this.m_reqList.add(req);
    }

    public Capability[] getCapabilities() {
        return this.m_capList.toArray(new Capability[this.m_capList.size()]);
    }

    public void addCapability(Capability cap) {
        this.m_capList.add(cap);
    }

    public String[] getCategories() {
        List catList = (List)this.m_map.get("category");
        if (catList == null) {
            return new String[0];
        }
        return catList.toArray(new String[catList.size()]);
    }

    public void addCategory(String category) {
        ArrayList<String> catList = (ArrayList<String>)this.m_map.get("category");
        if (catList == null) {
            catList = new ArrayList<String>();
            this.m_map.put("category", catList);
        }
        catList.add(category);
    }

    public boolean isLocal() {
        return false;
    }

    public Object put(Object key, Object value) {
        this.put(key.toString(), value.toString(), null);
        return null;
    }

    public void put(String key, String value, String type) {
        key = key.toLowerCase();
        this.m_hash = 0;
        if ("uri".equals(type) || "uri".equals(key)) {
            if (this.m_uris == null) {
                this.m_uris = new HashMap();
            }
            this.m_uris.put(key, value);
        } else if ("version".equals(type) || "version".equals(key)) {
            this.m_map.put(key, VersionTable.getVersion(value));
        } else if ("long".equals(type) || "size".equals(key)) {
            this.m_map.put(key, Long.valueOf(value));
        } else if ("set".equals(type) || "category".equals(key)) {
            StringTokenizer st = new StringTokenizer(value, ",");
            HashSet<String> s = new HashSet<String>();
            while (st.hasMoreTokens()) {
                s.add(st.nextToken().trim());
            }
            this.m_map.put(key, s);
        } else {
            this.m_map.put(key, value);
        }
    }

    private void convertURIs() {
        if (this.m_uris != null) {
            Iterator it = this.m_uris.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String val = (String)this.m_uris.get(key);
                this.m_map.put(key, this.resolveUri(val));
            }
            this.m_uris = null;
        }
    }

    private String resolveUri(String uri) {
        try {
            if (this.m_repo != null && this.m_repo.getURI() != null) {
                return new URI(this.m_repo.getURI()).resolve(uri).toString();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return uri;
    }

    public String toString() {
        return this.getId();
    }
}

