/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.video.h264;

import java.awt.Dimension;
import java.util.HashMap;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import net.sf.fmj.media.AbstractCodec;
import org.jitsi.impl.neomedia.NeomediaServiceUtils;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.FFmpeg;
import org.jitsi.impl.neomedia.format.ParameterizedVideoFormat;
import org.jitsi.service.configuration.ConfigurationService;
import org.jitsi.service.libjitsi.LibJitsi;
import org.jitsi.service.neomedia.control.KeyFrameControl;
import org.jitsi.service.neomedia.event.RTCPFeedbackMessageEvent;
import org.jitsi.service.neomedia.event.RTCPFeedbackMessageListener;
import org.jitsi.util.Logger;

public class JNIEncoder
extends AbstractCodec
implements RTCPFeedbackMessageListener {
    public static final String[] AVAILABLE_PRESETS = new String[]{"ultrafast", "superfast", "veryfast", "faster", "fast", "medium", "slow", "slower", "veryslow"};
    public static final String BASELINE_PROFILE = "baseline";
    public static final boolean DEFAULT_DEFAULT_INTRA_REFRESH = true;
    public static final String MAIN_PROFILE = "main";
    public static final String DEFAULT_DEFAULT_PROFILE = "main";
    public static final int DEFAULT_FRAME_RATE = 15;
    public static final String DEFAULT_INTRA_REFRESH_PNAME = "org.jitsi.impl.neomedia.codec.video.h264.defaultIntraRefresh";
    public static final int DEFAULT_KEYINT = 150;
    public static final String DEFAULT_PRESET = AVAILABLE_PRESETS[0];
    public static final String DEFAULT_PROFILE_PNAME = "net.java.sip.communicator.impl.neomedia.codec.video.h264.defaultProfile";
    public static final String HIGH_PROFILE = "high";
    public static final String KEYINT_PNAME = "org.jitsi.impl.neomedia.codec.video.h264.keyint";
    private static final Logger logger = Logger.getLogger(JNIEncoder.class);
    private static final long PLI_INTERVAL = 3000L;
    private static final String PLUGIN_NAME = "H.264 Encoder";
    public static final String PRESET_PNAME = "org.jitsi.impl.neomedia.codec.video.h264.preset";
    static final Format[] SUPPORTED_OUTPUT_FORMATS = new Format[]{new ParameterizedVideoFormat("h264", "packetization-mode", "0"), new ParameterizedVideoFormat("h264", "packetization-mode", "1")};
    public static final int X264_KEYINT_MAX_INFINITE = 0x40000000;
    public static final int X264_KEYINT_MIN_AUTO = 0;
    private Map<String, String> additionalCodecSettings;
    private long avctx;
    private long avFrame;
    private boolean forceKeyFrame = true;
    private KeyFrameControl keyFrameControl;
    private KeyFrameControl.KeyFrameRequestee keyFrameRequestee;
    private int keyint;
    private int lastKeyFrame;
    private long lastKeyFrameRequestTime = System.currentTimeMillis();
    private String packetizationMode;
    private long rawFrameBuffer;
    private int rawFrameLen;
    private boolean secondKeyFrame = true;

    private static int getProfileForConfig(String profile) {
        if (BASELINE_PROFILE.equalsIgnoreCase(profile)) {
            return 66;
        }
        if (HIGH_PROFILE.equalsIgnoreCase(profile)) {
            return 100;
        }
        return 77;
    }

    public JNIEncoder() {
        this.inputFormats = new Format[]{new YUVFormat(null, -1, Format.byteArray, -1.0f, 2, -1, -1, -1, -1, -1)};
        this.inputFormat = null;
        this.outputFormat = null;
    }

    public synchronized void close() {
        if (this.opened) {
            this.opened = false;
            super.close();
            if (this.avctx != 0L) {
                FFmpeg.avcodec_close(this.avctx);
                FFmpeg.av_free(this.avctx);
                this.avctx = 0L;
            }
            if (this.avFrame != 0L) {
                FFmpeg.avcodec_free_frame(this.avFrame);
                this.avFrame = 0L;
            }
            if (this.rawFrameBuffer != 0L) {
                FFmpeg.av_free(this.rawFrameBuffer);
                this.rawFrameBuffer = 0L;
            }
            if (this.keyFrameRequestee != null) {
                if (this.keyFrameControl != null) {
                    this.keyFrameControl.removeKeyFrameRequestee(this.keyFrameRequestee);
                }
                this.keyFrameRequestee = null;
            }
        }
    }

    private Format[] getMatchingOutputFormats(Format inputFormat) {
        String[] stringArray;
        VideoFormat inputVideoFormat = (VideoFormat)inputFormat;
        if (this.packetizationMode == null) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "0";
            stringArray = stringArray2;
            stringArray2[1] = "1";
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.packetizationMode;
        }
        String[] packetizationModes = stringArray;
        Format[] matchingOutputFormats = new Format[packetizationModes.length];
        Dimension size = inputVideoFormat.getSize();
        float frameRate = inputVideoFormat.getFrameRate();
        for (int index = packetizationModes.length - 1; index >= 0; --index) {
            matchingOutputFormats[index] = new ParameterizedVideoFormat("h264", size, -1, Format.byteArray, frameRate, ParameterizedVideoFormat.toMap("packetization-mode", packetizationModes[index]));
        }
        return matchingOutputFormats;
    }

    public String getName() {
        return PLUGIN_NAME;
    }

    public Format[] getSupportedOutputFormats(Format in) {
        Format[] supportedOutputFormats = in == null ? SUPPORTED_OUTPUT_FORMATS : (!(in instanceof VideoFormat) || null == AbstractCodec2.matches(in, this.inputFormats) ? new Format[]{} : this.getMatchingOutputFormats(in));
        return supportedOutputFormats;
    }

    private boolean isKeyFrame() {
        boolean keyFrame;
        if (this.forceKeyFrame) {
            keyFrame = true;
            if (this.secondKeyFrame) {
                this.secondKeyFrame = false;
                this.forceKeyFrame = true;
            } else {
                this.forceKeyFrame = false;
            }
        } else {
            keyFrame = this.lastKeyFrame == this.keyint;
        }
        return keyFrame;
    }

    private boolean keyFrameRequest() {
        long now = System.currentTimeMillis();
        if (now > this.lastKeyFrameRequestTime + 3000L) {
            this.lastKeyFrameRequestTime = now;
            this.forceKeyFrame = true;
        }
        return true;
    }

    public synchronized void open() throws ResourceUnavailableException {
        long avcodec;
        if (this.opened) {
            return;
        }
        VideoFormat inputVideoFormat = (VideoFormat)this.inputFormat;
        VideoFormat outputVideoFormat = (VideoFormat)this.outputFormat;
        Dimension size = null;
        if (inputVideoFormat != null) {
            size = inputVideoFormat.getSize();
        }
        if (size == null && outputVideoFormat != null) {
            size = outputVideoFormat.getSize();
        }
        if (size == null) {
            throw new ResourceUnavailableException("The input video frame width and height are not set.");
        }
        int width = size.width;
        int height = size.height;
        ConfigurationService cfg = LibJitsi.getConfigurationService();
        boolean intraRefresh = true;
        int keyint = 150;
        String preset = DEFAULT_PRESET;
        String profile = "main";
        if (cfg != null) {
            intraRefresh = cfg.getBoolean(DEFAULT_INTRA_REFRESH_PNAME, intraRefresh);
            keyint = cfg.getInt(KEYINT_PNAME, keyint);
            preset = cfg.getString(PRESET_PNAME, preset);
            profile = cfg.getString(DEFAULT_PROFILE_PNAME, profile);
        }
        if (this.additionalCodecSettings != null) {
            for (Map.Entry<String, String> e : this.additionalCodecSettings.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if ("h264.intrarefresh".equals(k)) {
                    if (!"false".equals(v)) continue;
                    intraRefresh = false;
                    continue;
                }
                if (!"h264.profile".equals(k) || !BASELINE_PROFILE.equals(v) && !HIGH_PROFILE.equals(v) && !"main".equals(v)) continue;
                profile = v;
            }
        }
        if ((avcodec = FFmpeg.avcodec_find_encoder(28)) == 0L) {
            throw new ResourceUnavailableException("Could not find H.264 encoder.");
        }
        this.avctx = FFmpeg.avcodec_alloc_context3(avcodec);
        FFmpeg.avcodeccontext_set_pix_fmt(this.avctx, 0);
        FFmpeg.avcodeccontext_set_size(this.avctx, width, height);
        FFmpeg.avcodeccontext_set_qcompress(this.avctx, 0.6f);
        int bitRate = 1000 * NeomediaServiceUtils.getMediaServiceImpl().getDeviceConfiguration().getVideoBitrate();
        int frameRate = -1;
        if (outputVideoFormat != null) {
            frameRate = (int)outputVideoFormat.getFrameRate();
        }
        if (frameRate == -1 && inputVideoFormat != null) {
            frameRate = (int)inputVideoFormat.getFrameRate();
        }
        if (frameRate == -1) {
            frameRate = 15;
        }
        FFmpeg.avcodeccontext_set_bit_rate(this.avctx, bitRate);
        FFmpeg.avcodeccontext_set_bit_rate_tolerance(this.avctx, bitRate / frameRate);
        FFmpeg.avcodeccontext_set_rc_max_rate(this.avctx, bitRate);
        FFmpeg.avcodeccontext_set_sample_aspect_ratio(this.avctx, 0, 0);
        FFmpeg.avcodeccontext_set_thread_count(this.avctx, 1);
        FFmpeg.avcodeccontext_set_time_base(this.avctx, 1, frameRate);
        FFmpeg.avcodeccontext_set_ticks_per_frame(this.avctx, 2);
        FFmpeg.avcodeccontext_set_quantizer(this.avctx, 30, 31, 4);
        FFmpeg.avcodeccontext_set_mb_decision(this.avctx, 0);
        FFmpeg.avcodeccontext_set_rc_eq(this.avctx, "blurCplx^(1-qComp)");
        FFmpeg.avcodeccontext_add_flags(this.avctx, 2048);
        if (intraRefresh) {
            FFmpeg.avcodeccontext_add_flags2(this.avctx, 0x200000);
        }
        FFmpeg.avcodeccontext_set_me_method(this.avctx, 7);
        FFmpeg.avcodeccontext_set_me_subpel_quality(this.avctx, 2);
        FFmpeg.avcodeccontext_set_me_range(this.avctx, 16);
        FFmpeg.avcodeccontext_set_me_cmp(this.avctx, 256);
        FFmpeg.avcodeccontext_set_scenechange_threshold(this.avctx, 40);
        FFmpeg.avcodeccontext_set_rc_buffer_size(this.avctx, 10);
        FFmpeg.avcodeccontext_set_gop_size(this.avctx, keyint);
        FFmpeg.avcodeccontext_set_i_quant_factor(this.avctx, 0.71428573f);
        FFmpeg.avcodeccontext_set_refs(this.avctx, 1);
        FFmpeg.avcodeccontext_set_keyint_min(this.avctx, 0);
        if (null == this.packetizationMode || "0".equals(this.packetizationMode)) {
            FFmpeg.avcodeccontext_set_rtp_payload_size(this.avctx, 1024);
        }
        try {
            FFmpeg.avcodeccontext_set_profile(this.avctx, JNIEncoder.getProfileForConfig(profile));
        }
        catch (UnsatisfiedLinkError ule) {
            logger.warn("The FFmpeg JNI library is out-of-date.");
        }
        if (FFmpeg.avcodec_open2(this.avctx, avcodec, "intra-refresh", intraRefresh ? "1" : "0", "keyint", Integer.toString(keyint), "partitions", "b8x8,i4x4,p8x8", "preset", preset, "thread_type", "slice", "tune", "zerolatency") < 0) {
            throw new ResourceUnavailableException("Could not open H.264 encoder. (size= " + width + "x" + height + ")");
        }
        this.rawFrameLen = width * height * 3 / 2;
        this.rawFrameBuffer = FFmpeg.av_malloc(this.rawFrameLen);
        this.avFrame = FFmpeg.avcodec_alloc_frame();
        int sizeInBytes = width * height;
        FFmpeg.avframe_set_data(this.avFrame, this.rawFrameBuffer, sizeInBytes, sizeInBytes / 4);
        FFmpeg.avframe_set_linesize(this.avFrame, width, width / 2, width / 2);
        this.forceKeyFrame = true;
        this.keyint = keyint;
        this.lastKeyFrame = 0;
        if (this.keyFrameRequestee == null) {
            this.keyFrameRequestee = new KeyFrameControl.KeyFrameRequestee(){

                @Override
                public boolean keyFrameRequest() {
                    return JNIEncoder.this.keyFrameRequest();
                }
            };
        }
        if (this.keyFrameControl != null) {
            this.keyFrameControl.addKeyFrameRequestee(-1, this.keyFrameRequestee);
        }
        this.opened = true;
        super.open();
    }

    public synchronized int process(Buffer inBuffer, Buffer outBuffer) {
        if (this.isEOM(inBuffer)) {
            this.propagateEOM(outBuffer);
            this.reset();
            return 0;
        }
        if (inBuffer.isDiscard()) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        Format inFormat = inBuffer.getFormat();
        if (inFormat != this.inputFormat && !inFormat.equals((Object)this.inputFormat)) {
            this.setInputFormat(inFormat);
        }
        if (inBuffer.getLength() < 10) {
            outBuffer.setDiscard(true);
            this.reset();
            return 0;
        }
        FFmpeg.memcpy(this.rawFrameBuffer, (byte[])inBuffer.getData(), inBuffer.getOffset(), this.rawFrameLen);
        boolean keyFrame = this.isKeyFrame();
        FFmpeg.avframe_set_key_frame(this.avFrame, keyFrame);
        this.lastKeyFrame = keyFrame ? 0 : ++this.lastKeyFrame;
        byte[] out = AbstractCodec2.validateByteArraySize(outBuffer, this.rawFrameLen, false);
        int outLength = FFmpeg.avcodec_encode_video(this.avctx, out, out.length, this.avFrame);
        outBuffer.setLength(outLength);
        outBuffer.setOffset(0);
        outBuffer.setTimeStamp(inBuffer.getTimeStamp());
        return 0;
    }

    @Override
    public void rtcpFeedbackMessageReceived(RTCPFeedbackMessageEvent ev) {
        if (ev.getPayloadType() == -50) {
            switch (ev.getFeedbackMessageType()) {
                case 1: 
                case 4: {
                    if (logger.isTraceEnabled()) {
                        logger.trace("Scheduling a key-frame, because we received an RTCP PLI or FIR.");
                    }
                    this.keyFrameRequest();
                    break;
                }
            }
        }
    }

    public void setAdditionalCodecSettings(Map<String, String> additionalCodecSettings) {
        this.additionalCodecSettings = additionalCodecSettings;
    }

    public Format setInputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.inputFormats)) {
            return null;
        }
        YUVFormat yuvFormat = (YUVFormat)format;
        if (yuvFormat.getOffsetU() > yuvFormat.getOffsetV()) {
            return null;
        }
        this.inputFormat = AbstractCodec2.specialize(yuvFormat, Format.byteArray);
        return this.inputFormat;
    }

    public void setKeyFrameControl(KeyFrameControl keyFrameControl) {
        if (this.keyFrameControl != keyFrameControl) {
            if (this.keyFrameControl != null && this.keyFrameRequestee != null) {
                this.keyFrameControl.removeKeyFrameRequestee(this.keyFrameRequestee);
            }
            this.keyFrameControl = keyFrameControl;
            if (this.keyFrameControl != null && this.keyFrameRequestee != null) {
                this.keyFrameControl.addKeyFrameRequestee(-1, this.keyFrameRequestee);
            }
        }
    }

    public Format setOutputFormat(Format format) {
        if (!(format instanceof VideoFormat) || null == AbstractCodec2.matches(format, this.getMatchingOutputFormats(this.inputFormat))) {
            return null;
        }
        VideoFormat videoFormat = (VideoFormat)format;
        Dimension size = null;
        if (this.inputFormat != null) {
            size = ((VideoFormat)this.inputFormat).getSize();
        }
        if (size == null && format.matches(this.outputFormat)) {
            size = ((VideoFormat)this.outputFormat).getSize();
        }
        Map<String, String> fmtps = null;
        if (format instanceof ParameterizedVideoFormat) {
            fmtps = ((ParameterizedVideoFormat)format).getFormatParameters();
        }
        if (fmtps == null) {
            fmtps = new HashMap<String, String>();
        }
        if (this.packetizationMode != null) {
            fmtps.put("packetization-mode", this.packetizationMode);
        }
        this.outputFormat = new ParameterizedVideoFormat(videoFormat.getEncoding(), size, -1, Format.byteArray, videoFormat.getFrameRate(), fmtps);
        return this.outputFormat;
    }

    public void setPacketizationMode(String packetizationMode) {
        if (packetizationMode == null || "0".equals(packetizationMode)) {
            this.packetizationMode = "0";
        } else if ("1".equals(packetizationMode)) {
            this.packetizationMode = "1";
        } else {
            throw new IllegalArgumentException("packetizationMode");
        }
    }
}

