/*
 * Decompiled with CFR 0.152.
 */
package net.sf.profiler4j.console.util.task;

import javax.swing.SwingUtilities;
import net.sf.profiler4j.console.util.task.LongTaskExecutorDialog;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class LongTask {
    private Log log = LogFactory.getLog(this.getClass());
    private Throwable error;
    private Object value;
    private LongTaskExecutorDialog dialog;

    public abstract void executeInBackground() throws Exception;

    public void setDialog(LongTaskExecutorDialog dialog) {
        this.dialog = dialog;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    public Throwable getError() {
        return this.error;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setTaskProgress(final int percent) {
        this.log.debug((Object)("Current task progress is " + percent));
        if (this.dialog.getProgressBar().isIndeterminate()) {
            this.dialog.getProgressBar().setIndeterminate(false);
            this.dialog.getProgressBar().setMaximum(100);
            this.dialog.getProgressBar().setStringPainted(true);
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LongTask.this.dialog.getProgressBar().setValue(percent);
                LongTask.this.dialog.getProgressBar().setString(String.valueOf(percent) + "%");
            }
        });
    }

    public void setTaskMessage(final String s) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LongTask.this.dialog.setMessage(s);
            }
        });
    }
}

