/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.spi.base;

import java.util.Arrays;

public class CacheObjectKey {
    public static final String CALLABLE_STATEMENT = "CS";
    public static final String PREPARED_STATEMENT = "PS";
    protected String sql = null;
    protected String statementType = null;
    protected int resultSetType;
    protected int resultSetConcurrency;
    protected int resultSetHoldability;
    protected int autoGeneratedKeys;
    protected int[] columnIndexes;
    protected String[] columnNames;

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public int[] getColumnIndexes() {
        return this.columnIndexes;
    }

    public void setColumnIndexes(int[] columnIndexes) {
        this.columnIndexes = columnIndexes;
    }

    public CacheObjectKey(String sql, String statementType, int resultSetType, int resultSetConcurrency) {
        this.sql = sql;
        this.statementType = statementType;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public CacheObjectKey(String sql, String statementType, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        this.sql = sql;
        this.statementType = statementType;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.resultSetHoldability = resultSetHoldability;
    }

    public CacheObjectKey(String sql, String statementType, int[] columnIndexes) {
        this.sql = sql;
        this.statementType = statementType;
        this.columnIndexes = columnIndexes;
    }

    public CacheObjectKey(String sql, String statementType, String[] columnNames) {
        this.sql = sql;
        this.statementType = statementType;
        this.columnNames = columnNames;
    }

    public CacheObjectKey(String sql, String statementType, int autoGeneratedKeys) {
        this.sql = sql;
        this.statementType = statementType;
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public int getAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public void setAutoGeneratedKeys(int autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public void setResultSetConcurrency(int resultSetConcurrency) {
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public void setResultSetType(int resultSetType) {
        this.resultSetType = resultSetType;
    }

    public int getResultSetHoldability() {
        return this.resultSetHoldability;
    }

    public void setResultSetHoldability(int resultSetHoldability) {
        this.resultSetHoldability = resultSetHoldability;
    }

    public CacheObjectKey() {
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheObjectKey other = (CacheObjectKey)obj;
        if (this.sql == null || other.sql == null || !this.sql.equals(other.sql)) {
            return false;
        }
        if (this.statementType == null || other.statementType == null || !this.statementType.equals(other.statementType)) {
            return false;
        }
        if (this.resultSetType != other.resultSetType) {
            return false;
        }
        if (this.resultSetConcurrency != other.resultSetConcurrency) {
            return false;
        }
        if (this.resultSetHoldability != other.resultSetHoldability) {
            return false;
        }
        if (PREPARED_STATEMENT.equals(other.statementType)) {
            if (this.autoGeneratedKeys != other.autoGeneratedKeys) {
                return false;
            }
            if (this.columnIndexes != null && other.columnIndexes != null && !Arrays.equals(this.columnIndexes, other.columnIndexes)) {
                return false;
            }
            if (this.columnNames != null && other.columnNames != null && !Arrays.equals(this.columnNames, other.columnNames)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + (this.sql != null ? this.sql.hashCode() : 0);
        hash = 41 * hash + (this.statementType != null ? this.statementType.hashCode() : 0);
        hash = 41 * hash + this.resultSetType;
        hash = 41 * hash + this.resultSetConcurrency;
        hash = 41 * hash + this.resultSetHoldability;
        if (PREPARED_STATEMENT.equals(this.statementType)) {
            hash = 41 * hash + this.autoGeneratedKeys;
            if (this.columnIndexes != null) {
                for (int i : this.columnIndexes) {
                    hash = 41 * hash + Integer.valueOf(i).hashCode();
                }
            }
            if (this.columnNames != null) {
                for (String str : this.columnNames) {
                    hash = 41 * hash + str.hashCode();
                }
            }
        }
        return hash;
    }

    public String getStatementType() {
        return this.statementType;
    }

    public void setStatementType(String statementType) {
        this.statementType = statementType;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }
}

