/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.facelets.el;

import com.sun.faces.component.CompositeComponentStackManager;
import com.sun.faces.facelets.el.ContextualCompositeValueExpression;
import com.sun.faces.facelets.el.TagValueExpression;
import com.sun.faces.util.FacesLogger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.MethodExpression;
import javax.el.MethodInfo;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.ValidatorException;
import javax.faces.view.Location;

public class ContextualCompositeMethodExpression
extends MethodExpression {
    private static final long serialVersionUID = -6281398928485392830L;
    private static final Logger LOGGER = FacesLogger.FACELETS_EL.getLogger();
    private final MethodExpression delegate;
    private final ValueExpression source;
    private final Location location;
    private final transient UIComponent cc;

    public ContextualCompositeMethodExpression(ValueExpression source, MethodExpression delegate) {
        this.delegate = delegate;
        this.source = source;
        this.location = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.cc = UIComponent.getCurrentCompositeComponent(ctx);
    }

    public ContextualCompositeMethodExpression(Location location, MethodExpression delegate) {
        this.delegate = delegate;
        this.location = location;
        this.source = null;
        FacesContext ctx = FacesContext.getCurrentInstance();
        this.cc = UIComponent.getCurrentCompositeComponent(ctx);
    }

    public MethodInfo getMethodInfo(ELContext elContext) {
        return this.delegate.getMethodInfo(elContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(ELContext elContext, Object[] objects) {
        FacesContext ctx = (FacesContext)elContext.getContext(FacesContext.class);
        boolean pushed = this.pushCompositeComponent(ctx);
        try {
            Object object = this.delegate.invoke(elContext, objects);
            if (pushed) {
                this.popCompositeComponent(ctx);
            }
            return object;
        }
        catch (Throwable throwable) {
            try {
                if (pushed) {
                    this.popCompositeComponent(ctx);
                }
                throw throwable;
            }
            catch (ELException ele) {
                block14: {
                    if (ele.getCause() != null && ele.getCause() instanceof ValidatorException) {
                        throw (ValidatorException)ele.getCause();
                    }
                    if (this.source != null && ele instanceof MethodNotFoundException) {
                        try {
                            Object fallback = this.source.getValue(elContext);
                            if (fallback != null && fallback instanceof MethodExpression) {
                                return ((MethodExpression)fallback).invoke(elContext, objects);
                            }
                        }
                        catch (ELException ex) {
                            if (ex.getCause() != null && ex.getCause() instanceof ValidatorException) {
                                throw (ValidatorException)ex.getCause();
                            }
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, ele.toString());
                                LOGGER.log(Level.WARNING, "jsf.facelets.el.method.expression.invoke.error: {0} {1}", new Object[]{ex.toString(), this.source.getExpressionString()});
                            }
                            if (ex instanceof MethodNotFoundException) break block14;
                            throw ex;
                        }
                    }
                }
                throw ele;
            }
        }
    }

    public String getExpressionString() {
        return this.delegate.getExpressionString();
    }

    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isLiteralText() {
        return this.delegate.isLiteralText();
    }

    private boolean pushCompositeComponent(FacesContext ctx) {
        ValueExpression orig;
        CompositeComponentStackManager manager = CompositeComponentStackManager.getManager(ctx);
        UIComponent foundCc = null;
        if (this.location != null) {
            foundCc = manager.findCompositeComponentUsingLocation(ctx, this.location);
        } else if (this.source instanceof TagValueExpression && (orig = ((TagValueExpression)this.source).getWrapped()) instanceof ContextualCompositeValueExpression) {
            foundCc = manager.findCompositeComponentUsingLocation(ctx, ((ContextualCompositeValueExpression)orig).getLocation());
        }
        if (null == foundCc) {
            foundCc = this.cc;
        }
        return manager.push(foundCc);
    }

    private void popCompositeComponent(FacesContext ctx) {
        CompositeComponentStackManager manager = CompositeComponentStackManager.getManager(ctx);
        manager.pop();
    }
}

