/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.pfl.dynamic.copyobject.impl;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.WeakHashMap;
import org.glassfish.pfl.dynamic.codegen.impl.Node;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopier;
import org.glassfish.pfl.dynamic.copyobject.impl.ClassCopierBase;
import org.glassfish.pfl.dynamic.copyobject.impl.CodegenCopierGenerator;
import org.glassfish.pfl.dynamic.copyobject.impl.Exceptions;
import org.glassfish.pfl.dynamic.copyobject.impl.PipelineClassCopierFactory;
import org.glassfish.pfl.dynamic.copyobject.spi.Copy;
import org.glassfish.pfl.dynamic.copyobject.spi.CopyInterceptor;
import org.glassfish.pfl.dynamic.copyobject.spi.LibraryClassLoader;
import org.glassfish.pfl.dynamic.copyobject.spi.ReflectiveCopyException;
import sun.corba.Bridge;

public class ClassCopierOrdinaryImpl
extends ClassCopierBase {
    private static final Bridge BRIDGE_REF = AccessController.doPrivileged(new PrivilegedAction<Bridge>(){

        @Override
        public Bridge run() {
            return Bridge.get();
        }
    });
    private static Map<Class<?>, ClassFieldCopier> classToClassFieldCopier = new WeakHashMap();
    private static final Package CODEGEN_SPI = Type.class.getPackage();
    private static final Package CODEGEN_IMPL = Node.class.getPackage();
    private static ThreadLocal<Boolean> isCodegenCopierAllowed = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return Boolean.TRUE;
        }
    };
    private static Map<Class<?>, Constructor<?>> classToConstructor = new WeakHashMap();
    private ClassFieldCopier classFieldCopier;
    private Constructor<?> constructor;
    private Method readResolveMethod;

    private static boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        Package pkg2;
        Package pkg1 = cl1.getPackage();
        return pkg1 == (pkg2 = cl2.getPackage()) || pkg1 != null && pkg1.equals(pkg2);
    }

    private static Method getInheritableMethod(final Class<?> cl, final String name, final Class<?> returnType, final Class<?> ... argTypes) {
        return AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                Class defCl;
                Method meth = null;
                for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
                    try {
                        meth = defCl.getDeclaredMethod(name, argTypes);
                        break;
                    }
                    catch (NoSuchMethodException ex) {
                        continue;
                    }
                }
                if (meth == null || meth.getReturnType() != returnType) {
                    return null;
                }
                meth.setAccessible(true);
                int mods = meth.getModifiers();
                if ((mods & 0x408) != 0) {
                    return null;
                }
                if ((mods & 5) != 0) {
                    return meth;
                }
                if ((mods & 2) != 0) {
                    return cl == defCl ? meth : null;
                }
                return ClassCopierOrdinaryImpl.packageEquals(cl, defCl) ? meth : null;
            }
        });
    }

    private Object resolve(Object obj) {
        if (this.readResolveMethod != null) {
            try {
                return this.readResolveMethod.invoke(obj, new Object[0]);
            }
            catch (Throwable t) {
                throw Exceptions.self.exceptionInReadResolve(obj, t);
            }
        }
        return obj;
    }

    private static boolean useCodegenCopier() {
        return Boolean.getBoolean("org.glassfish.dynamic.codegen.UseCodegenReflectiveCopyobject");
    }

    public static void setCodegenCopierAllowed(boolean flag) {
        isCodegenCopierAllowed.set(flag);
    }

    private static synchronized ClassFieldCopier getClassFieldCopier(final Class<?> cls, final PipelineClassCopierFactory classCopierFactory) throws ReflectiveCopyException {
        ClassFieldCopier copier = classToClassFieldCopier.get(cls);
        if (copier == null) {
            try {
                copier = AccessController.doPrivileged(new PrivilegedExceptionAction<ClassFieldCopier>(){

                    @Override
                    public ClassFieldCopier run() throws ReflectiveCopyException {
                        if (ClassCopierOrdinaryImpl.useCodegenCopier() && ((Boolean)isCodegenCopierAllowed.get()).booleanValue()) {
                            return ClassCopierOrdinaryImpl.makeClassFieldCopierUnsafeCodegenImpl(cls, classCopierFactory);
                        }
                        return new ClassFieldCopierUnsafeImpl(cls, classCopierFactory);
                    }
                });
            }
            catch (PrivilegedActionException exc) {
                throw (ReflectiveCopyException)exc.getException();
            }
            classToClassFieldCopier.put(cls, copier);
        }
        return copier;
    }

    private static synchronized ClassFieldCopier getSuperCopier(PipelineClassCopierFactory ccf, Class<?> cls) throws ReflectiveCopyException {
        Class<?> superClass = cls.getSuperclass();
        ClassFieldCopier superCopier = null;
        if (superClass != Object.class && superClass != null) {
            ClassCopier cachedCopier = ccf.lookupInCache(superClass);
            if (cachedCopier != null && !cachedCopier.isReflectiveClassCopier()) {
                throw Exceptions.self.noClassCopierForSuperclass(superClass);
            }
            if (!ccf.reflectivelyCopyable(superClass)) {
                throw new ReflectiveCopyException("Cannot create ClassFieldCopier for superclass " + superClass.getName() + ": This class cannot be copied.");
            }
            superCopier = ClassCopierOrdinaryImpl.getClassFieldCopier(superClass, ccf);
        }
        return superCopier;
    }

    private static synchronized ClassFieldCopier makeClassFieldCopierUnsafeCodegenImpl(Class<?> cls, PipelineClassCopierFactory classCopierFactory) throws ReflectiveCopyException {
        Constructor<?> cons = classToConstructor.get(cls);
        if (cons == null) {
            String className = "org.glassfish.dynamic.codegen.impl.generated.copiers." + cls.getName() + "Copier";
            CodegenCopierGenerator generator = new CodegenCopierGenerator(className, cls);
            ProtectionDomain pd = cls.getProtectionDomain();
            Class<?> copierClass = generator.create(pd, LibraryClassLoader.getClassLoader());
            try {
                cons = copierClass.getDeclaredConstructor(PipelineClassCopierFactory.class, ClassFieldCopier.class);
            }
            catch (Exception exc) {
                throw new ReflectiveCopyException("Could not access unsafe codegen copier constructor", exc);
            }
            classToConstructor.put(cls, cons);
        }
        ClassFieldCopier copier = null;
        try {
            ClassFieldCopier superCopier = ClassCopierOrdinaryImpl.getSuperCopier(classCopierFactory, cls);
            Object[] args = new Object[]{classCopierFactory, superCopier};
            copier = (ClassFieldCopier)cons.newInstance(args);
        }
        catch (Exception exc) {
            throw new ReflectiveCopyException("Could not create unsafe codegen copier", exc);
        }
        return copier;
    }

    public ClassCopierOrdinaryImpl(PipelineClassCopierFactory ccf, Class<?> cls) throws ReflectiveCopyException {
        super(cls.getName(), true);
        this.classFieldCopier = ClassCopierOrdinaryImpl.getClassFieldCopier(cls, ccf);
        this.constructor = ConstructorFactory.makeConstructor(cls);
        this.readResolveMethod = ClassCopierOrdinaryImpl.getInheritableMethod(cls, "readResolve", Object.class, new Class[0]);
    }

    @Override
    public Object createCopy(Object source) throws ReflectiveCopyException {
        try {
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Exception exc) {
            throw new ReflectiveCopyException("Failure in newInstance for constructor " + this.constructor, exc);
        }
    }

    @Override
    public Object doCopy(Map<Object, Object> oldToNew, Object source, Object result) throws ReflectiveCopyException {
        if (source instanceof CopyInterceptor) {
            ((CopyInterceptor)source).preCopy();
            this.classFieldCopier.copy(oldToNew, source, result);
            ((CopyInterceptor)result).postCopy();
            return this.resolve(result);
        }
        this.classFieldCopier.copy(oldToNew, source, result);
        return this.resolve(result);
    }

    public static interface ClassFieldCopier {
        public void copy(Map<Object, Object> var1, Object var2, Object var3) throws ReflectiveCopyException;
    }

    private static class ClassFieldCopierUnsafeImpl
    implements ClassFieldCopier {
        private Class<?> myClass;
        private long[] fieldOffsets;
        private UnsafeFieldCopier[] fieldCopiers;
        private PipelineClassCopierFactory classCopierFactory;
        private ClassFieldCopier superCopier;
        private static UnsafeFieldCopier byteUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putByte(dest, offset, (byte)0);
            }

            public String toString() {
                return "byteUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier charUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putChar(dest, offset, '\u0000');
            }

            public String toString() {
                return "charUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier shortUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putShort(dest, offset, (short)0);
            }

            public String toString() {
                return "shortUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier intUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putInt(dest, offset, 0);
            }

            public String toString() {
                return "intUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier longUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putLong(dest, offset, 0L);
            }

            public String toString() {
                return "longUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier booleanUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putBoolean(dest, offset, false);
            }

            public String toString() {
                return "booleanUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier floatUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putFloat(dest, offset, 0.0f);
            }

            public String toString() {
                return "floatUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier doubleUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putDouble(dest, offset, 0.0);
            }

            public String toString() {
                return "doubleUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier byteUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                byte value = this.bridge.getByte(src, offset);
                this.bridge.putByte(dest, offset, value);
            }

            public String toString() {
                return "byteUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier charUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                char value = this.bridge.getChar(src, offset);
                this.bridge.putChar(dest, offset, value);
            }

            public String toString() {
                return "charUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier shortUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                short value = this.bridge.getShort(src, offset);
                this.bridge.putShort(dest, offset, value);
            }

            public String toString() {
                return "shortUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier intUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                int value = this.bridge.getInt(src, offset);
                this.bridge.putInt(dest, offset, value);
            }

            public String toString() {
                return "intUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier longUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                long value = this.bridge.getLong(src, offset);
                this.bridge.putLong(dest, offset, value);
            }

            public String toString() {
                return "longUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier booleanUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                boolean value = this.bridge.getBoolean(src, offset);
                this.bridge.putBoolean(dest, offset, value);
            }

            public String toString() {
                return "booleanUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier floatUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                float value = this.bridge.getFloat(src, offset);
                this.bridge.putFloat(dest, offset, value);
            }

            public String toString() {
                return "floatUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier doubleUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                double value = this.bridge.getDouble(src, offset);
                this.bridge.putDouble(dest, offset, value);
            }

            public String toString() {
                return "doubleUnsafeFieldCopier";
            }
        };
        private UnsafeFieldCopier objectUnsafeFieldCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            @Override
            public void copy(Map<Object, Object> oldToNew, long offset, Object src, Object dest) throws ReflectiveCopyException {
                Object obj = this.bridge.getObject(src, offset);
                Object result = null;
                if (obj != null) {
                    ClassCopier copier = ClassFieldCopierUnsafeImpl.this.classCopierFactory.getClassCopier(obj.getClass());
                    result = copier.copy(oldToNew, obj);
                }
                this.bridge.putObject(dest, offset, result);
            }

            public String toString() {
                return "objectUnsafeFieldCopier";
            }
        };
        private static UnsafeFieldCopier objectUnsafeFieldInitializer = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putObject(dest, offset, null);
            }

            public String toString() {
                return "objectUnsafeFieldInitializer";
            }
        };
        private static UnsafeFieldCopier objectUnsafeFieldSourceCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putObject(dest, offset, src);
            }

            public String toString() {
                return "objectUnsafeFieldSourceCopier";
            }
        };
        private static UnsafeFieldCopier objectUnsafeFieldResultCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                this.bridge.putObject(dest, offset, src);
            }

            public String toString() {
                return "objectUnsafeFieldResultCopier";
            }
        };
        private static UnsafeFieldCopier objectUnsafeFieldIdentityCopier = new UnsafeFieldCopier(ClassCopierOrdinaryImpl.access$100()){

            public void copy(Map oldToNew, long offset, Object src, Object dest) {
                Object value = this.bridge.getObject(src, offset);
                this.bridge.putObject(dest, offset, value);
            }

            public String toString() {
                return "objectUnsafeFieldIdentityCopier";
            }
        };

        private UnsafeFieldCopier getPrimitiveFieldInitializer(Class<?> cls) {
            if (cls.equals(Byte.TYPE)) {
                return byteUnsafeFieldInitializer;
            }
            if (cls.equals(Character.TYPE)) {
                return charUnsafeFieldInitializer;
            }
            if (cls.equals(Short.TYPE)) {
                return shortUnsafeFieldInitializer;
            }
            if (cls.equals(Integer.TYPE)) {
                return intUnsafeFieldInitializer;
            }
            if (cls.equals(Long.TYPE)) {
                return longUnsafeFieldInitializer;
            }
            if (cls.equals(Boolean.TYPE)) {
                return booleanUnsafeFieldInitializer;
            }
            if (cls.equals(Float.TYPE)) {
                return floatUnsafeFieldInitializer;
            }
            if (cls.equals(Double.TYPE)) {
                return doubleUnsafeFieldInitializer;
            }
            throw new IllegalArgumentException("cls must be a primitive type");
        }

        private UnsafeFieldCopier getPrimitiveFieldCopier(Class<?> cls) {
            if (cls.equals(Byte.TYPE)) {
                return byteUnsafeFieldCopier;
            }
            if (cls.equals(Character.TYPE)) {
                return charUnsafeFieldCopier;
            }
            if (cls.equals(Short.TYPE)) {
                return shortUnsafeFieldCopier;
            }
            if (cls.equals(Integer.TYPE)) {
                return intUnsafeFieldCopier;
            }
            if (cls.equals(Long.TYPE)) {
                return longUnsafeFieldCopier;
            }
            if (cls.equals(Boolean.TYPE)) {
                return booleanUnsafeFieldCopier;
            }
            if (cls.equals(Float.TYPE)) {
                return floatUnsafeFieldCopier;
            }
            if (cls.equals(Double.TYPE)) {
                return doubleUnsafeFieldCopier;
            }
            throw new IllegalArgumentException("cls must be a primitive type");
        }

        private UnsafeFieldCopier getUnsafeFieldCopier(Field fld) {
            Class<?> defType = fld.getDeclaringClass();
            Class<?> fldType = fld.getType();
            Copy copyAnnotation = fld.getAnnotation(Copy.class);
            if (copyAnnotation == null) {
                if (fldType.isPrimitive()) {
                    return this.getPrimitiveFieldCopier(fldType);
                }
                return this.objectUnsafeFieldCopier;
            }
            switch (copyAnnotation.value()) {
                case RECURSE: {
                    if (fldType.isPrimitive()) {
                        return this.getPrimitiveFieldCopier(fldType);
                    }
                    return this.objectUnsafeFieldCopier;
                }
                case IDENTITY: {
                    if (fldType.isPrimitive()) {
                        return this.getPrimitiveFieldCopier(fldType);
                    }
                    return objectUnsafeFieldIdentityCopier;
                }
                case NULL: {
                    if (fldType.isPrimitive()) {
                        return this.getPrimitiveFieldInitializer(fldType);
                    }
                    return objectUnsafeFieldInitializer;
                }
                case SOURCE: {
                    if (fldType.isAssignableFrom(defType)) {
                        return objectUnsafeFieldSourceCopier;
                    }
                    throw new IllegalArgumentException("Cannot assign field to source object: incompatible types\nField type is " + fldType + " Class type is " + defType);
                }
                case RESULT: {
                    if (fldType.isAssignableFrom(defType)) {
                        return objectUnsafeFieldResultCopier;
                    }
                    throw new IllegalArgumentException("Cannot assign field to result object: incompatible types\nField type is " + fldType + " Class type is " + defType);
                }
            }
            throw new IllegalArgumentException("Unhandled case " + (Object)((Object)copyAnnotation.value()) + " for field " + fld);
        }

        private boolean fieldIsCopyable(Field field) {
            int modifiers = field.getModifiers();
            boolean result = !Modifier.isStatic(modifiers);
            return result;
        }

        public ClassFieldCopierUnsafeImpl(Class<?> cls, PipelineClassCopierFactory ccf) throws ReflectiveCopyException {
            this.myClass = cls;
            this.classCopierFactory = ccf;
            this.superCopier = ClassCopierOrdinaryImpl.getSuperCopier(ccf, cls);
            Field[] fields = cls.getDeclaredFields();
            int numFields = 0;
            for (int ctr = 0; ctr < fields.length; ++ctr) {
                if (!this.fieldIsCopyable(fields[ctr])) continue;
                ++numFields;
            }
            this.fieldOffsets = new long[numFields];
            this.fieldCopiers = new UnsafeFieldCopier[numFields];
            int pos = 0;
            for (int ctr = 0; ctr < fields.length; ++ctr) {
                Field fld = fields[ctr];
                if (!this.fieldIsCopyable(fld)) continue;
                this.fieldOffsets[pos] = BRIDGE_REF.objectFieldOffset(fld);
                this.fieldCopiers[pos] = this.getUnsafeFieldCopier(fld);
                ++pos;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ClassFieldCopierUnsafeImpl[");
            sb.append(this.myClass.getName());
            for (int ctr = 0; ctr < this.fieldOffsets.length; ++ctr) {
                sb.append("\n\t");
                sb.append(this.fieldOffsets[ctr]);
                sb.append(':');
                sb.append(this.fieldCopiers[ctr].toString());
            }
            sb.append("\n]");
            return sb.toString();
        }

        @Override
        public void copy(Map<Object, Object> oldToNew, Object source, Object result) throws ReflectiveCopyException {
            if (this.superCopier != null) {
                ((ClassFieldCopierUnsafeImpl)this.superCopier).copy(oldToNew, source, result);
            }
            for (int ctr = 0; ctr < this.fieldOffsets.length; ++ctr) {
                this.fieldCopiers[ctr].copy(oldToNew, this.fieldOffsets[ctr], source, result);
            }
        }

        private static abstract class UnsafeFieldCopier {
            protected Bridge bridge;

            public UnsafeFieldCopier(Bridge bridge) {
                this.bridge = bridge;
            }

            abstract void copy(Map<Object, Object> var1, long var2, Object var4, Object var5) throws ReflectiveCopyException;
        }
    }

    private static abstract class ConstructorFactory {
        private ConstructorFactory() {
        }

        private static Constructor<?> getExternalizableConstructor(Class<?> cl) {
            try {
                Constructor<?> cons = cl.getDeclaredConstructor(new Class[0]);
                cons.setAccessible(true);
                return (cons.getModifiers() & 1) != 0 ? cons : null;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }

        private static Constructor<?> getSerializableConstructor(Class<?> cl) {
            Class<?> initCl = cl;
            while (Serializable.class.isAssignableFrom(initCl)) {
                if ((initCl = initCl.getSuperclass()) != null) continue;
                return null;
            }
            try {
                Constructor cons = initCl.getDeclaredConstructor(new Class[0]);
                int mods = cons.getModifiers();
                if ((mods & 2) != 0 || (mods & 5) == 0 && !ClassCopierOrdinaryImpl.packageEquals(cl, initCl)) {
                    return null;
                }
                cons = BRIDGE_REF.newConstructorForSerialization(cl, cons);
                cons.setAccessible(true);
                return cons;
            }
            catch (NoSuchMethodException ex) {
                return null;
            }
        }

        private static Constructor<?> getDefaultConstructor(Class<?> cl) {
            Class<?> defCl;
            Constructor cons = null;
            for (defCl = cl; defCl != null; defCl = defCl.getSuperclass()) {
                try {
                    cons = defCl.getDeclaredConstructor(new Class[0]);
                    break;
                }
                catch (NoSuchMethodException ex) {
                    continue;
                }
            }
            if (cons == null) {
                return null;
            }
            Constructor result = defCl == cl ? cons : BRIDGE_REF.newConstructorForSerialization(cl, cons);
            result.setAccessible(true);
            return result;
        }

        private static Constructor<?> makeConstructor(final Class<?> cls) {
            return (Constructor)AccessController.doPrivileged(new PrivilegedAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() {
                    Constructor constructor = Externalizable.class.isAssignableFrom(cls) ? ConstructorFactory.getExternalizableConstructor(cls) : (Serializable.class.isAssignableFrom(cls) ? ConstructorFactory.getSerializableConstructor(cls) : ConstructorFactory.getDefaultConstructor(cls));
                    return constructor;
                }
            });
        }
    }
}

