/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgijdbc;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.osgijdbc.JDBCDriverLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCJarManifestProcessor {
    private static Logger logger = Logger.getLogger(JDBCJarManifestProcessor.class.getPackage().getName());
    private static final String DEFAULT_MAN_VERSION = "2";
    private static final String DEFAULT_IMPORT_PACKAGE = "";
    private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
    public static final String OSGI_RFC_122 = "OSGI_RFC_122";
    private static final Locale locale = Locale.getDefault();

    public static Manifest processManifest(URL url, ClassLoader cl) throws IOException {
        JarInputStream jis = new JarInputStream(url.openStream());
        try {
            File file = new File(url.toURI());
            List<String> embeddedJars = JDBCJarManifestProcessor.getEmbeddedJarsList(file);
            StringBuffer bundleClassPath = JDBCJarManifestProcessor.deriveBundleClassPath(embeddedJars);
            JDBCDriverLoader loader = new JDBCDriverLoader(cl);
            Properties properties = loader.loadDriverInformation(file);
            Properties queryParams = JDBCJarManifestProcessor.readQueryParams(url);
            Manifest oldManifest = jis.getManifest();
            Manifest newManifest = new Manifest(oldManifest);
            Attributes attrs = newManifest.getMainAttributes();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                key = key.replace('.', '_');
                attrs.putValue(key, value);
            }
            attrs.putValue("osgi.jdbc.driver.class".replace('.', '_'), (String)properties.get("java.sql.Driver"));
            attrs.putValue(OSGI_RFC_122, "TRUE");
            JDBCJarManifestProcessor.process(queryParams, attrs, "Bundle-ManifestVersion", DEFAULT_MAN_VERSION);
            String defaultSymName = properties.getProperty("java.sql.Driver");
            JDBCJarManifestProcessor.process(queryParams, attrs, "Bundle-SymbolicName", defaultSymName);
            String version = oldManifest.getMainAttributes().getValue(IMPLEMENTATION_VERSION);
            if (JDBCJarManifestProcessor.isOSGiCompatibleVersion(version)) {
                JDBCJarManifestProcessor.process(queryParams, attrs, "Bundle-Version", version);
            }
            JDBCJarManifestProcessor.process(queryParams, attrs, "Bundle-ClassPath", bundleClassPath.toString());
            JDBCJarManifestProcessor.process(queryParams, attrs, "Export-Package", "*");
            attrs.putValue("DynamicImport-Package", "*");
            Manifest manifest = newManifest;
            return manifest;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        finally {
            jis.close();
        }
    }

    private static boolean isOSGiCompatibleVersion(String version) {
        boolean isCompatible;
        block3: {
            isCompatible = false;
            try {
                if (version != null) {
                    Double.parseDouble(version);
                    isCompatible = true;
                }
            }
            catch (NumberFormatException nfe) {
                if (!logger.isLoggable(Level.FINEST)) break block3;
                logger.finest("Not a OSGi compatible bundle-version [" + version + "] : " + nfe);
            }
        }
        return isCompatible;
    }

    private static StringBuffer deriveBundleClassPath(List<String> embeddedJars) {
        StringBuffer bundleClasspath = new StringBuffer(".");
        for (int i = 0; i < embeddedJars.size(); ++i) {
            bundleClasspath = bundleClasspath.append(",");
            bundleClasspath = bundleClasspath.append(embeddedJars.get(i));
        }
        return bundleClasspath;
    }

    private static List<String> getEmbeddedJarsList(File file) throws IOException {
        ArrayList<String> jarsList = new ArrayList<String>();
        JarFile f = new JarFile(file);
        Enumeration<JarEntry> entries = f.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (entry.isDirectory() || !entry.getName().toLowerCase(locale).endsWith(".jar")) continue;
            jarsList.add(entry.getName());
        }
        return jarsList;
    }

    private static Properties readQueryParams(URL url) {
        Properties queryParams = new Properties();
        String query = url.getQuery();
        if (query != null) {
            StringTokenizer st = new StringTokenizer(query, "&");
            while (st.hasMoreTokens()) {
                String next = st.nextToken();
                int eq = next.indexOf("=");
                String name = next;
                String value = null;
                if (eq != -1) {
                    name = next.substring(0, eq);
                    if (eq + 1 < next.length()) {
                        value = next.substring(eq + 1);
                    }
                }
                queryParams.put(name, value);
            }
            logger.logp(Level.INFO, "JDBCJarManifestProcessor", "readQueryParams", "queryParams = {0}", new Object[]{queryParams});
        }
        return queryParams;
    }

    private static void process(Properties deployerOptions, Attributes developerOptions, String key, String defaultOption) {
        String deployerOption = deployerOptions.getProperty(key);
        String developerOption = developerOptions.getValue(key);
        String finalOption = defaultOption;
        if (deployerOption != null) {
            finalOption = deployerOption;
        } else if (developerOption != null) {
            finalOption = developerOption;
        }
        if (finalOption != developerOption) {
            developerOptions.putValue(key, finalOption);
        }
    }
}

