/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap.ctl;

import com.sun.jndi.ldap.BasicControl;
import com.sun.jndi.ldap.BerEncoder;
import java.io.IOException;

public final class PagedResultsControl
extends BasicControl {
    public static final String OID = "1.2.840.113556.1.4.319";
    private int pageSize;
    private byte[] cookie = new byte[0];
    private static final long serialVersionUID = -8771840635877430549L;

    public PagedResultsControl(int n) throws IOException {
        super(OID, true, null);
        this.pageSize = n;
        this.value = this.setEncodedValue();
    }

    public PagedResultsControl(int n, byte[] byArray, boolean bl) throws IOException {
        super(OID, bl, null);
        this.pageSize = n;
        this.cookie = byArray;
        this.value = this.setEncodedValue();
    }

    private byte[] setEncodedValue() throws IOException {
        BerEncoder berEncoder = new BerEncoder(32);
        berEncoder.beginSeq(48);
        berEncoder.encodeInt(this.pageSize);
        berEncoder.encodeOctetString(this.cookie, 4);
        berEncoder.endSeq();
        return berEncoder.getTrimmedBuf();
    }
}

