/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource.deployer;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.connectors.ConnectorRuntime;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbInterceptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.naming.NamingException;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.deployment.common.RootDeploymentDescriptor;
import org.glassfish.javaee.services.CommonResourceProxy;
import org.glassfish.resourcebase.resources.api.ResourceConflictException;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.glassfish.resourcebase.resources.api.ResourceInfo;
import org.glassfish.resourcebase.resources.naming.ResourceNamingService;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.glassfish.resources.javamail.config.MailResource;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
@ResourceDeployerInfo(value=MailSessionDescriptor.class)
public class MailSessionDeployer
implements ResourceDeployer {
    @Inject
    private Provider<ResourceManagerFactory> resourceManagerFactoryProvider;
    @Inject
    private Provider<CommonResourceProxy> mailSessionProxyProvider;
    @Inject
    private Provider<ResourceNamingService> resourceNamingServiceProvider;
    @Inject
    private ConnectorRuntime runtime;
    private static Logger _logger = LogDomains.getLogger(MailSessionDeployer.class, (String)"javax.enterprise.resource.resourceadapter");

    public void deployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void deployResource(Object resource) throws Exception {
        assert (resource instanceof MailSessionDescriptor);
        MailSessionDescriptor desc = (MailSessionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)desc.getResourceType());
        MyMailResource mailResource = new MyMailResource(desc, resourceName);
        this.getDeployer(mailResource).deployResource((Object)mailResource);
        _logger.log(Level.FINE, "Mail-Session resource is deployed having resource-name [" + desc.getName() + "]");
    }

    public void undeployResource(Object resource) throws Exception {
        assert (resource instanceof MailSessionDescriptor);
        MailSessionDescriptor desc = (MailSessionDescriptor)resource;
        String resourceName = ConnectorsUtil.deriveResourceName((String)desc.getResourceId(), (String)desc.getName(), (JavaEEResourceType)desc.getResourceType());
        MyMailResource mailResource = new MyMailResource(desc, resourceName);
        this.getDeployer(mailResource).undeployResource((Object)mailResource);
        _logger.log(Level.FINE, "Mail-Session resource is undeployed having resource-name [" + desc.getName() + "]");
    }

    public void undeployResource(Object resource, String applicationName, String moduleName) throws Exception {
    }

    public void redeployResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("redeploy() not supported for mail-session type");
    }

    public void enableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("enable() not supported for mail-session type");
    }

    public void disableResource(Object resource) throws Exception {
        throw new UnsupportedOperationException("disable() not supported for mail-session type");
    }

    public boolean handles(Object resource) {
        return resource instanceof MailSessionDescriptor;
    }

    public boolean supportsDynamicReconfiguration() {
        return false;
    }

    public Class[] getProxyClassesForDynamicReconfiguration() {
        return new Class[0];
    }

    public boolean canDeploy(boolean postApplicationDeployment, Collection<Resource> allResources, Resource resource) {
        return this.handles(resource) && !postApplicationDeployment;
    }

    public void validatePreservedResource(com.sun.enterprise.config.serverbeans.Application oldApp, com.sun.enterprise.config.serverbeans.Application newApp, Resource resource, Resources allResources) throws ResourceConflictException {
    }

    private ResourceDeployer getDeployer(Object resource) {
        return ((ResourceManagerFactory)this.resourceManagerFactoryProvider.get()).getResourceDeployer(resource);
    }

    public void registerMailSessions(Application application) {
        String appName = application.getAppName();
        Set bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            this.registerMailSessionDefinitions(appName, (Descriptor)bundle);
            Collection dds = bundle.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.registerMailSessionDefinitions(appName, (Descriptor)dd);
            }
        }
    }

    private void registerMailSessionDefinitions(String appName, Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)descriptor;
            for (Descriptor msd : env.getResourceDescriptors(JavaEEResourceType.MSD)) {
                assert (msd instanceof MailSessionDescriptor);
                this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)msd);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor msd : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    assert (msd instanceof MailSessionDescriptor);
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)msd);
                }
            }
            Set ejbInterceptors = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                for (Descriptor msd : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    assert (msd instanceof MailSessionDescriptor);
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)msd);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                for (Descriptor msd : mbd.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    assert (msd instanceof MailSessionDescriptor);
                    this.registerMSDReferredByApplication(appName, (MailSessionDescriptor)msd);
                }
            }
        }
    }

    private void registerMSDReferredByApplication(String appName, MailSessionDescriptor msd) {
        if (!msd.isDeployed()) {
            CommonResourceProxy proxy = (CommonResourceProxy)this.mailSessionProxyProvider.get();
            ResourceNamingService resourceNamingService = (ResourceNamingService)this.resourceNamingServiceProvider.get();
            proxy.setDescriptor((ResourceDescriptor)msd);
            if (msd.getName().startsWith("java:app/")) {
                msd.setResourceId(appName);
            }
            if (msd.getName().startsWith("java:global/") || msd.getName().startsWith("java:app/")) {
                ResourceInfo resourceInfo = new ResourceInfo(msd.getName(), appName);
                try {
                    resourceNamingService.publishObject(resourceInfo, (Object)proxy, true);
                    msd.setDeployed(true);
                }
                catch (NamingException e) {
                    Object[] params = new Object[]{appName, msd.getName(), e};
                    _logger.log(Level.WARNING, "exception while registering mail-session ", params);
                }
            }
        }
    }

    public void unRegisterMailSessions(Application application) {
        Set bundles = application.getBundleDescriptors();
        for (BundleDescriptor bundle : bundles) {
            this.unRegisterMailSessions((Descriptor)bundle);
            Collection dds = bundle.getExtensionsDescriptors();
            if (dds == null) continue;
            for (RootDeploymentDescriptor dd : dds) {
                this.unRegisterMailSessions((Descriptor)dd);
            }
        }
    }

    private void unRegisterMailSessions(Descriptor descriptor) {
        if (descriptor instanceof JndiNameEnvironment) {
            JndiNameEnvironment env = (JndiNameEnvironment)descriptor;
            for (Descriptor msd : env.getResourceDescriptors(JavaEEResourceType.MSD)) {
                assert (msd instanceof MailSessionDescriptor);
                this.unRegisterMSDReferredByApplication((MailSessionDescriptor)msd);
            }
        }
        if (descriptor instanceof EjbBundleDescriptor) {
            EjbBundleDescriptor ejbDesc = (EjbBundleDescriptor)descriptor;
            Set ejbDescriptors = ejbDesc.getEjbs();
            for (EjbDescriptor ejbDescriptor : ejbDescriptors) {
                for (Descriptor msd : ejbDescriptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    assert (msd instanceof MailSessionDescriptor);
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)msd);
                }
            }
            Set ejbInterceptors = ejbDesc.getInterceptors();
            for (EjbInterceptor ejbInterceptor : ejbInterceptors) {
                for (Descriptor msd : ejbInterceptor.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    assert (msd instanceof MailSessionDescriptor);
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)msd);
                }
            }
        }
        if (descriptor instanceof BundleDescriptor) {
            Set managedBeanDescriptors = ((BundleDescriptor)descriptor).getManagedBeans();
            for (ManagedBeanDescriptor mbd : managedBeanDescriptors) {
                for (Descriptor msd : mbd.getResourceDescriptors(JavaEEResourceType.MSD)) {
                    assert (msd instanceof MailSessionDescriptor);
                    this.unRegisterMSDReferredByApplication((MailSessionDescriptor)msd);
                }
            }
        }
    }

    private void unRegisterMSDReferredByApplication(MailSessionDescriptor msd) {
        try {
            if (msd.isDeployed()) {
                this.undeployResource(msd);
            }
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "exception while unregistering mail-session [ " + msd.getName() + " ]", e);
        }
    }

    abstract class FakeConfigBean
    implements ConfigBeanProxy {
        FakeConfigBean() {
        }

        public ConfigBeanProxy deepCopy(ConfigBeanProxy parent) {
            throw new UnsupportedOperationException();
        }

        public ConfigBeanProxy getParent() {
            return null;
        }

        public <T extends ConfigBeanProxy> T getParent(Class<T> tClass) {
            return null;
        }

        public <T extends ConfigBeanProxy> T createChild(Class<T> tClass) throws TransactionFailure {
            return null;
        }
    }

    class MailSessionProperty
    extends FakeConfigBean
    implements Property {
        private String name;
        private String value;
        private String description;

        MailSessionProperty(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String value) throws PropertyVetoException {
            this.name = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) throws PropertyVetoException {
            this.value = value;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String value) throws PropertyVetoException {
            this.description = value;
        }

        public void injectedInto(Object o) {
        }
    }

    class MyMailResource
    extends FakeConfigBean
    implements MailResource {
        private MailSessionDescriptor desc;
        private String name;

        public MyMailResource(MailSessionDescriptor desc, String name) {
            this.desc = desc;
            this.name = name;
        }

        public String getStoreProtocol() {
            return this.desc.getStoreProtocol();
        }

        public void setStoreProtocol(String value) throws PropertyVetoException {
        }

        public String getStoreProtocolClass() {
            return this.desc.getProperty("mail." + this.getStoreProtocol() + ".class");
        }

        public void setStoreProtocolClass(String value) throws PropertyVetoException {
        }

        public String getTransportProtocol() {
            return this.desc.getTransportProtocol();
        }

        public void setTransportProtocol(String value) throws PropertyVetoException {
        }

        public String getTransportProtocolClass() {
            return this.desc.getProperty("mail." + this.getTransportProtocol() + ".class");
        }

        public void setTransportProtocolClass(String value) throws PropertyVetoException {
        }

        public String getHost() {
            return this.desc.getHost();
        }

        public void setHost(String value) throws PropertyVetoException {
        }

        public String getUser() {
            return this.desc.getUser();
        }

        public void setUser(String value) throws PropertyVetoException {
        }

        public String getFrom() {
            return this.desc.getFrom();
        }

        public void setFrom(String value) throws PropertyVetoException {
        }

        public String getDebug() {
            return String.valueOf(true);
        }

        public void setDebug(String value) throws PropertyVetoException {
        }

        public String getJndiName() {
            return this.name;
        }

        public void setJndiName(String value) throws PropertyVetoException {
        }

        public String getEnabled() {
            return String.valueOf(true);
        }

        public void setEnabled(String value) throws PropertyVetoException {
        }

        public String getDescription() {
            return this.desc.getDescription();
        }

        public void setDescription(String value) throws PropertyVetoException {
        }

        public List<Property> getProperty() {
            ArrayList<Property> props = new ArrayList<Property>();
            for (String key : this.desc.getProperties().stringPropertyNames()) {
                props.add(new MailSessionProperty(key, this.desc.getProperty(key)));
            }
            return props;
        }

        public Property getProperty(String name) {
            return new MailSessionProperty(name, this.desc.getProperty(name));
        }

        public String getPropertyValue(String name) {
            return this.desc.getProperty(name);
        }

        public String getPropertyValue(String name, String defaultValue) {
            String v = this.desc.getProperty(name);
            return v != null ? v : defaultValue;
        }

        public String getObjectType() {
            return null;
        }

        public void setObjectType(String value) throws PropertyVetoException {
        }

        public String getIdentity() {
            return this.name;
        }

        public String getDeploymentOrder() {
            return null;
        }

        public void setDeploymentOrder(String value) {
        }
    }
}

