/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin;

import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.JavaClassRunner;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.StringUtils;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.internal.api.Globals;

public class RestartServer {
    @Inject
    private Provider<GlassFish> glassfishProvider;
    ModulesRegistry registry;
    private Boolean debug = null;
    private Properties props;
    private Logger logger;
    private boolean verbose;
    private String classpath;
    private String classname;
    private String argsString;
    private String[] args;
    private String serverName = "";
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartServer.class);
    private static final String magicProperty = "-DAS_RESTART=" + ProcessUtils.getPid();
    private static final String[] normalProps = new String[]{magicProperty};
    private static final int RESTART_NORMAL = 10;
    private static final int RESTART_DEBUG_ON = 11;
    private static final int RESTART_DEBUG_OFF = 12;
    private static final String[] debuggerProps = new String[]{magicProperty, "-Xdebug", "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=1323"};

    protected final void setDebug(Boolean b) {
        this.debug = b;
    }

    protected final void setRegistry(ModulesRegistry registryIn) {
        this.registry = registryIn;
    }

    protected final void setServerName(String serverNameIn) {
        this.serverName = serverNameIn;
    }

    protected final void doExecute(AdminCommandContext context) {
        try {
            if (this.registry == null) {
                throw new NullPointerException(new LocalStringsImpl(this.getClass()).get("restart.server.internalError", new Object[]{"registry was not set"}));
            }
            this.init(context);
            GlassFish gfKernel = (GlassFish)this.glassfishProvider.get();
            while (gfKernel == null) {
                Thread.sleep(1000L);
                gfKernel = (GlassFish)this.glassfishProvider.get();
            }
            if (!this.verbose) {
                this.reincarnate();
            }
            gfKernel.stop();
        }
        catch (Exception e) {
            context.getLogger().severe(strings.get("restart.server.failure", new Object[]{e}));
        }
        int ret = 10;
        if (this.debug != null) {
            ret = this.debug != false ? 11 : 12;
        }
        System.exit(ret);
    }

    private void init(AdminCommandContext context) throws IOException {
        this.logger = context.getLogger();
        this.props = ((StartupContext)Globals.get(StartupContext.class)).getArguments();
        this.verbose = Boolean.parseBoolean(this.props.getProperty("-verbose", "false"));
        this.logger.info(strings.get("restart.server.init"));
    }

    private void reincarnate() {
        try {
            if (this.setupReincarnationWithAsadmin() || this.setupReincarnationWithOther()) {
                this.doReincarnation();
            } else {
                this.logger.severe(strings.get("restart.server.noStartupInfo", new Object[]{strings.get("restart.server.asadminError"), strings.get("restart.server.nonAsadminError")}));
            }
        }
        catch (RDCException rdce) {
        }
        catch (Exception e) {
            this.logger.severe(strings.get("restart.server.internalError", new Object[]{e}));
        }
    }

    private void doReincarnation() throws RDCException {
        try {
            String[] props = normalProps;
            if (Boolean.parseBoolean(System.getenv("AS_SUPER_DEBUG"))) {
                props = debuggerProps;
            }
            new JavaClassRunner(this.classpath, props, this.classname, this.args);
        }
        catch (Exception e) {
            this.logger.severe(strings.get("restart.server.jvmError", new Object[]{e}));
            throw new RDCException();
        }
    }

    private boolean setupReincarnationWithAsadmin() throws RDCException {
        this.classpath = this.props.getProperty("-asadmin-classpath");
        this.classname = this.props.getProperty("-asadmin-classname");
        this.argsString = this.props.getProperty("-asadmin-args");
        return this.verify("restart.server.asadminError");
    }

    private boolean setupReincarnationWithOther() throws RDCException {
        this.classpath = this.props.getProperty("-startup-classpath");
        this.classname = this.props.getProperty("-startup-classname");
        this.argsString = this.props.getProperty("-startup-args");
        return this.verify("restart.server.nonAsadminError");
    }

    private boolean verify(String errorStringKey) throws RDCException {
        if (this.classpath == null && this.classname == null && this.argsString == null) {
            return false;
        }
        if (!this.ok(this.classpath) || !this.ok(this.classname) || this.argsString == null) {
            this.logger.severe(strings.get(errorStringKey));
            throw new RDCException();
        }
        this.args = this.argsString.split(",,,");
        this.handleDebug();
        return true;
    }

    private void handleDebug() {
        if (this.debug == null) {
            return;
        }
        this.stripDebugFromArgs();
        this.stripOperandFromArgs();
        int oldlen = this.args.length;
        int newlen = oldlen + 2;
        String debugArg = "--debug=" + this.debug.toString();
        String[] newArgs = new String[newlen];
        System.arraycopy(this.args, 0, newArgs, 0, this.args.length);
        newArgs[newlen - 2] = debugArg;
        newArgs[newlen - 1] = this.serverName;
        this.args = newArgs;
    }

    private void stripDebugFromArgs() {
        boolean twoArgs = false;
        int indexOfDebug = -1;
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].startsWith("--debug=")) {
                indexOfDebug = i;
                break;
            }
            if (!this.args[i].startsWith("--debug")) continue;
            indexOfDebug = i;
            if (this.args.length <= i + 1 || !this.args[i + 1].equals("true") && !this.args[i + 1].equals("false")) break;
            twoArgs = true;
            break;
        }
        if (indexOfDebug < 0) {
            return;
        }
        int oldlen = this.args.length;
        int newlen = oldlen - 1;
        if (twoArgs) {
            --newlen;
        }
        String[] newArgs = new String[newlen];
        int ctr = 0;
        for (int i = 0; i < oldlen; ++i) {
            if (i == indexOfDebug || twoArgs && i == indexOfDebug + 1) continue;
            newArgs[ctr++] = this.args[i];
        }
        this.args = newArgs;
    }

    private void stripOperandFromArgs() {
        if (this.args.length < 2 || !StringUtils.ok((String)this.serverName)) {
            return;
        }
        int newlen = this.args.length - 1;
        if (this.serverName.equals(this.args[newlen])) {
            String[] newargs = new String[newlen];
            System.arraycopy(this.args, 0, newargs, 0, newlen);
            this.args = newargs;
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    private static class RDCException
    extends Exception {
        private RDCException() {
        }
    }
}

