/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.osgihttp;

import com.sun.enterprise.web.WebModule;
import java.lang.ref.WeakReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.glassfish.osgihttp.InvocationContext;

public class InvocationContextMgr {
    private static final InvocationContext invCtx = new InvocationContext(){
        private final Logger logger = Logger.getLogger(this.getClass().getPackage().getName());
        private ThreadLocal<WeakReference<ServletContext>> currentSC = new InheritableThreadLocal<WeakReference<ServletContext>>();
        private ThreadLocal<WeakReference<WebModule>> currentWM = new InheritableThreadLocal<WeakReference<WebModule>>();

        public WebModule getWebModule() {
            WeakReference<WebModule> current = this.currentWM.get();
            WebModule result = current != null ? (WebModule)current.get() : null;
            this.logger.logp(Level.FINE, "InvocationContextMgr", "getWebModule", "result = {0}", new Object[]{result});
            return result;
        }

        public void setWebModule(WebModule webModule) {
            this.logger.logp(Level.FINE, "InvocationContextMgr", "setWebModule", "webModule = {0}", new Object[]{webModule});
            this.currentWM.set(webModule != null ? new WeakReference<WebModule>(webModule) : null);
        }
    };

    public static InvocationContext getInvocationContext() {
        return invCtx;
    }
}

