/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.freespace;

import com.db4o.MetaIndex;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.IntObjectVisitor;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.freespace.FreespaceIxAddress;
import com.db4o.internal.freespace.FreespaceIxLength;
import com.db4o.internal.freespace.FreespaceManager;
import com.db4o.internal.ix.IxTree;

public class FreespaceManagerIx
extends FreespaceManager {
    private int _slotAddress;
    private FreespaceIxAddress _addressIx;
    private FreespaceIxLength _lengthIx;
    private boolean _started;
    private Collection4 _xBytes;
    private final boolean _overwriteDeletedSlots;

    FreespaceManagerIx(LocalObjectContainer localObjectContainer) {
        super(localObjectContainer);
        this._overwriteDeletedSlots = localObjectContainer.config().freespaceFiller() != null;
    }

    private void add(int n, int n2) {
        this._addressIx.add(n, n2);
        this._lengthIx.add(n, n2);
    }

    public void beginCommit() {
        if (!this.started()) {
            return;
        }
        FreespaceManagerIx.slotEntryToZeroes(this._file, this._slotAddress);
    }

    public void debug() {
    }

    public void endCommit() {
        if (!this.started()) {
            return;
        }
        if (this._overwriteDeletedSlots) {
            this._xBytes = new Collection4();
        }
        this._addressIx._index.commitFreeSpace(this._lengthIx._index);
        StatefulBuffer statefulBuffer = new StatefulBuffer(this._file.getSystemTransaction(), this._slotAddress, FreespaceManagerIx.slotLength());
        this._addressIx._index._metaIndex.write(statefulBuffer);
        this._lengthIx._index._metaIndex.write(statefulBuffer);
        if (this._overwriteDeletedSlots) {
            statefulBuffer.setID(-99999);
        }
        if (this._file.configImpl().flushFileBuffers()) {
            this._file.syncFiles();
        }
        statefulBuffer.writeEncrypt();
        if (this._overwriteDeletedSlots) {
            Iterator4 iterator4 = this._xBytes.iterator();
            this._xBytes = null;
            while (iterator4.moveNext()) {
                int[] nArray = (int[])iterator4.current();
                this.overwriteDeletedSlots(nArray[0], nArray[1]);
            }
        }
    }

    public int entryCount() {
        return this._addressIx.entryCount();
    }

    public void free(int n, int n2) {
        if (!this.started()) {
            return;
        }
        if (n <= 0) {
            return;
        }
        if (n2 <= this.discardLimit()) {
            return;
        }
        n2 = this._file.blocksFor(n2);
        int n3 = n;
        int n4 = n2;
        this._addressIx.find(n);
        if (this._addressIx.preceding() && this._addressIx.address() + this._addressIx.length() == n) {
            this.remove(this._addressIx.address(), this._addressIx.length());
            n = this._addressIx.address();
            n2 += this._addressIx.length();
            this._addressIx.find(n3);
        }
        if (this._addressIx.subsequent() && n3 + n4 == this._addressIx.address()) {
            this.remove(this._addressIx.address(), this._addressIx.length());
            n2 += this._addressIx.length();
        }
        this.add(n, n2);
        if (this._overwriteDeletedSlots) {
            this.overwriteDeletedSlots(n3, n4);
        }
    }

    public void freeSelf() {
        if (!this.started()) {
            return;
        }
        this._addressIx._index._metaIndex.free(this._file);
        this._lengthIx._index._metaIndex.free(this._file);
    }

    public int freeSize() {
        return this._addressIx.freeSize();
    }

    public int getSlot(int n) {
        if (!this.started()) {
            return 0;
        }
        int n2 = this.getSlot1(n);
        return n2;
    }

    private int getSlot1(int n) {
        if (!this.started()) {
            return 0;
        }
        n = this._file.blocksFor(n);
        this._lengthIx.find(n);
        if (this._lengthIx.match()) {
            this.remove(this._lengthIx.address(), this._lengthIx.length());
            return this._lengthIx.address();
        }
        if (this._lengthIx.subsequent()) {
            int n2 = this._lengthIx.length() - n;
            int n3 = this._lengthIx.address() + n;
            this.remove(this._lengthIx.address(), this._lengthIx.length());
            this.add(n3, n2);
            return this._lengthIx.address();
        }
        return 0;
    }

    public void migrate(final FreespaceManager freespaceManager) {
        if (!this.started()) {
            return;
        }
        final IntObjectVisitor intObjectVisitor = new IntObjectVisitor(){

            public void visit(int n, Object object) {
                freespaceManager.free((Integer)object, n);
            }
        };
        Tree.traverse(this._addressIx._indexTrans.getRoot(), new Visitor4(){

            public void visit(Object object) {
                IxTree ixTree = (IxTree)object;
                ixTree.visitAll(intObjectVisitor);
            }
        });
    }

    public void onNew(LocalObjectContainer localObjectContainer) {
        localObjectContainer.ensureFreespaceSlot();
    }

    public void read(int n) {
    }

    private void remove(int n, int n2) {
        this._addressIx.remove(n, n2);
        this._lengthIx.remove(n, n2);
    }

    public void start(int n) {
        if (this.started()) {
            return;
        }
        this._slotAddress = n;
        MetaIndex metaIndex = new MetaIndex();
        MetaIndex metaIndex2 = new MetaIndex();
        Buffer buffer = new Buffer(FreespaceManagerIx.slotLength());
        buffer.read(this._file, n, 0);
        metaIndex.read(buffer);
        metaIndex2.read(buffer);
        this._addressIx = new FreespaceIxAddress(this._file, metaIndex);
        this._lengthIx = new FreespaceIxLength(this._file, metaIndex2);
        this._started = true;
    }

    private boolean started() {
        return this._started;
    }

    public byte systemType() {
        return 3;
    }

    public int write(boolean bl) {
        return 0;
    }

    private void overwriteDeletedSlots(int n, int n2) {
        if (this._overwriteDeletedSlots) {
            if (this._xBytes == null) {
                this._file.overwriteDeletedBytes(n, n2 *= this.blockSize());
            } else {
                this._xBytes.add(new int[]{n, n2});
            }
        }
    }
}

