/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Comparison4;
import com.db4o.foundation.Iterator4;
import com.db4o.internal.Transaction;
import com.db4o.internal.btree.BTree;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeKeyIterator;
import com.db4o.internal.btree.BTreeRangePointerIterator;
import com.db4o.internal.btree.BTreeRangeVisitor;
import com.db4o.internal.btree.algebra.BTreeRangeSingleIntersect;
import com.db4o.internal.btree.algebra.BTreeRangeSingleUnion;

public class BTreeRangeSingle
implements BTreeRange {
    public static final Comparison4 COMPARISON = new Comparison4(){

        public int compare(Object object, Object object2) {
            BTreeRangeSingle bTreeRangeSingle = (BTreeRangeSingle)object;
            BTreeRangeSingle bTreeRangeSingle2 = (BTreeRangeSingle)object2;
            return bTreeRangeSingle.first().compareTo(bTreeRangeSingle2.first());
        }
    };
    private final Transaction _transaction;
    private final BTree _btree;
    private final BTreePointer _first;
    private final BTreePointer _end;

    public BTreeRangeSingle(Transaction transaction, BTree bTree, BTreePointer bTreePointer, BTreePointer bTreePointer2) {
        if (transaction == null || bTree == null) {
            throw new ArgumentNullException();
        }
        this._transaction = transaction;
        this._btree = bTree;
        this._first = bTreePointer;
        this._end = bTreePointer2;
    }

    public void accept(BTreeRangeVisitor bTreeRangeVisitor) {
        bTreeRangeVisitor.visit(this);
    }

    public boolean isEmpty() {
        return BTreePointer.equals(this._first, this._end);
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        int n = 0;
        Iterator4 iterator4 = this.keys();
        while (iterator4.moveNext()) {
            ++n;
        }
        return n;
    }

    public Iterator4 pointers() {
        return new BTreeRangePointerIterator(this);
    }

    public Iterator4 keys() {
        return new BTreeRangeKeyIterator(this);
    }

    public final BTreePointer end() {
        return this._end;
    }

    public Transaction transaction() {
        return this._transaction;
    }

    public BTreePointer first() {
        return this._first;
    }

    public BTreeRange greater() {
        return this.newBTreeRangeSingle(this._end, null);
    }

    public BTreeRange union(BTreeRange bTreeRange) {
        if (null == bTreeRange) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeSingleUnion(this).dispatch(bTreeRange);
    }

    public boolean adjacent(BTreeRangeSingle bTreeRangeSingle) {
        return BTreePointer.equals(this._end, bTreeRangeSingle._first) || BTreePointer.equals(bTreeRangeSingle._end, this._first);
    }

    public boolean overlaps(BTreeRangeSingle bTreeRangeSingle) {
        return this.firstOverlaps(this, bTreeRangeSingle) || this.firstOverlaps(bTreeRangeSingle, this);
    }

    private boolean firstOverlaps(BTreeRangeSingle bTreeRangeSingle, BTreeRangeSingle bTreeRangeSingle2) {
        return BTreePointer.lessThan(bTreeRangeSingle2._first, bTreeRangeSingle._end) && BTreePointer.lessThan(bTreeRangeSingle._first, bTreeRangeSingle2._end);
    }

    public BTreeRange extendToFirst() {
        return this.newBTreeRangeSingle(this.firstBTreePointer(), this._end);
    }

    public BTreeRange extendToLast() {
        return this.newBTreeRangeSingle(this._first, null);
    }

    public BTreeRange smaller() {
        return this.newBTreeRangeSingle(this.firstBTreePointer(), this._first);
    }

    public BTreeRangeSingle newBTreeRangeSingle(BTreePointer bTreePointer, BTreePointer bTreePointer2) {
        return new BTreeRangeSingle(this.transaction(), this._btree, bTreePointer, bTreePointer2);
    }

    public BTreeRange newEmptyRange() {
        return this.newBTreeRangeSingle(null, null);
    }

    private BTreePointer firstBTreePointer() {
        return this.btree().firstPointer(this.transaction());
    }

    private BTree btree() {
        return this._btree;
    }

    public BTreeRange intersect(BTreeRange bTreeRange) {
        if (null == bTreeRange) {
            throw new ArgumentNullException();
        }
        return new BTreeRangeSingleIntersect(this).dispatch(bTreeRange);
    }

    public BTreeRange extendToLastOf(BTreeRange bTreeRange) {
        BTreeRangeSingle bTreeRangeSingle = this.checkRangeArgument(bTreeRange);
        return this.newBTreeRangeSingle(this._first, bTreeRangeSingle._end);
    }

    public String toString() {
        return "BTreeRangeSingle(first=" + this._first + ", end=" + this._end + ")";
    }

    private BTreeRangeSingle checkRangeArgument(BTreeRange bTreeRange) {
        if (null == bTreeRange) {
            throw new ArgumentNullException();
        }
        BTreeRangeSingle bTreeRangeSingle = (BTreeRangeSingle)bTreeRange;
        if (this.btree() != bTreeRangeSingle.btree()) {
            throw new IllegalArgumentException();
        }
        return bTreeRangeSingle;
    }

    public BTreePointer lastPointer() {
        if (this._end == null) {
            return this.btree().lastPointer(this.transaction());
        }
        return this._end.previous();
    }
}

