/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.btree;

import com.db4o.CorruptionException;
import com.db4o.foundation.ArgumentNullException;
import com.db4o.foundation.Collection4;
import com.db4o.foundation.Hashtable4;
import com.db4o.foundation.Iterator4;
import com.db4o.foundation.Queue4;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.Buffer;
import com.db4o.internal.Config4Impl;
import com.db4o.internal.PersistentBase;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.Transaction;
import com.db4o.internal.TransactionParticipant;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeIntObject;
import com.db4o.internal.btree.BTreeNode;
import com.db4o.internal.btree.BTreeNodeSearchResult;
import com.db4o.internal.btree.BTreePointer;
import com.db4o.internal.btree.BTreeRange;
import com.db4o.internal.btree.BTreeRangeSingle;
import com.db4o.internal.btree.SearchTarget;
import com.db4o.internal.ix.Indexable4;
import com.db4o.internal.mapping.DefragContext;

public class BTree
extends PersistentBase
implements TransactionParticipant {
    private static final byte BTREE_VERSION = 1;
    private static final int DEFRAGMENT_INCREMENT_OFFSET = 9;
    private final Indexable4 _keyHandler;
    private BTreeNode _root;
    private TreeIntObject _nodes;
    private int _size;
    private Visitor4 _removeListener;
    private Hashtable4 _sizesByTransaction;
    protected Queue4 _processing;
    private int _nodeSize;
    int _halfNodeSize;
    private final int _cacheHeight;

    public BTree(Transaction transaction, int n, Indexable4 indexable4) {
        this(transaction, n, indexable4, BTree.config(transaction).bTreeNodeSize(), BTree.config(transaction).bTreeCacheHeight());
    }

    public BTree(Transaction transaction, int n, Indexable4 indexable4, int n2, int n3) {
        if (null == indexable4) {
            throw new ArgumentNullException();
        }
        this._nodeSize = n2;
        this._halfNodeSize = this._nodeSize / 2;
        this._nodeSize = this._halfNodeSize * 2;
        this._cacheHeight = n3;
        this._keyHandler = indexable4;
        this._sizesByTransaction = new Hashtable4();
        if (n == 0) {
            this.setStateDirty();
            this._root = new BTreeNode(this, 0, true, 0, 0, 0);
            this._root.write(transaction.systemTransaction());
            this.addNode(this._root);
            this.write(transaction.systemTransaction());
        } else {
            this.setID(n);
            this.setStateDeactivated();
        }
    }

    public BTreeNode root() {
        return this._root;
    }

    public int nodeSize() {
        return this._nodeSize;
    }

    public void add(Transaction transaction, Object object) {
        this.keyCantBeNull(object);
        this._keyHandler.prepareComparison(object);
        this.ensureDirty(transaction);
        BTreeNode bTreeNode = this._root.add(transaction);
        if (bTreeNode != null && bTreeNode != this._root) {
            this._root = new BTreeNode(transaction, this._root, bTreeNode);
            this._root.write(transaction.systemTransaction());
            this.addNode(this._root);
        }
    }

    public void remove(Transaction transaction, Object object) {
        this.keyCantBeNull(object);
        Iterator4 iterator4 = this.search(transaction, object).pointers();
        if (!iterator4.moveNext()) {
            return;
        }
        BTreePointer bTreePointer = (BTreePointer)iterator4.current();
        this.ensureDirty(transaction);
        BTreeNode bTreeNode = bTreePointer.node();
        bTreeNode.remove(transaction, bTreePointer.index());
    }

    public BTreeRange search(Transaction transaction, Object object) {
        this.keyCantBeNull(object);
        BTreeNodeSearchResult bTreeNodeSearchResult = this.searchLeaf(transaction, object, SearchTarget.LOWEST);
        BTreeNodeSearchResult bTreeNodeSearchResult2 = this.searchLeaf(transaction, object, SearchTarget.HIGHEST);
        return bTreeNodeSearchResult.createIncludingRange(bTreeNodeSearchResult2);
    }

    private void keyCantBeNull(Object object) {
        if (null == object) {
            throw new ArgumentNullException();
        }
    }

    public Indexable4 keyHandler() {
        return this._keyHandler;
    }

    public BTreeNodeSearchResult searchLeaf(Transaction transaction, Object object, SearchTarget searchTarget) {
        this.ensureActive(transaction);
        this._keyHandler.prepareComparison(object);
        return this._root.searchLeaf(transaction, searchTarget);
    }

    public void commit(Transaction transaction) {
        Transaction transaction2 = transaction.systemTransaction();
        Object object = this._sizesByTransaction.get(transaction);
        if (object != null) {
            this._size += ((Integer)object).intValue();
        }
        this._sizesByTransaction.remove(transaction);
        if (this._nodes != null) {
            this.processAllNodes();
            while (this._processing.hasNext()) {
                ((BTreeNode)this._processing.next()).commit(transaction);
            }
            this._processing = null;
            this.writeAllNodes(transaction2);
        }
        this.setStateDirty();
        this.write(transaction2);
        this.purge();
    }

    public void rollback(Transaction transaction) {
        Transaction transaction2 = transaction.systemTransaction();
        this._sizesByTransaction.remove(transaction);
        if (this._nodes == null) {
            return;
        }
        this.processAllNodes();
        while (this._processing.hasNext()) {
            ((BTreeNode)this._processing.next()).rollback(transaction);
        }
        this._processing = null;
        this.writeAllNodes(transaction2);
        this.setStateDirty();
        this.write(transaction2);
        this.purge();
    }

    private void writeAllNodes(final Transaction transaction) {
        if (this._nodes == null) {
            return;
        }
        this._nodes.traverse(new Visitor4(){

            public void visit(Object object) {
                BTreeNode bTreeNode = (BTreeNode)((TreeIntObject)object).getObject();
                bTreeNode.write(transaction);
            }
        });
    }

    private void purge() {
        if (this._nodes == null) {
            return;
        }
        TreeIntObject treeIntObject = this._nodes;
        this._nodes = null;
        if (this._cacheHeight > 0) {
            this._root.markAsCached(this._cacheHeight);
        } else {
            this._root.holdChildrenAsIDs();
            this.addNode(this._root);
        }
        treeIntObject.traverse(new Visitor4(){

            public void visit(Object object) {
                BTreeNode bTreeNode = (BTreeNode)((TreeIntObject)object).getObject();
                bTreeNode.purge();
            }
        });
    }

    private void processAllNodes() {
        this._processing = new Queue4();
        this._nodes.traverse(new Visitor4(){

            public void visit(Object object) {
                BTree.this._processing.add(((TreeIntObject)object).getObject());
            }
        });
    }

    private void ensureActive(Transaction transaction) {
        if (!this.isActive()) {
            this.read(transaction.systemTransaction());
        }
    }

    private void ensureDirty(Transaction transaction) {
        this.ensureActive(transaction);
        transaction.enlist(this);
        this.setStateDirty();
    }

    public byte getIdentifier() {
        return 84;
    }

    public void setRemoveListener(Visitor4 visitor4) {
        this._removeListener = visitor4;
    }

    public int ownLength() {
        return 13;
    }

    BTreeNode produceNode(int n) {
        TreeIntObject treeIntObject = new TreeIntObject(n);
        this._nodes = (TreeIntObject)Tree.add(this._nodes, treeIntObject);
        TreeIntObject treeIntObject2 = (TreeIntObject)treeIntObject.addedOrExisting();
        BTreeNode bTreeNode = (BTreeNode)treeIntObject2.getObject();
        if (bTreeNode == null) {
            bTreeNode = new BTreeNode(n, this);
            treeIntObject2.setObject(bTreeNode);
            this.addToProcessing(bTreeNode);
        }
        return bTreeNode;
    }

    void addNode(BTreeNode bTreeNode) {
        this._nodes = (TreeIntObject)Tree.add(this._nodes, new TreeIntObject(bTreeNode.getID(), bTreeNode));
        this.addToProcessing(bTreeNode);
    }

    void addToProcessing(BTreeNode bTreeNode) {
        if (this._processing != null) {
            this._processing.add(bTreeNode);
        }
    }

    void removeNode(BTreeNode bTreeNode) {
        this._nodes = (TreeIntObject)this._nodes.removeLike(new TreeInt(bTreeNode.getID()));
    }

    void notifyRemoveListener(Object object) {
        if (this._removeListener != null) {
            this._removeListener.visit(object);
        }
    }

    public void readThis(Transaction transaction, Buffer buffer) {
        buffer.incrementOffset(1);
        this._size = buffer.readInt();
        this._nodeSize = buffer.readInt();
        this._halfNodeSize = this.nodeSize() / 2;
        this._root = this.produceNode(buffer.readInt());
    }

    public void writeThis(Transaction transaction, Buffer buffer) {
        buffer.append((byte)1);
        buffer.writeInt(this._size);
        buffer.writeInt(this.nodeSize());
        buffer.writeIDOf(transaction, this._root);
    }

    public int size(Transaction transaction) {
        this.ensureActive(transaction);
        Object object = this._sizesByTransaction.get(transaction);
        if (object != null) {
            return this._size + (Integer)object;
        }
        return this._size;
    }

    public void traverseKeys(Transaction transaction, Visitor4 visitor4) {
        this.ensureActive(transaction);
        if (this._root == null) {
            return;
        }
        this._root.traverseKeys(transaction, visitor4);
    }

    public void sizeChanged(Transaction transaction, int n) {
        Object object = this._sizesByTransaction.get(transaction);
        if (object == null) {
            this._sizesByTransaction.put(transaction, (Object)new Integer(n));
            return;
        }
        this._sizesByTransaction.put(transaction, (Object)new Integer((Integer)object + n));
    }

    public void dispose(Transaction transaction) {
    }

    public BTreePointer firstPointer(Transaction transaction) {
        this.ensureActive(transaction);
        if (null == this._root) {
            return null;
        }
        return this._root.firstPointer(transaction);
    }

    public BTreePointer lastPointer(Transaction transaction) {
        this.ensureActive(transaction);
        if (null == this._root) {
            return null;
        }
        return this._root.lastPointer(transaction);
    }

    public BTree debugLoadFully(Transaction transaction) {
        this.ensureActive(transaction);
        this._root.debugLoadFully(transaction);
        return this;
    }

    private void traverseAllNodes(Transaction transaction, Visitor4 visitor4) {
        this.ensureActive(transaction);
        this._root.traverseAllNodes(transaction, visitor4);
    }

    public void defragIndex(ReaderPair readerPair) {
        readerPair.incrementOffset(9);
        readerPair.copyID();
    }

    public void defragIndexNode(ReaderPair readerPair) {
        BTreeNode.defragIndex(readerPair, this._keyHandler);
    }

    public void defragBTree(final DefragContext defragContext) throws CorruptionException {
        ReaderPair.processCopy(defragContext, this.getID(), new SlotCopyHandler(){

            public void processCopy(ReaderPair readerPair) throws CorruptionException {
                BTree.this.defragIndex(readerPair);
            }
        });
        final CorruptionException[] corruptionExceptionArray = new CorruptionException[]{null};
        try {
            defragContext.traverseAllIndexSlots(this, new Visitor4(){

                public void visit(Object object) {
                    int n = (Integer)object;
                    try {
                        ReaderPair.processCopy(defragContext, n, new SlotCopyHandler(){

                            public void processCopy(ReaderPair readerPair) {
                                BTree.this.defragIndexNode(readerPair);
                            }
                        });
                    }
                    catch (CorruptionException corruptionException) {
                        corruptionExceptionArray[0] = corruptionException;
                        throw new RuntimeException();
                    }
                }
            });
        }
        catch (RuntimeException runtimeException) {
            if (corruptionExceptionArray[0] != null) {
                throw corruptionExceptionArray[0];
            }
            throw runtimeException;
        }
    }

    public int compareKeys(Object object, Object object2) {
        this._keyHandler.prepareComparison(object2);
        return this._keyHandler.compareTo(object);
    }

    private static Config4Impl config(Transaction transaction) {
        if (null == transaction) {
            throw new ArgumentNullException();
        }
        return transaction.stream().configImpl();
    }

    public void free(Transaction transaction) {
        this.freeAllNodeIds(transaction, this.allNodeIds(transaction));
    }

    private void freeAllNodeIds(Transaction transaction, Iterator4 iterator4) {
        while (iterator4.moveNext()) {
            int n = (Integer)iterator4.current();
            transaction.slotFreePointerOnCommit(n);
        }
    }

    public Iterator4 allNodeIds(Transaction transaction) {
        final Collection4 collection4 = new Collection4();
        this.traverseAllNodes(transaction, new Visitor4(){

            public void visit(Object object) {
                collection4.add(new Integer(((BTreeNode)object).getID()));
            }
        });
        return collection4.iterator();
    }

    public BTreeRange asRange(Transaction transaction) {
        return new BTreeRangeSingle(transaction, this, this.firstPointer(transaction), null);
    }
}

