/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.CorruptionException;
import com.db4o.defragment.DefragContextImpl;
import com.db4o.defragment.PassCommand;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.ClassMetadataRepository;
import com.db4o.internal.ReaderPair;
import com.db4o.internal.SlotCopyHandler;
import com.db4o.internal.btree.BTree;

final class SecondPassCommand
implements PassCommand {
    private final int _objectCommitFrequency;
    private int _objectCount = 0;

    public SecondPassCommand(int n) {
        this._objectCommitFrequency = n;
    }

    public void processClass(DefragContextImpl defragContextImpl, final ClassMetadata classMetadata, int n, final int n2) throws CorruptionException {
        if (defragContextImpl.mappedID(n, -1) == -1) {
            System.err.println("MAPPING NOT FOUND: " + n);
        }
        ReaderPair.processCopy(defragContextImpl, n, new SlotCopyHandler(){

            public void processCopy(ReaderPair readerPair) throws CorruptionException {
                classMetadata.defragClass(readerPair, n2);
            }
        });
    }

    public void processObjectSlot(final DefragContextImpl defragContextImpl, ClassMetadata classMetadata, int n, boolean bl) throws CorruptionException {
        ReaderPair.processCopy(defragContextImpl, n, new SlotCopyHandler(){

            public void processCopy(ReaderPair readerPair) {
                ClassMetadata.defragObject(readerPair);
                if (SecondPassCommand.this._objectCommitFrequency > 0) {
                    SecondPassCommand.this._objectCount++;
                    if (SecondPassCommand.this._objectCount == SecondPassCommand.this._objectCommitFrequency) {
                        defragContextImpl.targetCommit();
                        SecondPassCommand.this._objectCount = 0;
                    }
                }
            }
        }, bl);
    }

    public void processClassCollection(DefragContextImpl defragContextImpl) throws CorruptionException {
        ReaderPair.processCopy(defragContextImpl, defragContextImpl.sourceClassCollectionID(), new SlotCopyHandler(){

            public void processCopy(ReaderPair readerPair) {
                ClassMetadataRepository.defrag(readerPair);
            }
        });
    }

    public void processBTree(DefragContextImpl defragContextImpl, BTree bTree) throws CorruptionException {
        bTree.defragBTree(defragContextImpl);
    }

    public void flush(DefragContextImpl defragContextImpl) {
    }
}

