/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.views.explorer;

import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.persist.IFolderChild;
import org.rssowl.core.persist.IMark;
import org.rssowl.ui.internal.EntityGroup;

public class BookMarkSorter
extends ViewerComparator {
    private static final int SKIP_SORT = 0;
    private Type fType = Type.DEFAULT_SORTING;

    public void setType(Type type) {
        this.fType = type;
    }

    Type getType() {
        return this.fType;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (this.fType == Type.DEFAULT_SORTING && e1 instanceof IFolderChild && e2 instanceof IFolderChild) {
            return 0;
        }
        if (e1 instanceof IFolder && e2 instanceof IFolder) {
            return this.compareFolders((IFolder)e1, (IFolder)e2);
        }
        if (e1 instanceof IMark && e2 instanceof IMark) {
            return this.compareMarks((IMark)e1, (IMark)e2);
        }
        if (e1 instanceof EntityGroup && e2 instanceof EntityGroup) {
            return this.compareGroups((EntityGroup)e1, (EntityGroup)e2);
        }
        return super.compare(viewer, e1, e2);
    }

    public int category(Object element) {
        if (element instanceof IFolder) {
            return 0;
        }
        return 1;
    }

    private int compareFolders(IFolder folder1, IFolder folder2) {
        if (this.fType == Type.SORT_BY_NAME) {
            return folder1.getName().toLowerCase().compareTo(folder2.getName().toLowerCase());
        }
        return 0;
    }

    private int compareMarks(IMark mark1, IMark mark2) {
        int p2;
        int p1;
        if (this.fType == Type.SORT_BY_NAME) {
            return mark1.getName().toLowerCase().compareTo(mark2.getName().toLowerCase());
        }
        if (this.fType == Type.SORT_BY_LAST_VISIT_DATE) {
            Date d1 = mark1.getLastVisitDate();
            Date d2 = mark2.getLastVisitDate();
            if (d1 != null && d2 != null) {
                return d2.compareTo(d1);
            }
            if (d2 != null) {
                return -1;
            }
            if (d1 != null) {
                return 1;
            }
        } else if (this.fType == Type.SORT_BY_POPULARITY && (p1 = mark1.getPopularity()) != (p2 = mark2.getPopularity())) {
            return p2 > p1 ? -1 : 1;
        }
        return 0;
    }

    private int compareGroups(EntityGroup g1, EntityGroup g2) {
        return g1.getId() < g2.getId() ? -1 : 1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DEFAULT_SORTING,
        SORT_BY_NAME,
        SORT_BY_POPULARITY,
        SORT_BY_LAST_VISIT_DATE;

    }
}

