/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.progress.UIJob;
import org.rssowl.core.util.LoggingSafeRunnable;

public abstract class UIBackgroundJob
extends Job {
    private static final String NAME = "UI-Updater";
    private final Control fControl;
    private final Object fFamily;

    public UIBackgroundJob(Control control) {
        this(control, NAME);
    }

    public UIBackgroundJob(Control control, String name) {
        this(control, name, null);
    }

    public UIBackgroundJob(Control control, String name, Object family) {
        super(name);
        this.fControl = control;
        this.fFamily = family;
    }

    protected abstract void runInBackground(IProgressMonitor var1);

    protected abstract void runInUI(IProgressMonitor var1);

    protected IStatus run(IProgressMonitor monitor) {
        if (this.fControl != null && this.fControl.isDisposed()) {
            return Status.OK_STATUS;
        }
        if (!monitor.isCanceled()) {
            this.synchronizedSafeRunInBackground(monitor);
        }
        UIJob uiJob = new UIJob(NAME){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (UIBackgroundJob.this.fControl != null && UIBackgroundJob.this.fControl.isDisposed()) {
                    return Status.OK_STATUS;
                }
                UIBackgroundJob.this.synchronizedSafeRunInUI(monitor);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                if (UIBackgroundJob.this.fFamily == null) {
                    return super.belongsTo(family);
                }
                return UIBackgroundJob.this.fFamily.equals(family);
            }
        };
        uiJob.setSystem(true);
        uiJob.setUser(false);
        if (!monitor.isCanceled()) {
            uiJob.schedule();
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    public boolean belongsTo(Object family) {
        if (this.fFamily == null) {
            return super.belongsTo(family);
        }
        return this.fFamily.equals(family);
    }

    private synchronized void synchronizedSafeRunInBackground(final IProgressMonitor monitor) {
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                UIBackgroundJob.this.runInBackground(monitor);
            }
        });
    }

    private synchronized void synchronizedSafeRunInUI(final IProgressMonitor monitor) {
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                UIBackgroundJob.this.runInUI(monitor);
            }
        });
    }
}

