/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.services;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.pref.IPreferenceScope;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.CleanUpAction;
import org.rssowl.ui.internal.dialogs.CleanUpReminderDialog;
import org.rssowl.ui.internal.util.JobRunner;

public class CleanUpReminderService {
    private static final long SHELL_MINIMIZED_RESCHEDULE_DELAY = 300000L;
    private final Job fReminderJob;
    private final IPreferenceScope fPreferences = Owl.getPreferenceService().getGlobalScope();

    public CleanUpReminderService() {
        this.fReminderJob = this.createJob();
        this.fReminderJob.setSystem(true);
        this.fReminderJob.setUser(false);
        this.initIfNecessary();
        this.reschedule();
    }

    private void initIfNecessary() {
        long millies;
        if (this.fPreferences.getBoolean(DefaultPreferences.CLEAN_UP_REMINDER_STATE) && (millies = this.fPreferences.getLong(DefaultPreferences.CLEAN_UP_REMINDER_DATE_MILLIES)) == 0L) {
            this.storeNextReminderDate();
        }
    }

    private void reschedule() {
        if (this.fPreferences.getBoolean(DefaultPreferences.CLEAN_UP_REMINDER_STATE)) {
            long nextReminderDate = this.fPreferences.getLong(DefaultPreferences.CLEAN_UP_REMINDER_DATE_MILLIES);
            long diff = nextReminderDate - System.currentTimeMillis();
            this.fReminderJob.schedule(diff > 0L ? diff : 0L);
        }
    }

    private Job createJob() {
        return new Job(""){

            protected IStatus run(final IProgressMonitor monitor) {
                if (!monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                    if (!CleanUpReminderService.this.fPreferences.getBoolean(DefaultPreferences.CLEAN_UP_REMINDER_STATE)) {
                        return Status.OK_STATUS;
                    }
                    final Shell shell = OwlUI.getPrimaryShell();
                    if (shell != null && !monitor.isCanceled() && !Controller.getDefault().isShuttingDown()) {
                        final AtomicBoolean needShortReschedule = new AtomicBoolean(false);
                        JobRunner.runSyncedInUIThread((Widget)shell, new Runnable(){

                            public void run() {
                                if (monitor.isCanceled() || Controller.getDefault().isShuttingDown()) {
                                    return;
                                }
                                CleanUpReminderDialog visibleInstance = CleanUpReminderDialog.getVisibleInstance();
                                if (visibleInstance == null && !shell.isVisible()) {
                                    needShortReschedule.set(true);
                                } else if (visibleInstance == null && new CleanUpReminderDialog(shell).open() == 0) {
                                    OwlUI.restoreWindow(shell);
                                    new CleanUpAction().openWizard(shell);
                                }
                            }
                        });
                        if (needShortReschedule.get()) {
                            CleanUpReminderService.this.fReminderJob.schedule(300000L);
                        } else if (CleanUpReminderService.this.fPreferences.getBoolean(DefaultPreferences.CLEAN_UP_REMINDER_STATE)) {
                            CleanUpReminderService.this.storeNextReminderDate();
                            CleanUpReminderService.this.reschedule();
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void storeNextReminderDate() {
        int days = this.fPreferences.getInteger(DefaultPreferences.CLEAN_UP_REMINDER_DAYS_VALUE);
        this.fPreferences.putLong(DefaultPreferences.CLEAN_UP_REMINDER_DATE_MILLIES, System.currentTimeMillis() + (long)days * 86400000L);
    }

    public void stopService() {
        this.fReminderJob.cancel();
    }
}

