/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.dialogs.importer;

import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.rssowl.core.Owl;
import org.rssowl.core.persist.IFolder;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.StringUtils;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.dialogs.importer.Messages;
import org.rssowl.ui.internal.dialogs.welcome.WelcomeWizard;
import org.rssowl.ui.internal.util.FolderChooser;
import org.rssowl.ui.internal.util.LayoutUtils;

public class ImportTargetPage
extends WizardPage {
    private FolderChooser fFolderChooser;
    private Button fNoSpecificLocationRadio;
    private Button fChooseExistingRadio;
    private Button fCreateNewSetRadio;
    private Text fSetNameInput;
    private Label fSetNameLabel;
    private final IFolder fTargetFolder;

    ImportTargetPage(IFolder targetFolder) {
        super(Messages.ImportTargetPage_CHOOSE_TARGET, Messages.ImportTargetPage_CHOOSE_TARGET, OwlUI.getImageDescriptor("icons/wizban/import_wiz.png"));
        this.fTargetFolder = targetFolder;
        this.setMessage(Messages.ImportTargetPage_CHOOSE_TARGET_FOLDER);
    }

    IFolder getTargetLocation() {
        if (this.fNoSpecificLocationRadio.getSelection()) {
            return null;
        }
        if (this.fChooseExistingRadio.getSelection()) {
            return this.fFolderChooser.getFolder();
        }
        return Owl.getModelFactory().createFolder(null, null, this.fSetNameInput.getText());
    }

    private void updatePageComplete() {
        if (this.fNoSpecificLocationRadio.getSelection() || this.fChooseExistingRadio.getSelection()) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(StringUtils.isSet((String)this.fSetNameInput.getText()));
        }
        if (this.fCreateNewSetRadio.getSelection() && this.newSetExists(this.fSetNameInput.getText())) {
            this.setMessage(NLS.bind((String)Messages.ImportTargetPage_BOOKMARK_EXISTS, (Object)this.fSetNameInput.getText()), 2);
        } else {
            this.setMessage(Messages.ImportTargetPage_CHOOSE_TARGET_FOLDER);
        }
    }

    public void createControl(Composite parent) {
        boolean isWelcome = this.getWizard() instanceof WelcomeWizard;
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        this.fNoSpecificLocationRadio = new Button(container, 16);
        this.fNoSpecificLocationRadio.setText(Messages.ImportTargetPage_DIRECT_IMPORT);
        this.fNoSpecificLocationRadio.setSelection(this.fTargetFolder == null);
        this.fNoSpecificLocationRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTargetPage.this.updatePageComplete();
            }
        });
        this.fChooseExistingRadio = new Button(container, 16);
        this.fChooseExistingRadio.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fChooseExistingRadio.getLayoutData()).verticalIndent = 10;
        this.fChooseExistingRadio.setText(Messages.ImportTargetPage_IMPORT_TO_EXISTING);
        this.fChooseExistingRadio.setSelection(this.fTargetFolder != null);
        Composite folderContainer = new Composite(container, 0);
        folderContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)folderContainer.getLayout()).marginLeft = 15;
        folderContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        IFolder targetFolder = this.fTargetFolder == null ? (IFolder)CoreUtils.loadRootFolders().iterator().next() : this.fTargetFolder;
        this.fFolderChooser = new FolderChooser(folderContainer, targetFolder, null, 2048, true, 5);
        this.fFolderChooser.setLayoutData(new GridData(4, 4, true, true));
        this.fFolderChooser.setExpandStrategy(FolderChooser.ExpandStrategy.PACK);
        this.fFolderChooser.setLayout((Layout)LayoutUtils.createGridLayout(1, 0, 0, 2, 5, false));
        this.fFolderChooser.setBackground(container.getDisplay().getSystemColor(25));
        this.fFolderChooser.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (!ImportTargetPage.this.fChooseExistingRadio.getSelection()) {
                    ImportTargetPage.this.fChooseExistingRadio.setSelection(true);
                    ImportTargetPage.this.fNoSpecificLocationRadio.setSelection(false);
                    ImportTargetPage.this.fCreateNewSetRadio.setSelection(false);
                    ImportTargetPage.this.fSetNameLabel.setEnabled(false);
                    ImportTargetPage.this.fSetNameInput.setEnabled(false);
                    ImportTargetPage.this.updatePageComplete();
                }
            }
        });
        this.fCreateNewSetRadio = new Button(container, 16);
        this.fCreateNewSetRadio.setEnabled(!isWelcome);
        this.fCreateNewSetRadio.setLayoutData((Object)new GridData(4, 1, true, false));
        ((GridData)this.fCreateNewSetRadio.getLayoutData()).verticalIndent = 10;
        this.fCreateNewSetRadio.setText(Messages.ImportTargetPage_IMPORT_TO_NEW_SET);
        this.fCreateNewSetRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportTargetPage.this.fSetNameLabel.setEnabled(ImportTargetPage.this.fCreateNewSetRadio.getSelection());
                ImportTargetPage.this.fSetNameInput.setEnabled(ImportTargetPage.this.fCreateNewSetRadio.getSelection());
                if (ImportTargetPage.this.fCreateNewSetRadio.getSelection()) {
                    ImportTargetPage.this.fSetNameInput.setFocus();
                }
                ImportTargetPage.this.updatePageComplete();
            }
        });
        Composite newBookmarkSetContainer = new Composite(container, 0);
        newBookmarkSetContainer.setLayout((Layout)LayoutUtils.createGridLayout(2, 0, 0));
        ((GridLayout)newBookmarkSetContainer.getLayout()).marginLeft = 15;
        newBookmarkSetContainer.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSetNameLabel = new Label(newBookmarkSetContainer, 0);
        this.fSetNameLabel.setText(Messages.ImportTargetPage_NAME);
        this.fSetNameLabel.setEnabled(false);
        this.fSetNameInput = new Text(newBookmarkSetContainer, 2052);
        this.fSetNameInput.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fSetNameInput.setEnabled(false);
        this.fSetNameInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ImportTargetPage.this.updatePageComplete();
            }
        });
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
    }

    private boolean newSetExists(String name) {
        Set roots = CoreUtils.loadRootFolders();
        for (IFolder root : roots) {
            if (!root.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

