/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.ui.internal.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.persist.pref.DefaultPreferences;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.INewsBin;
import org.rssowl.core.persist.IPersistable;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.ui.internal.Controller;
import org.rssowl.ui.internal.OwlUI;
import org.rssowl.ui.internal.actions.Messages;
import org.rssowl.ui.internal.actions.NewNewsBinAction;
import org.rssowl.ui.internal.undo.CopyOperation;
import org.rssowl.ui.internal.undo.MoveOperation;
import org.rssowl.ui.internal.undo.UndoStack;
import org.rssowl.ui.internal.util.ModelUtils;

public class MoveCopyNewsToBinAction
extends Action {
    private final IStructuredSelection fSelection;
    private final boolean fIsMove;
    private final boolean fIsArchive;
    private INewsBin fBin;

    public static MoveCopyNewsToBinAction createArchiveAction(IStructuredSelection selection, INewsBin archive) {
        return new MoveCopyNewsToBinAction(selection, archive, true, true);
    }

    public MoveCopyNewsToBinAction(IStructuredSelection selection, INewsBin bin, boolean isMove) {
        this(selection, bin, isMove, false);
    }

    private MoveCopyNewsToBinAction(IStructuredSelection selection, INewsBin bin, boolean isMove, boolean isArchive) {
        this.fSelection = selection;
        this.fBin = bin;
        this.fIsMove = isMove;
        this.fIsArchive = isArchive;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fBin != null) {
            boolean isArchive;
            boolean bl = isArchive = this.fBin.getProperty(DefaultPreferences.ARCHIVE_BIN_MARKER) != null;
            if (isArchive) {
                return OwlUI.ARCHIVE;
            }
            return this.fBin.getNewsCount(INews.State.getVisible()) > 0 ? OwlUI.NEWSBIN : OwlUI.NEWSBIN_EMPTY;
        }
        return OwlUI.NEWSBIN;
    }

    public String getText() {
        return this.fBin != null ? this.fBin.getName() : Messages.MoveCopyNewsToBinAction_NEW_NEWSBIN;
    }

    public void run() {
        if (this.fBin == null) {
            NewNewsBinAction action = new NewNewsBinAction();
            action.run(null);
            this.fBin = action.getNewsbin();
        }
        if (this.fBin != null) {
            this.moveCopyToBin();
        }
    }

    private void moveCopyToBin() {
        List objects = this.fSelection.toList();
        Collection<INews> news = ModelUtils.normalize(objects);
        boolean requiresSave = false;
        ArrayList<INews> newsToMoveCopy = new ArrayList<INews>(news.size());
        for (INews newsitem : news) {
            if (this.fBin.containsNews(newsitem)) continue;
            newsToMoveCopy.add(newsitem);
        }
        if (newsToMoveCopy.isEmpty()) {
            return;
        }
        ArrayList<INews> copiedNews = new ArrayList<INews>(newsToMoveCopy.size());
        for (INews newsitem : newsToMoveCopy) {
            INews newsCopy = Owl.getModelFactory().createNews(newsitem, this.fBin);
            copiedNews.add(newsCopy);
            if (newsCopy.getState() == INews.State.NEW) {
                newsCopy.setState(INews.State.UNREAD);
            }
            requiresSave = true;
        }
        Controller.getDefault().getSavedSearchService().forceQuickUpdate();
        if (requiresSave) {
            DynamicDAO.saveAll(copiedNews);
            DynamicDAO.save((IPersistable)this.fBin);
        }
        if (this.fIsMove) {
            UndoStack.getInstance().addOperation(new MoveOperation(newsToMoveCopy, copiedNews, this.fIsArchive));
        } else {
            UndoStack.getInstance().addOperation(new CopyOperation(copiedNews));
        }
        if (this.fIsMove) {
            Controller.getDefault().getSavedSearchService().forceQuickUpdate();
            ((INewsDAO)DynamicDAO.getDAO(INewsDAO.class)).setState(newsToMoveCopy, INews.State.HIDDEN, false, false);
        }
    }
}

