/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.persist;

import java.net.URI;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IEntity;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.ILabel;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.persist.ISource;
import org.rssowl.core.persist.MergeCapable;
import org.rssowl.core.persist.Reparentable;
import org.rssowl.core.persist.reference.FeedLinkReference;
import org.rssowl.core.persist.reference.NewsReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface INews
extends IEntity,
MergeCapable<INews>,
Reparentable<IFeed> {
    public static final int TITLE = 0;
    public static final int LINK = 1;
    public static final int DESCRIPTION = 2;
    public static final int AUTHOR = 3;
    public static final int COMMENTS = 4;
    public static final int GUID = 5;
    public static final int PUBLISH_DATE = 6;
    public static final int MODIFIED_DATE = 7;
    public static final int RECEIVE_DATE = 8;
    public static final int SOURCE = 9;
    public static final int HAS_ATTACHMENTS = 10;
    public static final int ATTACHMENTS_CONTENT = 11;
    public static final int CATEGORIES = 12;
    public static final int IS_FLAGGED = 13;
    public static final int STATE = 14;
    public static final int LABEL = 15;
    public static final int RATING = 16;
    public static final int FEED = 17;
    public static final int AGE_IN_DAYS = 18;
    public static final int LOCATION = 19;
    public static final int PARENT_ID = 20;
    public static final int AGE_IN_MINUTES = 21;

    public void setTitle(String var1);

    public void setLink(URI var1);

    public void setDescription(String var1);

    public void setAuthor(IPerson var1);

    public void setComments(String var1);

    public void setGuid(IGuid var1);

    public void setPublishDate(Date var1);

    public void setReceiveDate(Date var1);

    public void setModifiedDate(Date var1);

    public void setSource(ISource var1);

    public void setInReplyTo(String var1);

    public void addAttachment(IAttachment var1);

    public void addCategory(ICategory var1);

    public void setBase(URI var1);

    public List<ICategory> getCategories();

    public List<IAttachment> getAttachments();

    public IPerson getAuthor();

    public String getComments();

    public String getDescription();

    public IGuid getGuid();

    public URI getLink();

    public Date getPublishDate();

    public Date getModifiedDate();

    public ISource getSource();

    public String getInReplyTo();

    public String getTitle();

    public Date getReceiveDate();

    public URI getBase();

    public void setRating(int var1);

    public int getRating();

    public void setState(State var1);

    public State getState();

    public boolean isFlagged();

    public void setFlagged(boolean var1);

    public Set<ILabel> getLabels();

    public boolean addLabel(ILabel var1);

    public boolean removeLabel(ILabel var1);

    public FeedLinkReference getFeedReference();

    public boolean isVisible();

    public boolean isEquivalent(INews var1);

    public void removeAttachment(IAttachment var1);

    public long getParentId();

    @Override
    public NewsReference toReference();

    public String getFeedLinkAsText();

    public String getLinkAsText();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        NEW,
        READ,
        UNREAD,
        UPDATED,
        HIDDEN,
        DELETED;

        private static final transient Set<State> VISIBLE_STATES;
        private static final transient State[] VALUES;

        static {
            VISIBLE_STATES = EnumSet.of(NEW, READ, UNREAD, UPDATED);
            VALUES = State.values();
        }

        public static final Set<State> getVisible() {
            return Collections.unmodifiableSet(VISIBLE_STATES);
        }

        public static final State getState(int ordinal) {
            return VALUES[ordinal];
        }
    }
}

