/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.persist;

import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.rssowl.core.internal.persist.AbstractEntity;
import org.rssowl.core.internal.persist.ComplexMergeResult;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.reference.AttachmentReference;
import org.rssowl.core.util.MergeUtils;

public class Attachment
extends AbstractEntity
implements IAttachment {
    private String fLink;
    private int fLength;
    private String fType;
    private INews fNews;
    private transient URI fLinkURI;

    protected Attachment() {
    }

    public Attachment(INews news) {
        super(null);
        Assert.isNotNull((Object)news, (String)"The type Attachment requires a News that is not NULL");
        this.fNews = news;
    }

    public Attachment(Long id, INews news) {
        super(id);
        Assert.isNotNull((Object)news, (String)"The type Attachment requires a News that is not NULL");
        this.fNews = news;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Attachment(IAttachment attachment, INews news) {
        IAttachment iAttachment = attachment;
        synchronized (iAttachment) {
            this.setLength(attachment.getLength());
            this.setType(attachment.getType());
            this.setLink(attachment.getLink());
        }
        this.setParent(news);
    }

    public synchronized int getLength() {
        return this.fLength;
    }

    public synchronized void setLength(int length) {
        this.fLength = length;
    }

    public synchronized String getType() {
        return this.fType;
    }

    public synchronized void setType(String type) {
        this.fType = type;
    }

    public synchronized INews getNews() {
        return this.fNews;
    }

    public synchronized void setLink(URI link) {
        if (link == null) {
            this.fLinkURI = null;
            this.fLink = null;
        } else {
            this.fLinkURI = link;
            this.fLink = link.toString();
        }
    }

    public synchronized URI getLink() {
        if (this.fLinkURI == null && this.fLink != null) {
            this.fLinkURI = this.createURI(this.fLink);
        }
        return this.fLinkURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isIdentical(IAttachment attachment) {
        if (this == attachment) {
            return true;
        }
        if (!(attachment instanceof Attachment)) {
            return false;
        }
        IAttachment iAttachment = attachment;
        synchronized (iAttachment) {
            Attachment a = (Attachment)attachment;
            return (this.getId() == null ? a.getId() == null : this.getId().equals(a.getId())) && this.fNews.equals(a.fNews) && (this.fLink == null ? a.fLink == null : this.fLink.equals(a.fLink)) && (this.fType == null ? a.fType == null : this.fType.equals(a.fType)) && this.fLength == a.fLength && (this.getProperties() == null ? a.getProperties() == null : this.getProperties().equals(a.getProperties()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MergeResult merge(IAttachment objectToMerge) {
        Assert.isNotNull((Object)objectToMerge, (String)"objectToMerge");
        IAttachment iAttachment = objectToMerge;
        synchronized (iAttachment) {
            boolean updated = false;
            updated = this.fLength != objectToMerge.getLength();
            this.fLength = objectToMerge.getLength();
            updated = !MergeUtils.equals(this.fType, objectToMerge.getType());
            this.fType = objectToMerge.getType();
            ComplexMergeResult<?> result = MergeUtils.mergeProperties(this, objectToMerge);
            if (updated || result.isStructuralChange()) {
                result.addUpdatedObject(this);
            }
            return result;
        }
    }

    public synchronized void setParent(INews newParent) {
        Assert.isNotNull((Object)newParent, (String)"newParent");
        this.fNews = newParent;
    }

    public AttachmentReference toReference() {
        return new AttachmentReference(this.getIdAsPrimitive());
    }

    public synchronized String toString() {
        return String.valueOf(super.toString()) + "Link = " + this.fLink + ")";
    }

    public synchronized String toLongString() {
        return String.valueOf(super.toString()) + "Link = " + this.fLink + ", Type = " + this.fType + ", Length = " + this.fLength + ", Belongs to News = " + this.fNews.getId() + ")";
    }
}

