/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter.json;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.HashSet;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.interpreter.json.JSONArray;
import org.rssowl.core.internal.interpreter.json.JSONException;
import org.rssowl.core.internal.interpreter.json.JSONObject;
import org.rssowl.core.interpreter.InterpreterException;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.ICategory;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IModelFactory;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.IPerson;
import org.rssowl.core.util.StringUtils;

public class JSONInterpreter {
    private static final String STREAM_ID = "streamId";
    private static final String ORIGIN = "origin";
    private static final String AUTHOR = "author";
    private static final String TYPE = "type";
    private static final String ALTERNATE = "alternate";
    private static final String LENGTH = "length";
    private static final String HREF = "href";
    private static final String ENCLOSURE = "enclosure";
    private static final String CATEGORIES = "categories";
    private static final String ID = "id";
    private static final String SUMMARY = "summary";
    private static final String CONTENT = "content";
    private static final String ITEMS = "items";
    private static final String TEXT_HTML = "text/html";
    private static final String UPDATED = "updated";
    private static final String DESCRIPTION = "description";
    private static final String TITLE = "title";
    private static final String REPLIES = "replies";
    private static final String GOOGLE_LABEL_PART = "/label/";
    private static final String GOOGLE_CATEGORY_PREFIX = "user/";
    private static final String GOOGLE_STATE_READ = "/state/com.google/read";
    private static final String GOOGLE_STATE_UNREAD = "/state/com.google/kept-unread";
    private static final String GOOGLE_STATE_STARRED = "/state/com.google/starred";

    public void interpret(JSONObject json, IFeed feed) throws InterpreterException {
        try {
            this.processFeed(json, feed);
        }
        catch (JSONException e) {
            throw new InterpreterException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
        catch (URISyntaxException e) {
            throw new InterpreterException(Activator.getDefault().createErrorStatus(e.getMessage(), e));
        }
    }

    private void processFeed(JSONObject json, IFeed feed) throws JSONException, URISyntaxException {
        feed.setTitle(this.getString(json, TITLE));
        feed.setPublishDate(this.getDate(json, UPDATED));
        feed.setDescription(this.getString(json, DESCRIPTION));
        feed.setHomepage(this.getAlternateLink(json, TEXT_HTML));
        if (json.has(ITEMS)) {
            JSONArray items = json.getJSONArray(ITEMS);
            int i = 0;
            while (i < items.length()) {
                JSONObject item = items.getJSONObject(i);
                this.processItem(item, feed);
                ++i;
            }
        }
    }

    private void processItem(JSONObject item, IFeed feed) throws JSONException, URISyntaxException {
        String author;
        IModelFactory factory = Owl.getModelFactory();
        INews news = factory.createNews(null, feed, new Date());
        news.setBase(feed.getBase());
        if (item.has(ID)) {
            news.setGuid(factory.createGuid(news, item.getString(ID), true));
        }
        if (item.has(ORIGIN)) {
            JSONObject origin = item.getJSONObject(ORIGIN);
            news.setInReplyTo(this.getString(origin, STREAM_ID));
        }
        news.setTitle(this.getString(item, TITLE));
        news.setPublishDate(this.getDate(item, UPDATED));
        news.setDescription(this.getContent(item));
        news.setLink(this.getAlternateLink(item, TEXT_HTML));
        URI commentsLink = this.getCommentsLink(item, TEXT_HTML);
        if (commentsLink != null) {
            news.setComments(commentsLink.toString());
        }
        if (item.has(AUTHOR) && StringUtils.isSet(author = this.getString(item, AUTHOR))) {
            IPerson person = factory.createPerson(null, news);
            person.setName(author);
        }
        if (item.has(ENCLOSURE)) {
            JSONArray attachments = item.getJSONArray(ENCLOSURE);
            int i = 0;
            while (i < attachments.length()) {
                JSONObject attachment = attachments.getJSONObject(i);
                if (attachment.has(HREF)) {
                    IAttachment att = factory.createAttachment(null, news);
                    att.setLink(new URI(attachment.getString(HREF)));
                    if (attachment.has(LENGTH)) {
                        try {
                            att.setLength(attachment.getInt(LENGTH));
                        }
                        catch (JSONException jSONException) {}
                    }
                    if (attachment.has(TYPE)) {
                        att.setType(attachment.getString(TYPE));
                    }
                }
                ++i;
            }
        }
        HashSet<String> labels = new HashSet<String>(1);
        if (item.has(CATEGORIES)) {
            JSONArray categories = item.getJSONArray(CATEGORIES);
            int i = 0;
            while (i < categories.length()) {
                String category;
                if (!categories.isNull(i) && StringUtils.isSet(category = categories.getString(i))) {
                    String label;
                    if (!category.startsWith(GOOGLE_CATEGORY_PREFIX)) {
                        ICategory cat = factory.createCategory(null, news);
                        cat.setName(category);
                    } else if (category.endsWith(GOOGLE_STATE_READ)) {
                        news.setProperty("org.rssowl.pref.GoogleMarkedRead", Boolean.valueOf(true));
                    } else if (category.endsWith(GOOGLE_STATE_UNREAD)) {
                        news.setProperty("org.rssowl.pref.GoogleMarkedUnRead", Boolean.valueOf(true));
                    } else if (category.endsWith(GOOGLE_STATE_STARRED)) {
                        news.setFlagged(true);
                    } else if (category.contains(GOOGLE_LABEL_PART) && StringUtils.isSet(label = category.substring(category.indexOf(GOOGLE_LABEL_PART) + GOOGLE_LABEL_PART.length()))) {
                        labels.add(label);
                    }
                }
                ++i;
            }
            if (!labels.isEmpty()) {
                news.setProperty("org.rssowl.pref.GoogleLabels", (Serializable)labels.toArray(new String[labels.size()]));
            }
        }
    }

    private URI getAlternateLink(JSONObject obj, String type) throws JSONException, URISyntaxException {
        if (obj.has(ALTERNATE)) {
            JSONArray alternates = obj.getJSONArray(ALTERNATE);
            int i = 0;
            while (i < alternates.length()) {
                JSONObject alternate = alternates.getJSONObject(i);
                if (type.equals(this.getString(alternate, TYPE))) {
                    return this.getURI(alternate, HREF);
                }
                ++i;
            }
        }
        return null;
    }

    private URI getCommentsLink(JSONObject obj, String type) throws JSONException, URISyntaxException {
        if (obj.has(REPLIES)) {
            JSONArray replies = obj.getJSONArray(REPLIES);
            int i = 0;
            while (i < replies.length()) {
                JSONObject reply = replies.getJSONObject(i);
                if (type.equals(this.getString(reply, TYPE))) {
                    return this.getURI(reply, HREF);
                }
                ++i;
            }
        }
        return null;
    }

    private String getString(JSONObject object, String key) throws JSONException {
        return object.has(key) ? object.getString(key) : null;
    }

    private String getContent(JSONObject item) throws JSONException {
        JSONObject contentObj = null;
        if (item.has(CONTENT)) {
            contentObj = item.getJSONObject(CONTENT);
        } else if (item.has(SUMMARY)) {
            contentObj = item.getJSONObject(SUMMARY);
        }
        if (contentObj != null && contentObj.has(CONTENT)) {
            return contentObj.getString(CONTENT);
        }
        return null;
    }

    private URI getURI(JSONObject object, String key) throws URISyntaxException, JSONException {
        return object.has(key) ? new URI(object.getString(key)) : null;
    }

    private Date getDate(JSONObject object, String key) throws JSONException {
        return object.has(key) ? new Date(object.getLong(key) * 1000L) : null;
    }
}

