/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal.interpreter;

import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.rssowl.core.Owl;
import org.rssowl.core.interpreter.IElementHandler;
import org.rssowl.core.interpreter.IFormatInterpreter;
import org.rssowl.core.interpreter.INamespaceHandler;
import org.rssowl.core.persist.IPersistable;

public abstract class BasicInterpreter
implements IFormatInterpreter {
    private String fDefaultNamespaceUri;
    private String fRootElementName;

    protected String getDefaultNamespaceUri() {
        return this.fDefaultNamespaceUri;
    }

    protected void setDefaultNamespaceUri(String defaultNamespaceUri) {
        this.fDefaultNamespaceUri = defaultNamespaceUri;
    }

    protected String getRootElementName() {
        return this.fRootElementName;
    }

    protected void setRootElementName(String rootElementName) {
        this.fRootElementName = rootElementName;
    }

    protected String buildFormat(String format, String version) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(format).append(' ').append(version);
        return strBuf.toString();
    }

    protected void processNamespaceAttributes(Element element, IPersistable parent) {
        if (element.getAttributes().isEmpty()) {
            return;
        }
        List attributes = element.getAttributes();
        for (Attribute attribute : attributes) {
            this.processAttributeExtern(attribute, parent);
        }
    }

    protected boolean processElementExtern(Element element, IPersistable parent) {
        INamespaceHandler handler;
        String name = element.getName().toLowerCase();
        String namespaceURI = element.getNamespaceURI();
        if (this.getDefaultNamespaceUri().equals(namespaceURI)) {
            IElementHandler elementHandler = Owl.getInterpreter().getElementHandler(name, this.getRootElementName());
            if (elementHandler != null) {
                elementHandler.processElement(element, parent);
                return true;
            }
        } else if (!this.getDefaultNamespaceUri().equals(namespaceURI) && namespaceURI != null && (handler = Owl.getInterpreter().getNamespaceHandler(namespaceURI)) != null) {
            handler.processElement(element, parent);
            return true;
        }
        return false;
    }

    protected boolean processAttributeExtern(Attribute attribute, IPersistable parent) {
        INamespaceHandler handler;
        String namespaceURI = attribute.getNamespaceURI();
        if (!this.getDefaultNamespaceUri().equals(namespaceURI) && (handler = Owl.getInterpreter().getNamespaceHandler(namespaceURI)) != null) {
            handler.processAttribute(attribute, parent);
            return true;
        }
        return false;
    }
}

