/*
 * Decompiled with CFR 0.152.
 */
package org.rssowl.core.internal;

import com.db4o.ObjectContainer;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.NoLockFactory;
import org.apache.lucene.store.RAMDirectory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.rssowl.core.IApplicationService;
import org.rssowl.core.INewsAction;
import org.rssowl.core.Owl;
import org.rssowl.core.internal.Activator;
import org.rssowl.core.internal.Messages;
import org.rssowl.core.internal.persist.Description;
import org.rssowl.core.internal.persist.MergeResult;
import org.rssowl.core.internal.persist.News;
import org.rssowl.core.internal.persist.SortedLongArrayList;
import org.rssowl.core.internal.persist.search.Indexer;
import org.rssowl.core.internal.persist.search.ModelSearchImpl;
import org.rssowl.core.internal.persist.search.ModelSearchQueries;
import org.rssowl.core.internal.persist.search.NewsDocument;
import org.rssowl.core.internal.persist.search.SearchDocument;
import org.rssowl.core.internal.persist.service.DBHelper;
import org.rssowl.core.internal.persist.service.DBManager;
import org.rssowl.core.internal.persist.service.DatabaseEvent;
import org.rssowl.core.internal.persist.service.DatabaseListener;
import org.rssowl.core.internal.persist.service.EventManager;
import org.rssowl.core.internal.persist.service.EventsMap;
import org.rssowl.core.persist.IAttachment;
import org.rssowl.core.persist.IBookMark;
import org.rssowl.core.persist.IConditionalGet;
import org.rssowl.core.persist.IFeed;
import org.rssowl.core.persist.IFilterAction;
import org.rssowl.core.persist.IGuid;
import org.rssowl.core.persist.INews;
import org.rssowl.core.persist.ISearch;
import org.rssowl.core.persist.ISearchCondition;
import org.rssowl.core.persist.ISearchFilter;
import org.rssowl.core.persist.dao.DynamicDAO;
import org.rssowl.core.persist.dao.INewsDAO;
import org.rssowl.core.persist.dao.ISearchFilterDAO;
import org.rssowl.core.persist.event.NewsEvent;
import org.rssowl.core.persist.event.runnable.NewsEventRunnable;
import org.rssowl.core.persist.reference.NewsReference;
import org.rssowl.core.util.CoreUtils;
import org.rssowl.core.util.LoggingSafeRunnable;
import org.rssowl.core.util.SyncUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationServiceImpl
implements IApplicationService {
    private static final String NEWS_ACTION_EXTENSION_POINT = "org.rssowl.core.NewsAction";
    private final Map<String, INewsAction> fNewsActions = new HashMap<String, INewsAction>();
    private volatile ObjectContainer fDb;
    private volatile ReadWriteLock fLock;
    private volatile Lock fWriteLock;

    public ApplicationServiceImpl() {
        this.loadNewsActions();
        DBManager.getDefault().addEntityStoreListener(new DatabaseListener(){

            public void databaseOpened(DatabaseEvent event) {
                ApplicationServiceImpl.this.fDb = event.getObjectContainer();
                ApplicationServiceImpl.this.fLock = event.getLock();
                ApplicationServiceImpl.this.fWriteLock = ApplicationServiceImpl.this.fLock.writeLock();
            }

            public void databaseClosed(DatabaseEvent event) {
                ApplicationServiceImpl.this.fDb = null;
            }
        });
    }

    private void loadNewsActions() {
        IConfigurationElement[] elements;
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elements = reg.getConfigurationElementsFor(NEWS_ACTION_EXTENSION_POINT);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            try {
                String id = element.getAttribute("id");
                this.fNewsActions.put(id, (INewsAction)element.createExecutableExtension("class"));
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
            }
            ++n2;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public final void handleFeedReload(IBookMark bookMark, IFeed interpretedFeed, IConditionalGet conditionalGet, boolean deleteConditionalGet, boolean runRetention, IProgressMonitor monitor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[TRYBLOCK]], but top level block is 29[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Set<ISearchFilter> loadEnabledFilters(String feedLink) {
        Collection filters = DynamicDAO.getDAO(ISearchFilterDAO.class).loadAll();
        if (filters.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<ISearchFilter> enabledFilters = new TreeSet<ISearchFilter>(new Comparator<ISearchFilter>(){

            @Override
            public int compare(ISearchFilter f1, ISearchFilter f2) {
                if (f1.equals(f2)) {
                    return 0;
                }
                return f1.getOrder() < f2.getOrder() ? -1 : 1;
            }
        });
        for (ISearchFilter filter : filters) {
            if (!filter.isEnabled()) continue;
            enabledFilters.add(filter);
        }
        if (enabledFilters.isEmpty()) {
            return Collections.emptySet();
        }
        if (!this.needToIndex(enabledFilters)) {
            return enabledFilters;
        }
        CoreUtils.removeFiltersByScope(enabledFilters, feedLink);
        return enabledFilters;
    }

    private boolean needToIndex(Set<ISearchFilter> filters) {
        ISearchFilter firstFilter = filters.iterator().next();
        return firstFilter.getSearch() != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean runNewsFilters(final List<INews> news, String feedLink, IProgressMonitor monitor) throws Exception {
        Set<ISearchFilter> enabledFilters = this.loadEnabledFilters(feedLink);
        if (enabledFilters.isEmpty()) {
            return false;
        }
        if (monitor.isCanceled() || Owl.isShuttingDown()) {
            return false;
        }
        RAMDirectory directory = null;
        final IndexSearcher[] searcher = new IndexSearcher[1];
        if (this.needToIndex(enabledFilters)) {
            boolean indexDescription = this.needToIndexDescription(enabledFilters);
            directory = new RAMDirectory();
            directory.setLockFactory((LockFactory)NoLockFactory.getNoLockFactory());
            try {
                IndexWriter indexWriter = new IndexWriter((Directory)directory, Indexer.createAnalyzer());
                int i = 0;
                while (true) {
                    if (i >= news.size()) {
                        indexWriter.close();
                        searcher[0] = new IndexSearcher((Directory)directory);
                        break;
                    }
                    if (monitor.isCanceled() || Owl.isShuttingDown()) {
                        return false;
                    }
                    NewsDocument document = new NewsDocument(news.get(i));
                    document.addFields(indexDescription);
                    document.getDocument().getField(SearchDocument.ENTITY_ID_TEXT).setValue(String.valueOf(i));
                    indexWriter.addDocument(document.getDocument());
                    ++i;
                }
            }
            catch (Exception e) {
                directory.close();
                throw e;
            }
        }
        ArrayList<INews> filteredNews = new ArrayList<INews>(news.size());
        boolean filterMatchedAll = false;
        for (ISearchFilter filter : enabledFilters) {
            if (filter.getSearch() == null) {
                filterMatchedAll = true;
                ArrayList<INews> remainingNews = new ArrayList<INews>(news);
                remainingNews.removeAll(filteredNews);
                if (remainingNews.isEmpty()) break;
                this.applyFilter(filter, remainingNews);
                break;
            }
            if (directory == null || searcher[0] == null) continue;
            if ((monitor.isCanceled() || Owl.isShuttingDown()) && filteredNews.isEmpty()) {
                return false;
            }
            try {
                final ArrayList<INews> matchingNews = new ArrayList<INews>();
                Query query = ModelSearchQueries.createQuery(filter.getSearch());
                searcher[0].search(query, new HitCollector(){

                    public void collect(int doc, float score) {
                        try {
                            Document document = searcher[0].doc(doc);
                            int index = Integer.valueOf(document.get(SearchDocument.ENTITY_ID_TEXT));
                            matchingNews.add((INews)news.get(index));
                        }
                        catch (CorruptIndexException e) {
                            Activator.getDefault().logError(e.getMessage(), e);
                        }
                        catch (IOException e) {
                            Activator.getDefault().logError(e.getMessage(), e);
                        }
                    }
                });
                matchingNews.removeAll(filteredNews);
                if (matchingNews.isEmpty()) continue;
                this.applyFilter(filter, matchingNews);
                filteredNews.addAll(matchingNews);
            }
            catch (IOException e) {
                directory.close();
                throw e;
            }
        }
        if (directory != null) {
            directory.close();
        }
        return filterMatchedAll || !filteredNews.isEmpty();
    }

    private boolean needToIndexDescription(Set<ISearchFilter> filters) {
        for (ISearchFilter filter : filters) {
            ISearch search = filter.getSearch();
            if (search == null) continue;
            List<ISearchCondition> conditions = search.getSearchConditions();
            for (ISearchCondition condition : conditions) {
                int fieldId = condition.getField().getId();
                if (fieldId != -1 && fieldId != 2) continue;
                return true;
            }
        }
        return false;
    }

    private void applyFilter(final ISearchFilter filter, final List<INews> news) {
        final HashMap replacements = new HashMap();
        Collection<IFilterAction> actions = CoreUtils.getActions(filter);
        for (final IFilterAction action : actions) {
            final INewsAction newsAction = this.fNewsActions.get(action.getActionId());
            if (newsAction == null) continue;
            SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

                public void run() throws Exception {
                    newsAction.run(news, replacements, action.getData());
                }
            });
        }
        SafeRunner.run((ISafeRunnable)new LoggingSafeRunnable(){

            public void run() throws Exception {
                DynamicDAO.getDAO(ISearchFilterDAO.class).fireFilterApplied(filter, news);
            }
        });
    }

    private void lockNewsObjects(MergeResult mergeResult) {
        for (Object object : mergeResult.getUpdatedObjects()) {
            if (!(object instanceof News)) continue;
            ((News)object).acquireReadLockSpecial();
        }
    }

    private void unlockNewsObjects(MergeResult mergeResult) {
        if (mergeResult != null) {
            for (Object object : mergeResult.getUpdatedObjects()) {
                if (!(object instanceof News)) continue;
                News news = (News)object;
                news.releaseReadLockSpecial();
                news.clearTransientDescription();
            }
        }
    }

    private List<INews> getNewNewsAdded(IFeed feed) {
        List<INews> newsList = feed.getNewsByStates(EnumSet.of(INews.State.NEW));
        ListIterator<INews> it = newsList.listIterator(newsList.size());
        while (it.hasPrevious()) {
            INews news = it.previous();
            if (news.getId() == null) continue;
            it.remove();
        }
        return newsList;
    }

    private void updateStateOfUnsavedNewNews(List<INews> news, IProgressMonitor monitor) {
        if (news.isEmpty()) {
            return;
        }
        ArrayList<URI> links = new ArrayList<URI>();
        ArrayList<IGuid> guids = new ArrayList<IGuid>();
        for (INews item : news) {
            if (SyncUtils.isSynchronized(item)) continue;
            if (item.getGuid() != null) {
                guids.add(item.getGuid());
                continue;
            }
            if (item.getLink() == null) continue;
            links.add(item.getLink());
        }
        if (links.isEmpty() && guids.isEmpty()) {
            return;
        }
        ModelSearchImpl modelSearch = (ModelSearchImpl)Owl.getPersistenceService().getModelSearch();
        Map<URI, List<NewsReference>> linkToNewsRefs = modelSearch.searchNewsByLinks(links, false, monitor);
        Map<IGuid, List<NewsReference>> guidToNewsRefs = modelSearch.searchNewsByGuids(guids, false, monitor);
        for (INews item : news) {
            INews resolvedNews;
            NewsReference newsRef;
            if (monitor.isCanceled() || Owl.isShuttingDown()) {
                return;
            }
            List<NewsReference> equivalentNewsRefs = guidToNewsRefs.get(item.getGuid());
            if (equivalentNewsRefs != null && !equivalentNewsRefs.isEmpty()) {
                newsRef = equivalentNewsRefs.get(0);
                resolvedNews = newsRef.resolve();
                if (resolvedNews != null && resolvedNews.isVisible()) {
                    item.setState(resolvedNews.getState());
                    continue;
                }
                this.logWarning(NLS.bind((String)Messages.ApplicationServiceImpl_ERROR_STALE_LUCENE_INDEX, (Object)newsRef.getId()));
                CoreUtils.reportIndexIssue();
                continue;
            }
            equivalentNewsRefs = linkToNewsRefs.get(item.getLink());
            if (equivalentNewsRefs == null || equivalentNewsRefs.isEmpty()) continue;
            newsRef = equivalentNewsRefs.get(0);
            resolvedNews = newsRef.resolve();
            if (resolvedNews != null && resolvedNews.isVisible()) {
                item.setState(resolvedNews.getState());
                continue;
            }
            this.logWarning(NLS.bind((String)Messages.ApplicationServiceImpl_ERROR_STALE_LUCENE_INDEX, (Object)newsRef.getId()));
            CoreUtils.reportIndexIssue();
        }
    }

    private void logWarning(String message) {
        Activator activator = Activator.getDefault();
        activator.getLog().log(activator.createWarningStatus(message, null));
    }

    private void saveFeed(MergeResult mergeResult) {
        SortedLongArrayList descriptionUpdatedIds = new SortedLongArrayList(10);
        for (Object o : mergeResult.getRemovedObjects()) {
            if (o instanceof INews) {
                EventManager.getInstance().addItemBeingDeleted(((INews)o).getFeedReference());
            } else if (o instanceof IAttachment) {
                EventManager.getInstance().addItemBeingDeleted(((IAttachment)o).getNews());
            } else if (o instanceof Description) {
                descriptionUpdatedIds.add(((Description)o).getNews().getId());
            }
            this.fDb.delete(o);
        }
        ArrayList<Object> otherObjects = new ArrayList<Object>();
        for (Object o : mergeResult.getUpdatedObjects()) {
            if (o instanceof INews) {
                DBHelper.saveUpdatedNews(this.fDb, (INews)o);
                continue;
            }
            if (o instanceof Description) {
                descriptionUpdatedIds.add(((Description)o).getNews().getId());
            }
            otherObjects.add(o);
        }
        for (Object o : otherObjects) {
            if (o instanceof IFeed) {
                this.fDb.ext().set(o, 2);
                continue;
            }
            this.fDb.ext().set(o, 1);
        }
        NewsEventRunnable eventRunnables = DBHelper.getNewsEventRunnables(EventsMap.getInstance().getEventRunnables());
        if (eventRunnables != null) {
            for (NewsEvent event : eventRunnables.getAllEvents()) {
                descriptionUpdatedIds.removeByElement(event.getEntity().getId());
            }
        }
        INewsDAO newsDao = DynamicDAO.getDAO(INewsDAO.class);
        int i = 0;
        int c = descriptionUpdatedIds.size();
        while (i < c) {
            long newsId = descriptionUpdatedIds.get(i);
            INews news = (INews)newsDao.load(newsId);
            INews oldNews = DBHelper.peekPersistedNews(this.fDb, news);
            EventsMap.getInstance().putUpdateEvent(new NewsEvent(oldNews, news, false));
            ++i;
        }
    }
}

