/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class LevelController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView homeLevelView;
    private String name;
    private Float elevation;
    private Float floorThickness;
    private Float height;
    private Level[] levels;
    private Integer selectedLevelIndex;

    public LevelController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public DialogView getView() {
        if (this.homeLevelView == null) {
            this.homeLevelView = this.viewFactory.createLevelView(this.preferences, this);
        }
        return this.homeLevelView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        Level level = this.home.getSelectedLevel();
        if (level == null) {
            this.setName(null);
            this.setElevation(null);
            this.setFloorThickness(null);
            this.setHeight(null);
            this.setSelectedLevelIndex(null);
        } else {
            this.setName(level.getName());
            this.setElevation(Float.valueOf(level.getElevation()));
            this.setFloorThickness(Float.valueOf(level.getFloorThickness()));
            this.setHeight(Float.valueOf(level.getHeight()));
            this.setSelectedLevelIndex(this.home.getLevels().indexOf(level));
        }
        this.setLevels(this.duplicate(this.home.getLevels().toArray(new Level[0])));
    }

    private Level[] duplicate(Level[] levelArray) {
        for (int i = 0; i < levelArray.length; ++i) {
            levelArray[i] = levelArray[i].clone();
        }
        return levelArray;
    }

    public boolean isPropertyEditable(Property property) {
        switch (property) {
            case FLOOR_THICKNESS: {
                int n;
                List<Level> list = this.home.getLevels();
                Level level = this.home.getSelectedLevel();
                return level != null && (level.getElevation() > 0.0f || (n = list.indexOf(level)) != 0 && list.get(n - 1).getElevation() != level.getElevation());
            }
        }
        return true;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setFloorThickness(Float f) {
        if (f != this.floorThickness) {
            Float f2 = this.floorThickness;
            this.floorThickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.FLOOR_THICKNESS.name(), f2, f);
        }
    }

    public Float getFloorThickness() {
        return this.floorThickness;
    }

    public void setHeight(Float f) {
        if (f != this.height) {
            Float f2 = this.height;
            this.height = f;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f2, f);
        }
    }

    public Float getHeight() {
        return this.height;
    }

    private void setLevels(Level[] levelArray) {
        if (levelArray != this.levels) {
            Level[] levelArray2 = this.levels;
            this.levels = levelArray;
            this.propertyChangeSupport.firePropertyChange(Property.LEVELS.name(), levelArray2, levelArray);
        }
    }

    public Level[] getLevels() {
        return (Level[])this.levels.clone();
    }

    private void setSelectedLevelIndex(Integer n) {
        if (n != this.selectedLevelIndex) {
            Integer n2 = this.selectedLevelIndex;
            this.selectedLevelIndex = n;
            this.propertyChangeSupport.firePropertyChange(Property.SELECT_LEVEL_INDEX.name(), n2, n);
        }
    }

    public Integer getSelectedLevelIndex() {
        return this.selectedLevelIndex;
    }

    public void modifyLevels() {
        Level level = this.home.getSelectedLevel();
        if (level != null) {
            String string = this.getName();
            Float f = this.getElevation();
            Float f2 = this.getFloorThickness();
            Float f3 = this.getHeight();
            ModifiedLevel modifiedLevel = new ModifiedLevel(level);
            LevelController.doModifyLevel(modifiedLevel, string, f, f2, f3);
            if (this.undoSupport != null) {
                LevelModificationUndoableEdit levelModificationUndoableEdit = new LevelModificationUndoableEdit(this.preferences, modifiedLevel, string, f, f2, f3);
                this.undoSupport.postEdit(levelModificationUndoableEdit);
            }
            if (string != null) {
                this.preferences.addAutoCompletionString("LevelName", string);
            }
        }
    }

    private static void doModifyLevel(ModifiedLevel modifiedLevel, String string, Float f, Float f2, Float f3) {
        Level level = modifiedLevel.getLevel();
        if (string != null) {
            level.setName(string);
        }
        if (f != null) {
            level.setElevation(f.floatValue());
        }
        if (f2 != null) {
            level.setFloorThickness(f2.floatValue());
        }
        if (f3 != null) {
            level.setHeight(f3.floatValue());
        }
    }

    private static void undoModifyLevel(ModifiedLevel modifiedLevel) {
        modifiedLevel.reset();
    }

    private static class ModifiedLevel {
        private final Level level;
        private final String name;
        private final float elevation;
        private final float floorThickness;
        private final float height;

        public ModifiedLevel(Level level) {
            this.level = level;
            this.name = level.getName();
            this.elevation = level.getElevation();
            this.floorThickness = level.getFloorThickness();
            this.height = level.getHeight();
        }

        public Level getLevel() {
            return this.level;
        }

        public void reset() {
            this.level.setName(this.name);
            this.level.setElevation(this.elevation);
            this.level.setFloorThickness(this.floorThickness);
            this.level.setHeight(this.height);
        }
    }

    private static class LevelModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final UserPreferences preferences;
        private final ModifiedLevel modifiedLevel;
        private final String name;
        private final Float elevation;
        private final Float floorThickness;
        private final Float height;

        private LevelModificationUndoableEdit(UserPreferences userPreferences, ModifiedLevel modifiedLevel, String string, Float f, Float f2, Float f3) {
            this.preferences = userPreferences;
            this.modifiedLevel = modifiedLevel;
            this.name = string;
            this.elevation = f;
            this.floorThickness = f2;
            this.height = f3;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            LevelController.undoModifyLevel(this.modifiedLevel);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            LevelController.doModifyLevel(this.modifiedLevel, this.name, this.elevation, this.floorThickness, this.height);
        }

        public String getPresentationName() {
            return this.preferences.getLocalizedString(LevelController.class, "undoModifyLevelName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        NAME,
        ELEVATION,
        FLOOR_THICKNESS,
        HEIGHT,
        LEVELS,
        SELECT_LEVEL_INDEX;

    }
}

