/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.ModelMaterialsController;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;

public class HomeFurnitureController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private final PropertyChangeSupport propertyChangeSupport;
    private TextureChoiceController textureController;
    private ModelMaterialsController modelMaterialsController;
    private DialogView homeFurnitureView;
    private Content icon;
    private String name;
    private String description;
    private BigDecimal price;
    private Boolean nameVisible;
    private Float x;
    private Float y;
    private Float elevation;
    private Integer angleInDegrees;
    private Float angle;
    private Float width;
    private Float proportionalWidth;
    private Float depth;
    private Float proportionalDepth;
    private Float height;
    private Float proportionalHeight;
    private boolean proportional;
    private Integer color;
    private FurniturePaint paint;
    private FurnitureShininess shininess;
    private Boolean visible;
    private Boolean modelMirrored;
    private Boolean basePlanItem;
    private boolean basePlanItemEnabled;
    private boolean lightPowerEditable;
    private Float lightPower;
    private boolean resizable;
    private boolean deformable;
    private boolean texturable;

    public HomeFurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, UndoableEditSupport undoableEditSupport) {
        this(home, userPreferences, viewFactory, null, undoableEditSupport);
    }

    public HomeFurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.undoSupport = undoableEditSupport;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
    }

    public TextureChoiceController getTextureController() {
        if (this.textureController == null && this.contentManager != null) {
            this.textureController = new TextureChoiceController(this.preferences.getLocalizedString(HomeFurnitureController.class, "textureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.textureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurnitureController.this.setPaint(FurniturePaint.TEXTURED);
                }
            });
        }
        return this.textureController;
    }

    public ModelMaterialsController getModelMaterialsController() {
        if (this.modelMaterialsController == null && this.contentManager != null) {
            this.modelMaterialsController = new ModelMaterialsController(this.preferences.getLocalizedString(HomeFurnitureController.class, "modelMaterialsTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.modelMaterialsController.addPropertyChangeListener(ModelMaterialsController.Property.MATERIALS, new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    HomeFurnitureController.this.setPaint(FurniturePaint.MODEL_MATERIALS);
                }
            });
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (HomeFurnitureController.this.getWidth() != null && HomeFurnitureController.this.getDepth() != null && HomeFurnitureController.this.getHeight() != null) {
                        HomeFurnitureController.this.modelMaterialsController.setModelSize(HomeFurnitureController.this.getWidth().floatValue(), HomeFurnitureController.this.getDepth().floatValue(), HomeFurnitureController.this.getHeight().floatValue());
                    }
                }
            };
            this.addPropertyChangeListener(Property.WIDTH, propertyChangeListener);
            this.addPropertyChangeListener(Property.DEPTH, propertyChangeListener);
            this.addPropertyChangeListener(Property.HEIGHT, propertyChangeListener);
        }
        return this.modelMaterialsController;
    }

    public DialogView getView() {
        if (this.homeFurnitureView == null) {
            this.homeFurnitureView = this.viewFactory.createHomeFurnitureView(this.preferences, this);
        }
        return this.homeFurnitureView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        List<HomePieceOfFurniture> list = Home.getFurnitureSubList(this.home.getSelectedItems());
        TextureChoiceController textureChoiceController = this.getTextureController();
        ModelMaterialsController modelMaterialsController = this.getModelMaterialsController();
        if (list.isEmpty()) {
            this.setIcon(null);
            this.setName(null);
            this.setNameVisible(null);
            this.setDescription(null);
            this.setPrice(null);
            this.setAngleInDegrees(null);
            this.setX(null);
            this.setY(null);
            this.setElevation(null);
            this.basePlanItemEnabled = false;
            this.setWidth(null, true, false);
            this.setDepth(null, true, false);
            this.setHeight(null, true, false);
            this.setColor(null);
            if (textureChoiceController != null) {
                textureChoiceController.setTexture(null);
            }
            if (modelMaterialsController != null) {
                modelMaterialsController.setMaterials(null);
                modelMaterialsController.setModel(null);
            }
            this.setPaint(null);
            this.setShininess(null);
            this.setVisible(null);
            this.setModelMirrored(null);
            this.lightPowerEditable = false;
            this.setLightPower(null);
            this.setResizable(true);
            this.setDeformable(true);
            this.setTexturable(true);
            this.setProportional(false);
        } else {
            int n;
            int n2;
            Object object;
            int n3;
            int n4;
            HomePieceOfFurniture homePieceOfFurniture = list.get(0);
            Content content = homePieceOfFurniture.getIcon();
            if (content != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (content.equals(list.get(i).getIcon())) continue;
                    content = null;
                    break;
                }
            }
            this.setIcon(content);
            String string = homePieceOfFurniture.getName();
            if (string != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string.equals(list.get(i).getName())) continue;
                    string = null;
                    break;
                }
            }
            this.setName(string);
            Boolean bl = homePieceOfFurniture.isNameVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl.booleanValue() == list.get(i).isNameVisible()) continue;
                bl = null;
                break;
            }
            this.setNameVisible(bl);
            String string2 = homePieceOfFurniture.getDescription();
            if (string2 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (string2.equals(list.get(i).getDescription())) continue;
                    string2 = null;
                    break;
                }
            }
            this.setDescription(string2);
            BigDecimal bigDecimal = homePieceOfFurniture.getPrice();
            if (bigDecimal != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (bigDecimal.equals(list.get(i).getPrice())) continue;
                    bigDecimal = null;
                    break;
                }
            }
            this.setPrice(bigDecimal);
            Float f = Float.valueOf(homePieceOfFurniture.getAngle());
            for (int i = 1; i < list.size(); ++i) {
                if (f.floatValue() == list.get(i).getAngle()) continue;
                f = null;
                break;
            }
            this.setAngle(f);
            Float f2 = Float.valueOf(homePieceOfFurniture.getX());
            for (int i = 1; i < list.size(); ++i) {
                if (f2.floatValue() == list.get(i).getX()) continue;
                f2 = null;
                break;
            }
            this.setX(f2);
            Float f3 = Float.valueOf(homePieceOfFurniture.getY());
            for (int i = 1; i < list.size(); ++i) {
                if (f3.floatValue() == list.get(i).getY()) continue;
                f3 = null;
                break;
            }
            this.setY(f3);
            Float f4 = Float.valueOf(homePieceOfFurniture.getElevation());
            for (n4 = 1; n4 < list.size(); ++n4) {
                if (f4.floatValue() == list.get(n4).getElevation()) continue;
                f4 = null;
                break;
            }
            this.setElevation(f4);
            n4 = !homePieceOfFurniture.isDoorOrWindow() ? 1 : 0;
            for (int i = 1; n4 == 0 && i < list.size(); ++i) {
                if (list.get(i).isDoorOrWindow()) continue;
                n4 = 1;
            }
            this.basePlanItemEnabled = n4;
            Boolean bl2 = !homePieceOfFurniture.isMovable();
            for (int i = 1; i < list.size(); ++i) {
                if (bl2 == !list.get(i).isMovable()) continue;
                bl2 = null;
                break;
            }
            this.setBasePlanItem(bl2);
            Float f5 = Float.valueOf(homePieceOfFurniture.getWidth());
            for (int i = 1; i < list.size(); ++i) {
                if (f5.floatValue() == list.get(i).getWidth()) continue;
                f5 = null;
                break;
            }
            this.setWidth(f5, true, false);
            Float f6 = Float.valueOf(homePieceOfFurniture.getDepth());
            for (int i = 1; i < list.size(); ++i) {
                if (f6.floatValue() == list.get(i).getDepth()) continue;
                f6 = null;
                break;
            }
            this.setDepth(f6, true, false);
            Float f7 = Float.valueOf(homePieceOfFurniture.getHeight());
            for (int i = 1; i < list.size(); ++i) {
                if (f7.floatValue() == list.get(i).getHeight()) continue;
                f7 = null;
                break;
            }
            this.setHeight(f7, true, false);
            Integer n5 = homePieceOfFurniture.getColor();
            if (n5 != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (n5.equals(list.get(i).getColor())) continue;
                    n5 = null;
                    break;
                }
            }
            this.setColor(n5);
            HomeTexture homeTexture = homePieceOfFurniture.getTexture();
            if (homeTexture != null) {
                for (int i = 1; i < list.size(); ++i) {
                    if (homeTexture.equals(list.get(i).getTexture())) continue;
                    homeTexture = null;
                    break;
                }
            }
            if (textureChoiceController != null) {
                textureChoiceController.setTexture(homeTexture);
            }
            Object[] objectArray = homePieceOfFurniture.getModelMaterials();
            Content content2 = homePieceOfFurniture.getModel();
            if (content2 != null) {
                for (n3 = 1; n3 < list.size(); ++n3) {
                    HomePieceOfFurniture homePieceOfFurniture2 = list.get(n3);
                    if (Arrays.equals(objectArray, homePieceOfFurniture2.getModelMaterials()) && content2 == homePieceOfFurniture2.getModel()) continue;
                    objectArray = null;
                    content2 = null;
                    break;
                }
            }
            if (modelMaterialsController != null) {
                modelMaterialsController.setMaterials((HomeMaterial[])objectArray);
                modelMaterialsController.setModel(content2);
                modelMaterialsController.setModelRotation(homePieceOfFurniture.getModelRotation());
                modelMaterialsController.setBackFaceShown(homePieceOfFurniture.isBackFaceShown());
            }
            n3 = 1;
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (object.getColor() == null && object.getTexture() == null && object.getModelMaterials() == null) continue;
                n3 = 0;
                break;
            }
            if (n5 != null) {
                this.setPaint(FurniturePaint.COLORED);
            } else if (homeTexture != null) {
                this.setPaint(FurniturePaint.TEXTURED);
            } else if (objectArray != null) {
                this.setPaint(FurniturePaint.MODEL_MATERIALS);
            } else if (n3 != 0) {
                this.setPaint(FurniturePaint.DEFAULT);
            } else {
                this.setPaint(null);
            }
            Float f8 = homePieceOfFurniture.getShininess();
            object = f8 == null ? FurnitureShininess.DEFAULT : (f8.floatValue() == 0.0f ? FurnitureShininess.MATT : FurnitureShininess.SHINY);
            for (int i = 1; i < list.size(); ++i) {
                HomePieceOfFurniture homePieceOfFurniture3 = list.get(i);
                if (f8 == homePieceOfFurniture3.getShininess() && (f8 == null || f8.equals(homePieceOfFurniture3.getShininess()))) continue;
                object = null;
                break;
            }
            this.setShininess((FurnitureShininess)((Object)object));
            Boolean bl3 = homePieceOfFurniture.isVisible();
            for (int i = 1; i < list.size(); ++i) {
                if (bl3.booleanValue() == list.get(i).isVisible()) continue;
                bl3 = null;
                break;
            }
            this.setVisible(bl3);
            Boolean bl4 = homePieceOfFurniture.isModelMirrored();
            for (n2 = 1; n2 < list.size(); ++n2) {
                if (bl4.booleanValue() == list.get(n2).isModelMirrored()) continue;
                bl4 = null;
                break;
            }
            this.setModelMirrored(bl4);
            n2 = homePieceOfFurniture instanceof HomeLight;
            for (int i = 1; n2 != 0 && i < list.size(); ++i) {
                if (list.get(i) instanceof HomeLight) continue;
                n2 = 0;
            }
            this.lightPowerEditable = n2;
            if (n2 != 0) {
                Float f9 = Float.valueOf(((HomeLight)homePieceOfFurniture).getPower());
                for (n = 1; n < list.size(); ++n) {
                    if (f9.floatValue() == ((HomeLight)list.get(n)).getPower()) continue;
                    f9 = null;
                    break;
                }
                this.setLightPower(f9);
            } else {
                this.setLightPower(null);
            }
            Boolean bl5 = homePieceOfFurniture.isResizable();
            for (n = 1; n < list.size(); ++n) {
                if (bl5.booleanValue() == list.get(n).isResizable()) continue;
                bl5 = null;
                break;
            }
            this.setResizable(bl5 != null && bl5 != false);
            Boolean bl6 = homePieceOfFurniture.isDeformable();
            for (int i = 1; i < list.size(); ++i) {
                if (bl6.booleanValue() == list.get(i).isDeformable()) continue;
                bl6 = null;
                break;
            }
            this.setDeformable(bl6 != null && bl6 != false);
            if (!this.isDeformable()) {
                this.setProportional(true);
            }
            Boolean bl7 = homePieceOfFurniture.isTexturable();
            for (int i = 1; i < list.size(); ++i) {
                if (bl7.booleanValue() == list.get(i).isTexturable()) continue;
                bl7 = null;
                break;
            }
            this.setTexturable(bl7 == null || bl7 != false);
        }
    }

    public boolean isPropertyEditable(Property property) {
        switch (property) {
            case DESCRIPTION: 
            case PRICE: {
                return false;
            }
            case LIGHT_POWER: {
                return this.isLightPowerEditable();
            }
        }
        return true;
    }

    private void setIcon(Content content) {
        if (content != this.icon) {
            Content content2 = this.icon;
            this.icon = content;
            this.propertyChangeSupport.firePropertyChange(Property.ICON.name(), content2, content);
        }
    }

    public Content getIcon() {
        return this.icon;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setNameVisible(Boolean bl) {
        if (bl != this.nameVisible) {
            Boolean bl2 = this.nameVisible;
            this.nameVisible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.NAME_VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getNameVisible() {
        return this.nameVisible;
    }

    public void setDescription(String string) {
        if (string != this.description) {
            String string2 = this.description;
            this.description = string;
            this.propertyChangeSupport.firePropertyChange(Property.DESCRIPTION.name(), string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setPrice(BigDecimal bigDecimal) {
        if (bigDecimal != this.price) {
            BigDecimal bigDecimal2 = this.price;
            this.price = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.PRICE.name(), bigDecimal2, bigDecimal);
        }
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setX(Float f) {
        if (f != this.x) {
            Float f2 = this.x;
            this.x = f;
            this.propertyChangeSupport.firePropertyChange(Property.X.name(), f2, f);
        }
    }

    public Float getX() {
        return this.x;
    }

    public void setY(Float f) {
        if (f != this.y) {
            Float f2 = this.y;
            this.y = f;
            this.propertyChangeSupport.firePropertyChange(Property.Y.name(), f2, f);
        }
    }

    public Float getY() {
        return this.y;
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setAngleInDegrees(Integer n) {
        if (n != this.angleInDegrees) {
            Integer n2 = this.angleInDegrees;
            this.angleInDegrees = n;
            this.angle = this.angleInDegrees == null ? null : new Float(Math.toRadians(this.angleInDegrees.intValue()));
            this.propertyChangeSupport.firePropertyChange(Property.ANGLE_IN_DEGREES.name(), n2, n);
        }
    }

    public Integer getAngleInDegrees() {
        return this.angleInDegrees;
    }

    public void setAngle(Float f) {
        if (f != this.angle) {
            if (f == null) {
                this.setAngleInDegrees(null);
            } else {
                this.setAngleInDegrees((int)(Math.round(Math.toDegrees(f.floatValue())) + 360L) % 360);
            }
            this.angle = f;
        }
    }

    public Float getAngle() {
        return this.angle;
    }

    public boolean isBasePlanItemEnabled() {
        return this.basePlanItemEnabled;
    }

    public boolean isBasePlanItemEditable() {
        return this.basePlanItemEnabled;
    }

    public void setBasePlanItem(Boolean bl) {
        if (bl != this.basePlanItem) {
            Boolean bl2 = this.basePlanItem;
            this.basePlanItem = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BASE_PLAN_ITEM.name(), bl2, bl);
        }
    }

    public Boolean getBasePlanItem() {
        return this.basePlanItem;
    }

    public void setWidth(Float f) {
        this.setWidth(f, false, this.isProportional());
    }

    private void setWidth(Float f, boolean bl, boolean bl2) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalWidth = f;
        }
        if (f2 == null && this.width != null || f2 != null && !f2.equals(this.width)) {
            Float f4 = this.width;
            this.width = f2;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), f4, f2);
            if (f4 != null && f2 != null && bl2) {
                float f5 = f2.floatValue() / f4.floatValue();
                if (this.proportionalDepth != null) {
                    this.setDepth(Float.valueOf(this.proportionalDepth.floatValue() * f5), true, false);
                }
                if (this.proportionalHeight != null) {
                    this.setHeight(Float.valueOf(this.proportionalHeight.floatValue() * f5), true, false);
                }
            }
        }
    }

    public Float getWidth() {
        return this.width;
    }

    public void setDepth(Float f) {
        this.setDepth(f, false, this.isProportional());
    }

    private void setDepth(Float f, boolean bl, boolean bl2) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalDepth = f;
        }
        if (f2 == null && this.depth != null || f2 != null && !f2.equals(this.depth)) {
            Float f4 = this.depth;
            this.depth = f2;
            this.propertyChangeSupport.firePropertyChange(Property.DEPTH.name(), f4, f2);
            if (f4 != null && f2 != null && bl2) {
                float f5 = f2.floatValue() / f4.floatValue();
                if (this.proportionalWidth != null) {
                    this.setWidth(Float.valueOf(this.proportionalWidth.floatValue() * f5), true, false);
                }
                if (this.proportionalHeight != null) {
                    this.setHeight(Float.valueOf(this.proportionalHeight.floatValue() * f5), true, false);
                }
            }
        }
    }

    public Float getDepth() {
        return this.depth;
    }

    public void setHeight(Float f) {
        this.setHeight(f, false, this.isProportional());
    }

    private void setHeight(Float f, boolean bl, boolean bl2) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalHeight = f;
        }
        if (f2 == null && this.height != null || f2 != null && !f2.equals(this.height)) {
            Float f4 = this.height;
            this.height = f2;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f4, f2);
            if (f4 != null && f2 != null && bl2) {
                float f5 = f2.floatValue() / f4.floatValue();
                if (this.proportionalWidth != null) {
                    this.setWidth(Float.valueOf(this.proportionalWidth.floatValue() * f5), true, false);
                }
                if (this.proportionalDepth != null) {
                    this.setDepth(Float.valueOf(this.proportionalDepth.floatValue() * f5), true, false);
                }
            }
        }
    }

    public Float getHeight() {
        return this.height;
    }

    public void setProportional(boolean bl) {
        if (bl != this.proportional) {
            boolean bl2 = this.proportional;
            this.proportional = bl;
            this.propertyChangeSupport.firePropertyChange(Property.PROPORTIONAL.name(), bl2, bl);
        }
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setPaint(FurniturePaint furniturePaint) {
        if (furniturePaint != this.paint) {
            FurniturePaint furniturePaint2 = this.paint;
            this.paint = furniturePaint;
            this.propertyChangeSupport.firePropertyChange(Property.PAINT.name(), (Object)furniturePaint2, (Object)furniturePaint);
        }
    }

    public FurniturePaint getPaint() {
        return this.paint;
    }

    public void setShininess(FurnitureShininess furnitureShininess) {
        if (furnitureShininess != this.shininess) {
            FurnitureShininess furnitureShininess2 = this.shininess;
            this.shininess = furnitureShininess;
            this.propertyChangeSupport.firePropertyChange(Property.SHININESS.name(), (Object)furnitureShininess2, (Object)furnitureShininess);
        }
    }

    public FurnitureShininess getShininess() {
        return this.shininess;
    }

    public void setVisible(Boolean bl) {
        if (bl != this.visible) {
            Boolean bl2 = this.visible;
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), bl2, bl);
        }
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setModelMirrored(Boolean bl) {
        if (bl != this.modelMirrored) {
            Boolean bl2 = this.modelMirrored;
            this.modelMirrored = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_MIRRORED.name(), bl2, bl);
        }
    }

    public Boolean getModelMirrored() {
        return this.modelMirrored;
    }

    public boolean isLightPowerEditable() {
        return this.lightPowerEditable;
    }

    public Float getLightPower() {
        return this.lightPower;
    }

    public void setLightPower(Float f) {
        if (f != this.lightPower) {
            Float f2 = this.lightPower;
            this.lightPower = f;
            this.propertyChangeSupport.firePropertyChange(Property.LIGHT_POWER.name(), f2, f);
        }
    }

    private void setResizable(boolean bl) {
        if (bl != this.resizable) {
            boolean bl2 = this.resizable;
            this.resizable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RESIZABLE.name(), bl2, bl);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    private void setDeformable(boolean bl) {
        if (bl != this.deformable) {
            boolean bl2 = this.deformable;
            this.deformable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DEFORMABLE.name(), bl2, bl);
        }
    }

    public boolean isDeformable() {
        return this.deformable;
    }

    private void setTexturable(boolean bl) {
        if (bl != this.texturable) {
            boolean bl2 = this.texturable;
            this.texturable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.TEXTURABLE.name(), bl2, bl);
        }
    }

    public boolean isTexturable() {
        return this.texturable;
    }

    public void modifyFurniture() {
        List<Selectable> list = this.home.getSelectedItems();
        List<HomePieceOfFurniture> list2 = Home.getFurnitureSubList(list);
        if (!list2.isEmpty()) {
            Serializable serializable;
            boolean bl;
            String string = this.getName();
            Boolean bl2 = this.getNameVisible();
            String string2 = this.getDescription();
            BigDecimal bigDecimal = this.getPrice();
            Float f = this.getX();
            Float f2 = this.getY();
            Float f3 = this.getElevation();
            Float f4 = this.getAngle();
            Boolean bl3 = this.getBasePlanItem();
            Float f5 = this.getWidth();
            Float f6 = this.getDepth();
            Float f7 = this.getHeight();
            FurniturePaint furniturePaint = this.getPaint();
            Integer n = furniturePaint == FurniturePaint.COLORED ? this.getColor() : null;
            TextureChoiceController textureChoiceController = this.getTextureController();
            HomeTexture homeTexture = textureChoiceController != null && furniturePaint == FurniturePaint.TEXTURED ? textureChoiceController.getTexture() : null;
            ModelMaterialsController modelMaterialsController = this.getModelMaterialsController();
            HomeMaterial[] homeMaterialArray = modelMaterialsController != null && furniturePaint == FurniturePaint.MODEL_MATERIALS ? modelMaterialsController.getMaterials() : null;
            boolean bl4 = bl = this.getShininess() == FurnitureShininess.DEFAULT;
            Float f8 = this.getShininess() == FurnitureShininess.SHINY ? new Float(0.5f) : (this.getShininess() == FurnitureShininess.MATT ? new Float(0.0f) : null);
            Boolean bl5 = this.getVisible();
            Boolean bl6 = this.getModelMirrored();
            Float f9 = this.getLightPower();
            ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray = new ModifiedPieceOfFurniture[list2.size()];
            for (int i = 0; i < modifiedPieceOfFurnitureArray.length; ++i) {
                serializable = list2.get(i);
                modifiedPieceOfFurnitureArray[i] = serializable instanceof HomeLight ? new ModifiedLight((HomeLight)serializable) : (serializable instanceof HomeDoorOrWindow ? new ModifiedDoorOrWindow((HomeDoorOrWindow)serializable) : (serializable instanceof HomeFurnitureGroup ? new ModifiedFurnitureGroup((HomeFurnitureGroup)serializable) : new ModifiedPieceOfFurniture((HomePieceOfFurniture)serializable)));
            }
            HomeFurnitureController.doModifyFurniture(modifiedPieceOfFurnitureArray, string, bl2, string2, bigDecimal, f, f2, f3, f4, bl3, f5, f6, f7, furniturePaint, n, homeTexture, homeMaterialArray, bl, f8, bl5, bl6, f9);
            List<Selectable> list3 = this.home.getSelectedItems();
            if (this.undoSupport != null) {
                serializable = new FurnitureModificationUndoableEdit(this.home, this.preferences, list, list3, modifiedPieceOfFurnitureArray, string, bl2, string2, bigDecimal, f, f2, f3, f4, bl3, f5, f6, f7, furniturePaint, n, homeTexture, homeMaterialArray, bl, f8, bl5, bl6, f9);
                this.undoSupport.postEdit((UndoableEdit)((Object)serializable));
            }
            if (string != null) {
                this.preferences.addAutoCompletionString("HomePieceOfFurnitureName", string);
            }
            if (string2 != null) {
                this.preferences.addAutoCompletionString("HomePieceOfFurnitureDescription", string2);
            }
        }
    }

    private static void doModifyFurniture(ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray, String string, Boolean bl, String string2, BigDecimal bigDecimal, Float f, Float f2, Float f3, Float f4, Boolean bl2, Float f5, Float f6, Float f7, FurniturePaint furniturePaint, Integer n, HomeTexture homeTexture, HomeMaterial[] homeMaterialArray, boolean bl3, Float f8, Boolean bl4, Boolean bl5, Float f9) {
        for (ModifiedPieceOfFurniture modifiedPieceOfFurniture : modifiedPieceOfFurnitureArray) {
            HomePieceOfFurniture homePieceOfFurniture = modifiedPieceOfFurniture.getPieceOfFurniture();
            if (string != null) {
                homePieceOfFurniture.setName(string);
            }
            if (bl != null) {
                homePieceOfFurniture.setNameVisible(bl);
            }
            if (string2 != null) {
                homePieceOfFurniture.setDescription(string2);
            }
            if (bigDecimal != null && !(homePieceOfFurniture instanceof HomeFurnitureGroup)) {
                homePieceOfFurniture.setPrice(bigDecimal);
            }
            if (f != null) {
                homePieceOfFurniture.setX(f.floatValue());
            }
            if (f2 != null) {
                homePieceOfFurniture.setY(f2.floatValue());
            }
            if (f3 != null) {
                homePieceOfFurniture.setElevation(f3.floatValue());
            }
            if (f4 != null) {
                homePieceOfFurniture.setAngle(f4.floatValue());
            }
            if (bl2 != null && !homePieceOfFurniture.isDoorOrWindow()) {
                homePieceOfFurniture.setMovable(bl2 == false);
            }
            if (homePieceOfFurniture.isResizable()) {
                if (f5 != null) {
                    homePieceOfFurniture.setWidth(f5.floatValue());
                }
                if (f6 != null) {
                    homePieceOfFurniture.setDepth(f6.floatValue());
                }
                if (f7 != null) {
                    homePieceOfFurniture.setHeight(f7.floatValue());
                }
                if (bl5 != null) {
                    homePieceOfFurniture.setModelMirrored(bl5);
                }
            }
            if (homePieceOfFurniture.isTexturable() && furniturePaint != null) {
                switch (furniturePaint) {
                    case DEFAULT: {
                        homePieceOfFurniture.setColor(null);
                        homePieceOfFurniture.setTexture(null);
                        homePieceOfFurniture.setModelMaterials(null);
                        break;
                    }
                    case COLORED: {
                        homePieceOfFurniture.setColor(n);
                        homePieceOfFurniture.setTexture(null);
                        homePieceOfFurniture.setModelMaterials(null);
                        break;
                    }
                    case TEXTURED: {
                        homePieceOfFurniture.setColor(null);
                        homePieceOfFurniture.setTexture(homeTexture);
                        homePieceOfFurniture.setModelMaterials(null);
                        break;
                    }
                    case MODEL_MATERIALS: {
                        homePieceOfFurniture.setColor(null);
                        homePieceOfFurniture.setTexture(null);
                        homePieceOfFurniture.setModelMaterials(homeMaterialArray);
                    }
                }
                if (bl3) {
                    homePieceOfFurniture.setShininess(null);
                } else if (f8 != null) {
                    homePieceOfFurniture.setShininess(f8);
                }
            }
            if (bl4 != null) {
                homePieceOfFurniture.setVisible(bl4);
            }
            if (f9 == null) continue;
            ((HomeLight)homePieceOfFurniture).setPower(f9.floatValue());
        }
    }

    private static void undoModifyFurniture(ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray) {
        for (ModifiedPieceOfFurniture modifiedPieceOfFurniture : modifiedPieceOfFurnitureArray) {
            modifiedPieceOfFurniture.reset();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ModifiedFurnitureGroup
    extends ModifiedPieceOfFurniture {
        private final float[] groupFurnitureX;
        private final float[] groupFurnitureY;
        private final float[] groupFurnitureWidth;
        private final float[] groupFurnitureDepth;

        public ModifiedFurnitureGroup(HomeFurnitureGroup homeFurnitureGroup) {
            super(homeFurnitureGroup);
            List<HomePieceOfFurniture> list = this.getGroupFurniture(homeFurnitureGroup);
            this.groupFurnitureX = new float[list.size()];
            this.groupFurnitureY = new float[list.size()];
            this.groupFurnitureWidth = new float[list.size()];
            this.groupFurnitureDepth = new float[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                this.groupFurnitureX[i] = homePieceOfFurniture.getX();
                this.groupFurnitureY[i] = homePieceOfFurniture.getY();
                this.groupFurnitureWidth[i] = homePieceOfFurniture.getWidth();
                this.groupFurnitureDepth[i] = homePieceOfFurniture.getDepth();
            }
        }

        @Override
        public void reset() {
            super.reset();
            HomeFurnitureGroup homeFurnitureGroup = (HomeFurnitureGroup)this.getPieceOfFurniture();
            List<HomePieceOfFurniture> list = this.getGroupFurniture(homeFurnitureGroup);
            for (int i = 0; i < list.size(); ++i) {
                HomePieceOfFurniture homePieceOfFurniture = list.get(i);
                if (!homeFurnitureGroup.isResizable()) continue;
                homePieceOfFurniture.setX(this.groupFurnitureX[i]);
                homePieceOfFurniture.setY(this.groupFurnitureY[i]);
                homePieceOfFurniture.setWidth(this.groupFurnitureWidth[i]);
                homePieceOfFurniture.setDepth(this.groupFurnitureDepth[i]);
            }
        }

        private List<HomePieceOfFurniture> getGroupFurniture(HomeFurnitureGroup homeFurnitureGroup) {
            ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
            for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.getFurniture()) {
                arrayList.add(homePieceOfFurniture);
                if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
                arrayList.addAll(this.getGroupFurniture((HomeFurnitureGroup)homePieceOfFurniture));
            }
            return arrayList;
        }
    }

    private static class ModifiedLight
    extends ModifiedPieceOfFurniture {
        private final float power;

        public ModifiedLight(HomeLight homeLight) {
            super(homeLight);
            this.power = homeLight.getPower();
        }

        public void reset() {
            super.reset();
            ((HomeLight)this.getPieceOfFurniture()).setPower(this.power);
        }
    }

    private static class ModifiedDoorOrWindow
    extends ModifiedPieceOfFurniture {
        private final boolean boundToWall;

        public ModifiedDoorOrWindow(HomeDoorOrWindow homeDoorOrWindow) {
            super(homeDoorOrWindow);
            this.boundToWall = homeDoorOrWindow.isBoundToWall();
        }

        public void reset() {
            super.reset();
            ((HomeDoorOrWindow)this.getPieceOfFurniture()).setBoundToWall(this.boundToWall);
        }
    }

    private static class ModifiedPieceOfFurniture {
        private final HomePieceOfFurniture piece;
        private final String name;
        private final boolean nameVisible;
        private final String description;
        private final BigDecimal price;
        private final float x;
        private final float y;
        private final float elevation;
        private final float angle;
        private final boolean movable;
        private final float width;
        private final float depth;
        private final float height;
        private final Integer color;
        private final HomeTexture texture;
        private final HomeMaterial[] modelMaterials;
        private final Float shininess;
        private final boolean visible;
        private final boolean modelMirrored;

        public ModifiedPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
            this.piece = homePieceOfFurniture;
            this.name = homePieceOfFurniture.getName();
            this.nameVisible = homePieceOfFurniture.isNameVisible();
            this.description = homePieceOfFurniture.getDescription();
            this.price = homePieceOfFurniture.getPrice();
            this.x = homePieceOfFurniture.getX();
            this.y = homePieceOfFurniture.getY();
            this.elevation = homePieceOfFurniture.getElevation();
            this.angle = homePieceOfFurniture.getAngle();
            this.movable = homePieceOfFurniture.isMovable();
            this.width = homePieceOfFurniture.getWidth();
            this.depth = homePieceOfFurniture.getDepth();
            this.height = homePieceOfFurniture.getHeight();
            this.color = homePieceOfFurniture.getColor();
            this.texture = homePieceOfFurniture.getTexture();
            this.modelMaterials = homePieceOfFurniture.getModelMaterials();
            this.shininess = homePieceOfFurniture.getShininess();
            this.visible = homePieceOfFurniture.isVisible();
            this.modelMirrored = homePieceOfFurniture.isModelMirrored();
        }

        public HomePieceOfFurniture getPieceOfFurniture() {
            return this.piece;
        }

        public void reset() {
            this.piece.setName(this.name);
            this.piece.setNameVisible(this.nameVisible);
            this.piece.setDescription(this.description);
            if (!(this.piece instanceof HomeFurnitureGroup)) {
                this.piece.setPrice(this.price);
            }
            this.piece.setX(this.x);
            this.piece.setY(this.y);
            this.piece.setElevation(this.elevation);
            this.piece.setAngle(this.angle);
            this.piece.setMovable(this.movable);
            if (this.piece.isResizable()) {
                this.piece.setWidth(this.width);
                this.piece.setDepth(this.depth);
                this.piece.setHeight(this.height);
                this.piece.setModelMirrored(this.modelMirrored);
            }
            if (this.piece.isTexturable()) {
                this.piece.setColor(this.color);
                this.piece.setTexture(this.texture);
                this.piece.setModelMaterials(this.modelMaterials);
                this.piece.setShininess(this.shininess);
            }
            this.piece.setVisible(this.visible);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FurnitureModificationUndoableEdit
    extends AbstractUndoableEdit {
        private final Home home;
        private final UserPreferences preferences;
        private final ModifiedPieceOfFurniture[] modifiedFurniture;
        private final List<Selectable> oldSelection;
        private final List<Selectable> newSelection;
        private final String name;
        private final Boolean nameVisible;
        private final String description;
        private final BigDecimal price;
        private final Float x;
        private final Float y;
        private final Float elevation;
        private final Float angle;
        private final Boolean basePlanItem;
        private final Float width;
        private final Float depth;
        private final Float height;
        private final FurniturePaint paint;
        private final Integer color;
        private final HomeTexture texture;
        private final HomeMaterial[] modelMaterials;
        private final boolean defaultShininess;
        private final Float shininess;
        private final Boolean visible;
        private final Boolean modelMirrored;
        private final Float lightPower;

        private FurnitureModificationUndoableEdit(Home home, UserPreferences userPreferences, List<Selectable> list, List<Selectable> list2, ModifiedPieceOfFurniture[] modifiedPieceOfFurnitureArray, String string, Boolean bl, String string2, BigDecimal bigDecimal, Float f, Float f2, Float f3, Float f4, Boolean bl2, Float f5, Float f6, Float f7, FurniturePaint furniturePaint, Integer n, HomeTexture homeTexture, HomeMaterial[] homeMaterialArray, boolean bl3, Float f8, Boolean bl4, Boolean bl5, Float f9) {
            this.home = home;
            this.preferences = userPreferences;
            this.oldSelection = list;
            this.newSelection = list2;
            this.modifiedFurniture = modifiedPieceOfFurnitureArray;
            this.name = string;
            this.nameVisible = bl;
            this.description = string2;
            this.price = bigDecimal;
            this.x = f;
            this.y = f2;
            this.elevation = f3;
            this.angle = f4;
            this.basePlanItem = bl2;
            this.width = f5;
            this.depth = f6;
            this.height = f7;
            this.paint = furniturePaint;
            this.color = n;
            this.texture = homeTexture;
            this.modelMaterials = homeMaterialArray;
            this.defaultShininess = bl3;
            this.shininess = f8;
            this.visible = bl4;
            this.modelMirrored = bl5;
            this.lightPower = f9;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            HomeFurnitureController.undoModifyFurniture(this.modifiedFurniture);
            this.home.setSelectedItems(this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            HomeFurnitureController.doModifyFurniture(this.modifiedFurniture, this.name, this.nameVisible, this.description, this.price, this.x, this.y, this.elevation, this.angle, this.basePlanItem, this.width, this.depth, this.height, this.paint, this.color, this.texture, this.modelMaterials, this.defaultShininess, this.shininess, this.visible, this.modelMirrored, this.lightPower);
            this.home.setSelectedItems(this.newSelection);
        }

        @Override
        public String getPresentationName() {
            return this.preferences.getLocalizedString(HomeFurnitureController.class, "undoModifyFurnitureName", new Object[0]);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FurnitureShininess {
        DEFAULT,
        MATT,
        SHINY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FurniturePaint {
        DEFAULT,
        COLORED,
        TEXTURED,
        MODEL_MATERIALS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ICON,
        NAME,
        NAME_VISIBLE,
        DESCRIPTION,
        PRICE,
        X,
        Y,
        ELEVATION,
        ANGLE_IN_DEGREES,
        BASE_PLAN_ITEM,
        WIDTH,
        DEPTH,
        HEIGHT,
        PROPORTIONAL,
        COLOR,
        PAINT,
        SHININESS,
        VISIBLE,
        MODEL_MIRRORED,
        LIGHT_POWER,
        RESIZABLE,
        DEFORMABLE,
        TEXTURABLE;

    }
}

