/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.templates.web.browse;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.music.Playlist;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.IFooter;
import com.pugh.sockso.templates.web.IHeader;
import com.pugh.sockso.templates.web.browse.IMusicLinks;
import com.pugh.sockso.templates.web.browse.TPlaylists;
import com.pugh.sockso.web.User;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;
import org.jamon.AbstractTemplateImpl;
import org.jamon.AbstractTemplateProxy;
import org.jamon.TemplateManager;
import org.jamon.emit.StandardEmitter;
import org.jamon.escaping.Escaping;

public class TPlaylistsImpl
extends AbstractTemplateImpl
implements TPlaylists.Intf {
    private final User user;
    private final Properties properties;
    private final Vector<Playlist> sitePlaylists;
    private final Vector<Playlist> userPlaylists;
    private final Vector<User> recentUsers;
    private final Locale locale;

    protected static TPlaylists.ImplData __jamon_setOptionalArguments(TPlaylists.ImplData p_implData) {
        if (!p_implData.getUser__IsNotDefault()) {
            p_implData.setUser(null);
        }
        if (!p_implData.getProperties__IsNotDefault()) {
            p_implData.setProperties(null);
        }
        if (!p_implData.getSitePlaylists__IsNotDefault()) {
            p_implData.setSitePlaylists(null);
        }
        if (!p_implData.getUserPlaylists__IsNotDefault()) {
            p_implData.setUserPlaylists(null);
        }
        if (!p_implData.getRecentUsers__IsNotDefault()) {
            p_implData.setRecentUsers(null);
        }
        if (!p_implData.getLocale__IsNotDefault()) {
            p_implData.setLocale(null);
        }
        return p_implData;
    }

    public TPlaylistsImpl(TemplateManager p_templateManager, TPlaylists.ImplData p_implData) {
        super(p_templateManager, (AbstractTemplateProxy.ImplData)TPlaylistsImpl.__jamon_setOptionalArguments(p_implData));
        this.user = p_implData.getUser();
        this.properties = p_implData.getProperties();
        this.sitePlaylists = p_implData.getSitePlaylists();
        this.userPlaylists = p_implData.getUserPlaylists();
        this.recentUsers = p_implData.getRecentUsers();
        this.locale = p_implData.getLocale();
    }

    public void renderNoFlush(Writer jamonWriter) throws IOException {
        jamonWriter.write("\n");
        IHeader __jamon__var_47 = new IHeader(this.getTemplateManager());
        __jamon__var_47.setProperties(this.properties);
        __jamon__var_47.setTitle("Playlists");
        __jamon__var_47.setLocale(this.locale);
        __jamon__var_47.setUser(this.user);
        __jamon__var_47.renderNoFlush(jamonWriter);
        jamonWriter.write("\n\n<div class=\"section\">\n\n    <h2>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.sitePlaylists")), jamonWriter);
        jamonWriter.write("</h2>\n\n    <ul class=\"musiclist\">\n    ");
        if (this.sitePlaylists.size() > 0) {
            jamonWriter.write("\n        ");
            for (Playlist playlist : this.sitePlaylists) {
                jamonWriter.write("\n            <li class=\"playlist\">\n                ");
                IMusicLinks __jamon__var_48 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_48.setName(playlist.getName());
                __jamon__var_48.setId(playlist.getId());
                __jamon__var_48.setProperties(this.properties);
                __jamon__var_48.setLocale(this.locale);
                __jamon__var_48.setType("pl");
                __jamon__var_48.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                <span class=\"link\"><a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/playlist/" + playlist.getId())), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(playlist.getName())), jamonWriter);
                jamonWriter.write("</a></span>\n                <span class=\"info\">(");
                Escaping.HTML.write(StandardEmitter.valueOf((int)playlist.getTrackCount()), jamonWriter);
                jamonWriter.write(" track");
                if (playlist.getTrackCount() != 1) {
                    jamonWriter.write("s");
                }
                jamonWriter.write(")</span>\n            </li>\n        ");
            }
            jamonWriter.write("\n    ");
        } else {
            jamonWriter.write("\n        <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n    ");
        }
        jamonWriter.write("\n    </ul>\n\n</div>\n\n<div class=\"section\">\n\n    <h2>");
        Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.title.userPlaylists")), jamonWriter);
        jamonWriter.write("</h2>\n\n    <ul id=\"userPlaylists\" class=\"musiclist\">\n    ");
        if (this.userPlaylists.size() > 0) {
            jamonWriter.write("\n        ");
            for (Playlist playlist : this.userPlaylists) {
                jamonWriter.write("\n            <li class=\"playlist\" id=\"userPlaylist");
                Escaping.HTML.write(StandardEmitter.valueOf((int)playlist.getId()), jamonWriter);
                jamonWriter.write("\">\n                ");
                IMusicLinks __jamon__var_49 = new IMusicLinks(this.getTemplateManager());
                __jamon__var_49.setName(playlist.getName());
                __jamon__var_49.setId(playlist.getId());
                __jamon__var_49.setProperties(this.properties);
                __jamon__var_49.setLocale(this.locale);
                __jamon__var_49.setType("pl");
                __jamon__var_49.renderNoFlush(jamonWriter);
                jamonWriter.write("\n                <a href=\"");
                Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/browse/playlist/" + playlist.getId())), jamonWriter);
                jamonWriter.write("\">");
                Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(playlist.getName())), jamonWriter);
                jamonWriter.write("</a>\n                by\n                ");
                if (this.user != null && this.user.getId() == playlist.getUser().getId()) {
                    jamonWriter.write("\n                    <b>you</b>\n                ");
                } else {
                    jamonWriter.write("\n                    ");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)Utils.u2e(playlist.getUser().getName())), jamonWriter);
                    jamonWriter.write("\n                ");
                }
                jamonWriter.write("\n                (");
                Escaping.HTML.write(StandardEmitter.valueOf((int)playlist.getTrackCount()), jamonWriter);
                jamonWriter.write(" track");
                if (playlist.getTrackCount() != 1) {
                    jamonWriter.write("s");
                }
                jamonWriter.write(")\n                ");
                if (this.user != null && playlist.getUser().getId() == this.user.getId()) {
                    jamonWriter.write("\n                    <a href=\"javascript:;\" class=\"delete\" onclick=\"deletePlaylist('");
                    Escaping.HTML.write(StandardEmitter.valueOf((int)playlist.getId()), jamonWriter);
                    jamonWriter.write("');return false;\"><img\n                        src=\"");
                    Escaping.NONE.write(StandardEmitter.valueOf((String)this.properties.getUrl("/<skin>/images/remove.png")), jamonWriter);
                    jamonWriter.write("\" title=\"");
                    Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.label.deletePlaylist")), jamonWriter);
                    jamonWriter.write("\" /></a>\n                ");
                }
                jamonWriter.write("\n            </li>\n        ");
            }
            jamonWriter.write("\n    ");
        } else {
            jamonWriter.write("\n        <li class=\"empty\">");
            Escaping.HTML.write(StandardEmitter.valueOf((String)this.locale.getString("www.text.noResults")), jamonWriter);
            jamonWriter.write("</li>\n    ");
        }
        jamonWriter.write("\n    </ul>\n\n</div>\n\n");
        IFooter __jamon__var_50 = new IFooter(this.getTemplateManager());
        __jamon__var_50.setUser(this.user);
        __jamon__var_50.setProperties(this.properties);
        __jamon__var_50.setRecentUsers(this.recentUsers);
        __jamon__var_50.setLocale(this.locale);
        __jamon__var_50.renderNoFlush(jamonWriter);
        jamonWriter.write("\n");
    }
}

