/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.gui.MusicList;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.music.CollectionManagerListener;
import com.pugh.sockso.music.Playlist;
import com.pugh.sockso.resources.Resources;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;

public class Playlists
extends MusicList
implements CollectionManagerListener {
    private static final Logger log = Logger.getLogger(Playlists.class);
    public static final int USER_PLAYLISTS = 1;
    public static final int SITE_PLAYLISTS = 2;
    private final Database db;
    private final CollectionManager cm;
    private final Resources r;
    private final DefaultListModel model;
    private final int mode;

    public Playlists(Database db, CollectionManager cm, Resources r, int mode) {
        this.db = db;
        this.cm = cm;
        this.r = r;
        this.mode = mode;
        this.model = new DefaultListModel();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getButton() == 3) {
                    Playlists.this.handleRightClick(evt);
                }
            }
        });
        this.setModel(this.model);
        cm.addCollectionManagerListener(this);
    }

    private void handleRightClick(MouseEvent evt) {
        Point p = evt.getPoint();
        this.setSelectedIndex(this.locationToIndex(p));
        if (this.getSelectedIndex() == -1) {
            return;
        }
        JMenuItem delete = new JMenuItem("Delete", new ImageIcon(this.r.getImage("icons/16x16/delete.png")));
        delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Playlists.this.deleteSelectedItem();
            }
        });
        JPopupMenu menu = new JPopupMenu();
        menu.add(delete);
        menu.show(this, (int)p.getX(), (int)p.getY());
    }

    private void deleteSelectedItem() {
        int index = this.getSelectedIndex();
        if (index != -1) {
            Playlist playlist = (Playlist)this.model.getElementAt(index);
            this.cm.removePlaylist(playlist.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh() {
        block6: {
            this.model.clear();
            ResultSet rs = null;
            PreparedStatement st = null;
            try {
                String sql = " select p.id as id, p.name as name  from playlists p  where user_id is " + (this.mode == 1 ? " not " : "") + " null " + " order by p.name asc ";
                st = this.db.prepare(sql);
                rs = st.executeQuery();
                while (rs.next()) {
                    this.model.addElement(new Playlist(rs.getInt("id"), rs.getString("name")));
                }
                Utils.close(rs);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage());
                break block6;
            }
            finally {
                Utils.close(rs);
                Utils.close(st);
            }
            Utils.close(st);
        }
    }

    public void collectionManagerChangePerformed(int type, String message) {
        if (type == 4) {
            this.refresh();
        }
    }
}

