/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.commands;

import com.pugh.sockso.Properties;
import com.pugh.sockso.commands.ColAdd;
import com.pugh.sockso.commands.ColDel;
import com.pugh.sockso.commands.ColList;
import com.pugh.sockso.commands.ColScan;
import com.pugh.sockso.commands.Command;
import com.pugh.sockso.commands.Exit;
import com.pugh.sockso.commands.PropDel;
import com.pugh.sockso.commands.PropList;
import com.pugh.sockso.commands.PropSet;
import com.pugh.sockso.commands.UserActive;
import com.pugh.sockso.commands.UserAdd;
import com.pugh.sockso.commands.UserAdmin;
import com.pugh.sockso.commands.UserDel;
import com.pugh.sockso.commands.UserList;
import com.pugh.sockso.commands.Version;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.CollectionManager;
import com.pugh.sockso.resources.Locale;
import java.util.Vector;
import org.apache.log4j.Logger;

public class CommandExecuter {
    private static final Logger log = Logger.getLogger(CommandExecuter.class);
    private final Database db;
    private final Properties p;
    private final CollectionManager cm;
    private final Locale locale;
    private final Command[] commands;

    public CommandExecuter(Database db, Properties p, CollectionManager cm, Locale locale) {
        this.db = db;
        this.p = p;
        this.cm = cm;
        this.locale = locale;
        this.commands = new Command[]{new UserList(db), new UserAdd(db, locale), new UserDel(db, locale), new UserAdmin(db, locale), new UserActive(db, locale), new ColAdd(cm, locale), new ColDel(cm, locale), new ColList(db), new ColScan(cm), new PropSet(p, locale), new PropDel(p, locale), new PropList(p), new Version(), new Exit()};
    }

    public String execute(String command) throws Exception {
        String[] args = this.getArgs(command);
        String name = args.length > 0 ? args[0] : "";
        for (Command cmd : this.commands) {
            if (!cmd.getName().equals(name)) continue;
            return this.runCommand(cmd, args);
        }
        return this.getCommands();
    }

    protected String runCommand(Command cmd, String[] args) throws Exception {
        int numArgs = args.length - 1;
        if (cmd.getNumArgs() != -1 && cmd.getNumArgs() != numArgs) {
            return "This command requires " + cmd.getNumArgs() + " arguments";
        }
        log.debug((Object)("Executing Command: '" + cmd.getName() + "'"));
        return cmd.execute(args);
    }

    protected String[] getArgs(String command) {
        Vector<String> args = new Vector<String>();
        String arg = new String();
        boolean previousEscape = false;
        for (char c : command.toCharArray()) {
            if (Character.isWhitespace(c)) {
                if (previousEscape) {
                    arg = arg + c;
                    continue;
                }
                args.add(new String(arg));
                arg = "";
                continue;
            }
            if (c == '\\' && !previousEscape) {
                previousEscape = true;
                continue;
            }
            arg = arg + c;
            previousEscape = false;
        }
        if (arg.length() > 0) {
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    protected String getCommands() {
        int i;
        String[] lines = new String[this.commands.length];
        StringBuffer sb = new StringBuffer();
        int longest = 0;
        sb.append(this.locale.getString("con.desc.commands") + "\n");
        for (i = 0; i < this.commands.length; ++i) {
            Command cmd = this.commands[i];
            StringBuffer lb = new StringBuffer();
            lb.append("  ");
            lb.append(cmd.getName());
            for (String argument : cmd.getArguments()) {
                lb.append(" ");
                lb.append(argument);
            }
            if (lb.length() > longest) {
                longest = lb.length();
            }
            lines[i] = lb.toString();
        }
        for (i = 0; i < lines.length; ++i) {
            String line = lines[i];
            sb.append(line);
            for (int j = longest + 5; j > line.length(); --j) {
                sb.append(" ");
            }
            sb.append(this.commands[i].getDescription());
            sb.append("\n");
        }
        return sb.toString();
    }
}

