/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.asf;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import org.jaudiotagger.audio.asf.data.AsfHeader;
import org.jaudiotagger.audio.asf.data.MetadataDescriptor;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.asf.AbstractAsfTagImageField;
import org.jaudiotagger.tag.asf.AsfFieldKey;
import org.jaudiotagger.tag.id3.valuepair.ImageFormats;

public class AsfTagCoverField
extends AbstractAsfTagImageField {
    public static final Logger LOGGER = Logger.getLogger("org.jaudiotagger.audio.asf.tag");
    private String description;
    private int endOfName = 0;
    private int imageDataSize;
    private String mimeType;
    private int pictureType;

    public AsfTagCoverField(byte[] imageData, int pictureType, String description, String mimeType) {
        super(new MetadataDescriptor(AsfFieldKey.COVER_ART.getFieldName(), 1));
        this.getDescriptor().setBinaryValue(this.createRawContent(imageData, pictureType, description, mimeType));
    }

    public AsfTagCoverField(MetadataDescriptor source) {
        super(source);
        if (!source.getName().equals(AsfFieldKey.COVER_ART.getFieldName())) {
            throw new IllegalArgumentException("Descriptor description must be WM/Picture");
        }
        if (source.getType() != 1) {
            throw new IllegalArgumentException("Descriptor type must be binary");
        }
        try {
            this.processRawContent();
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
    }

    private byte[] createRawContent(byte[] data, int pictureType, String description, String mimeType) {
        byte[] mimeTypeData;
        this.description = description;
        if (mimeType == null && (mimeType = ImageFormats.getMimeTypeForBinarySignature(data)) == null) {
            LOGGER.warning(ErrorMessage.GENERAL_UNIDENITIFED_IMAGE_FORMAT.getMsg());
            mimeType = "image/png";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(pictureType);
        baos.write(Utils.getSizeLEInt32(data.length), 0, 4);
        try {
            mimeTypeData = mimeType.getBytes(AsfHeader.ASF_CHARSET.name());
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Unable to find encoding:" + AsfHeader.ASF_CHARSET.name());
        }
        baos.write(mimeTypeData, 0, mimeTypeData.length);
        baos.write(0);
        baos.write(0);
        if (description != null && description.length() > 0) {
            byte[] descriptionData;
            try {
                descriptionData = description.getBytes(AsfHeader.ASF_CHARSET.name());
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("Unable to find encoding:" + AsfHeader.ASF_CHARSET.name());
            }
            baos.write(descriptionData, 0, descriptionData.length);
        }
        baos.write(0);
        baos.write(0);
        baos.write(data, 0, data.length);
        return baos.toByteArray();
    }

    public String getDescription() {
        return this.description;
    }

    public int getImageDataSize() {
        return this.imageDataSize;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public int getPictureType() {
        return this.pictureType;
    }

    public byte[] getRawImageData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write(this.getRawContent(), this.endOfName, this.toWrap.getRawDataSize() - this.endOfName);
        return baos.toByteArray();
    }

    private void processRawContent() throws UnsupportedEncodingException {
        this.pictureType = this.getRawContent()[0];
        this.imageDataSize = Utils.getIntLE(this.getRawContent(), 1, 2);
        this.mimeType = null;
        this.description = null;
        int endOfMimeType = 0;
        for (int count = 5; count < this.getRawContent().length - 1; count += 2) {
            if (this.getRawContent()[count] != 0 || this.getRawContent()[count + 1] != 0) continue;
            if (this.mimeType == null) {
                this.mimeType = new String(this.getRawContent(), 5, count - 5, "UTF-16LE");
                endOfMimeType = count + 2;
                continue;
            }
            if (this.description != null) continue;
            this.description = new String(this.getRawContent(), endOfMimeType, count - endOfMimeType, "UTF-16LE");
            this.endOfName = count + 2;
            break;
        }
    }
}

