/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui.validator;

import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.render.Renderer;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

public class EqualityValidator
implements Validator,
StateHolder {
    private static LogProvider log = Logging.getLogProvider(EqualityValidator.class);
    public static final String MESSAGE_ID = "org.jboss.seam.ui.validator.NOT_EQUAL";
    public static final String VALIDATOR_ID = "org.jboss.seam.ui.validator.Equality";
    private String forId;
    private String message = "Value does not equal that in '#0'";
    private String messageId = "org.jboss.seam.ui.validator.NOT_EQUAL";

    public EqualityValidator() {
    }

    public EqualityValidator(String forId) {
        this();
        this.setFor(forId);
    }

    public EqualityValidator(String forId, String message, String messageId) {
        this(forId);
        if (message != null) {
            this.setMessage(message);
        }
        if (messageId != null) {
            this.setMessageId(messageId);
        }
    }

    public void validate(FacesContext context, UIComponent component, Object value) throws ValidatorException {
        String forId = this.getFor();
        if (forId == null) {
            throw new FacesException("Must specify a component to validate equality against");
        }
        UIComponent otherComponent = component.findComponent(forId);
        Object other = new OtherComponent(context, otherComponent).getValue();
        if (!(value == null && other == null || value == null || value.equals(other))) {
            String otherComponentId = otherComponent.getId();
            throw new ValidatorException(FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)this.getMessageId(), (String)this.getMessage(), (Object[])new Object[]{otherComponentId, value, other}));
        }
    }

    public String getFor() {
        return this.forId;
    }

    public void setFor(String forId) {
        this.forId = forId;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] fields = (Object[])state;
        this.forId = (String)fields[0];
        this.message = (String)fields[1];
        this.messageId = (String)fields[2];
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.forId, this.message, this.messageId};
        return state;
    }

    public void setTransient(boolean newTransientValue) {
    }

    private class OtherComponent {
        private FacesContext context;
        private UIComponent component;
        private EditableValueHolder editableValueHolder;
        private Renderer renderer;
        private Converter converter;

        public OtherComponent(FacesContext facesContext, UIComponent component) {
            this.component = component;
            this.context = facesContext;
            if (!(component instanceof EditableValueHolder)) {
                throw new IllegalStateException("forId must reference an EditableValueHolder (\"input\") component");
            }
            this.editableValueHolder = (EditableValueHolder)component;
            this.initRenderer();
            this.initConverter();
        }

        private void initRenderer() {
            if (this.renderer == null) {
                String rendererType = this.component.getRendererType();
                if (rendererType != null) {
                    this.renderer = this.context.getRenderKit().getRenderer(this.component.getFamily(), rendererType);
                    if (null == this.renderer) {
                        log.trace((Object)("Can't get Renderer for type " + rendererType));
                    }
                } else if (log.isTraceEnabled()) {
                    String id = this.component.getId();
                    id = null != id ? id : this.component.getClass().getName();
                    log.trace((Object)("No renderer-type for component " + id));
                }
            }
        }

        private void initConverter() {
            Class converterType;
            this.converter = this.editableValueHolder.getConverter();
            if (this.converter != null) {
                return;
            }
            ValueExpression valueExpression = this.component.getValueExpression("value");
            if (valueExpression == null) {
                return;
            }
            try {
                converterType = valueExpression.getType(this.context.getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
            if (converterType == null || converterType == String.class || converterType == Object.class) {
                return;
            }
            try {
                Application application = this.context.getApplication();
                this.converter = application.createConverter(converterType);
            }
            catch (Exception e) {
                throw new FacesException((Throwable)e);
            }
        }

        private Object getConvertedValue(Object newSubmittedValue) throws ConverterException {
            Object newValue = this.renderer != null ? this.renderer.getConvertedValue(this.context, this.component, newSubmittedValue) : (newSubmittedValue instanceof String ? (this.converter != null ? this.converter.getAsObject(this.context, this.component, (String)newSubmittedValue) : newSubmittedValue) : newSubmittedValue);
            return newValue;
        }

        public Object getValue() {
            if (this.editableValueHolder.isLocalValueSet()) {
                return this.editableValueHolder.getValue();
            }
            Object submittedValue = this.editableValueHolder.getLocalValue();
            if (submittedValue == null) {
                return null;
            }
            Object newValue = null;
            try {
                newValue = this.getConvertedValue(submittedValue);
            }
            catch (ConverterException ce) {
                return null;
            }
            return newValue;
        }
    }
}

