/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.injection;

import javax.naming.Context;
import org.jboss.ejb3.common.classloader.util.PrimitiveClassLoadingUtil;
import org.jboss.injection.EncInjector;
import org.jboss.injection.InjectionContainer;
import org.jboss.logging.Logger;
import org.jboss.util.naming.Util;

public class EnvEntryEncInjector
implements EncInjector {
    private static final Logger log = Logger.getLogger(EnvEntryEncInjector.class);
    private String name;
    private String entryType;
    private String value;

    public EnvEntryEncInjector(String encName, String entryType, String value) {
        this.name = encName;
        this.entryType = entryType;
        this.value = value;
    }

    @Override
    public void inject(InjectionContainer container) {
        try {
            Util.rebind((Context)container.getEnc(), (String)this.name, (Object)this.getEnvEntryValue(container.getClassloader()));
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid <env-entry> name: " + this.name, e);
        }
    }

    @Deprecated
    protected Object getEnvEntryValue() throws ClassNotFoundException {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        return this.getEnvEntryValue(tccl);
    }

    private Object getEnvEntryValue(ClassLoader cl) throws ClassNotFoundException {
        Class type = PrimitiveClassLoadingUtil.loadClass((String)this.entryType, (ClassLoader)cl);
        if (type == String.class) {
            return this.value;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new Integer(this.value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return new Long(this.value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return new Double(this.value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new Float(this.value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return new Byte(this.value);
        }
        if (type == Character.class || type == Character.TYPE) {
            String input = this.value;
            if (input == null || input.length() == 0) {
                return new Character('\u0000');
            }
            if (input.length() > 1) {
                log.warn((Object)("Warning character env-entry is too long: binding=" + this.name + " value=" + input));
            }
            return new Character(input.charAt(0));
        }
        if (type == Short.class || type == Short.TYPE) {
            return new Short(this.value);
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return new Boolean(this.value);
        }
        return this.value;
    }
}

