/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javassist.bytecode.ClassFile;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.annotation.security.DeclareRoles;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.Init;
import javax.ejb.Local;
import javax.ejb.MessageDriven;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remote;
import javax.ejb.Remove;
import javax.ejb.SessionBean;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.interceptor.AroundInvoke;
import javax.interceptor.ExcludeDefaultInterceptors;
import javax.interceptor.Interceptors;
import org.jboss.aop.annotation.AnnotationRepository;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3AnnotationHandler;
import org.jboss.ejb3.Ejb3Deployment;
import org.jboss.ejb3.annotation.Cache;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.ejb3.annotation.Clustered;
import org.jboss.ejb3.annotation.Consumer;
import org.jboss.ejb3.annotation.CurrentMessage;
import org.jboss.ejb3.annotation.DefaultActivationSpecs;
import org.jboss.ejb3.annotation.DeliveryMode;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.IgnoreDependency;
import org.jboss.ejb3.annotation.LocalBinding;
import org.jboss.ejb3.annotation.LocalHomeBinding;
import org.jboss.ejb3.annotation.Management;
import org.jboss.ejb3.annotation.MessageProperties;
import org.jboss.ejb3.annotation.PersistenceManager;
import org.jboss.ejb3.annotation.Pool;
import org.jboss.ejb3.annotation.Producer;
import org.jboss.ejb3.annotation.Producers;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.annotation.RemoteBindings;
import org.jboss.ejb3.annotation.RemoteHomeBinding;
import org.jboss.ejb3.annotation.ResourceAdapter;
import org.jboss.ejb3.annotation.SecurityDomain;
import org.jboss.ejb3.annotation.SerializedConcurrentAccess;
import org.jboss.ejb3.annotation.Service;
import org.jboss.ejb3.annotation.TransactionTimeout;
import org.jboss.ejb3.annotation.impl.ActivationConfigPropertyImpl;
import org.jboss.ejb3.annotation.impl.AroundInvokeImpl;
import org.jboss.ejb3.annotation.impl.CacheConfigImpl;
import org.jboss.ejb3.annotation.impl.CacheImpl;
import org.jboss.ejb3.annotation.impl.ClusteredImpl;
import org.jboss.ejb3.annotation.impl.ConsumerImpl;
import org.jboss.ejb3.annotation.impl.CurrentMessageImpl;
import org.jboss.ejb3.annotation.impl.DeclareRolesImpl;
import org.jboss.ejb3.annotation.impl.DefaultActivationSpecsImpl;
import org.jboss.ejb3.annotation.impl.DenyAllImpl;
import org.jboss.ejb3.annotation.impl.DependsImpl;
import org.jboss.ejb3.annotation.impl.ExcludeDefaultInterceptorsImpl;
import org.jboss.ejb3.annotation.impl.IgnoreDependencyImpl;
import org.jboss.ejb3.annotation.impl.InitImpl;
import org.jboss.ejb3.annotation.impl.InterceptorsImpl;
import org.jboss.ejb3.annotation.impl.LocalBindingImpl;
import org.jboss.ejb3.annotation.impl.LocalHomeBindingImpl;
import org.jboss.ejb3.annotation.impl.LocalHomeImpl;
import org.jboss.ejb3.annotation.impl.LocalImpl;
import org.jboss.ejb3.annotation.impl.ManagementImpl;
import org.jboss.ejb3.annotation.impl.MessageDrivenImpl;
import org.jboss.ejb3.annotation.impl.MessagePropertiesImpl;
import org.jboss.ejb3.annotation.impl.PermitAllImpl;
import org.jboss.ejb3.annotation.impl.PersistenceManagerImpl;
import org.jboss.ejb3.annotation.impl.PoolImpl;
import org.jboss.ejb3.annotation.impl.PostActivateImpl;
import org.jboss.ejb3.annotation.impl.PostConstructImpl;
import org.jboss.ejb3.annotation.impl.PreDestroyImpl;
import org.jboss.ejb3.annotation.impl.PrePassivateImpl;
import org.jboss.ejb3.annotation.impl.ProducerImpl;
import org.jboss.ejb3.annotation.impl.ProducersImpl;
import org.jboss.ejb3.annotation.impl.RemoteBindingImpl;
import org.jboss.ejb3.annotation.impl.RemoteBindingsImpl;
import org.jboss.ejb3.annotation.impl.RemoteHomeBindingImpl;
import org.jboss.ejb3.annotation.impl.RemoteHomeImpl;
import org.jboss.ejb3.annotation.impl.RemoteImpl;
import org.jboss.ejb3.annotation.impl.RemoveImpl;
import org.jboss.ejb3.annotation.impl.ResourceAdapterImpl;
import org.jboss.ejb3.annotation.impl.ResourceImpl;
import org.jboss.ejb3.annotation.impl.RolesAllowedImpl;
import org.jboss.ejb3.annotation.impl.RunAsImpl;
import org.jboss.ejb3.annotation.impl.RunAsPrincipalImpl;
import org.jboss.ejb3.annotation.impl.SecurityDomainImpl;
import org.jboss.ejb3.annotation.impl.SerializedConcurrentAccessImpl;
import org.jboss.ejb3.annotation.impl.ServiceImpl;
import org.jboss.ejb3.annotation.impl.StatefulImpl;
import org.jboss.ejb3.annotation.impl.StatelessImpl;
import org.jboss.ejb3.annotation.impl.TransactionAttributeImpl;
import org.jboss.ejb3.annotation.impl.TransactionManagementImpl;
import org.jboss.ejb3.annotation.impl.TransactionTimeoutImpl;
import org.jboss.ejb3.common.classloader.util.PrimitiveClassLoadingUtil;
import org.jboss.ejb3.common.lang.ClassHelper;
import org.jboss.ejb3.interceptor.InterceptorInfoRepository;
import org.jboss.ejb3.mdb.ConsumerContainer;
import org.jboss.ejb3.mdb.MDB;
import org.jboss.ejb3.proxy.factory.ProxyFactoryHelper;
import org.jboss.ejb3.service.ServiceContainer;
import org.jboss.ejb3.stateful.StatefulContainer;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.CacheConfigMetaData;
import org.jboss.metadata.ejb.jboss.ClusterConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossAssemblyDescriptorMetaData;
import org.jboss.metadata.ejb.jboss.JBossConsumerBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossGenericBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMessageDrivenBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.ejb.jboss.JBossServiceBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.MessagePropertiesMetaData;
import org.jboss.metadata.ejb.jboss.MethodAttributeMetaData;
import org.jboss.metadata.ejb.jboss.MethodAttributesMetaData;
import org.jboss.metadata.ejb.jboss.PoolConfigMetaData;
import org.jboss.metadata.ejb.jboss.ProducerMetaData;
import org.jboss.metadata.ejb.jboss.RemoteBindingMetaData;
import org.jboss.metadata.ejb.jboss.ResourceManagerMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigMetaData;
import org.jboss.metadata.ejb.spec.ActivationConfigPropertyMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokeMetaData;
import org.jboss.metadata.ejb.spec.AroundInvokesMetaData;
import org.jboss.metadata.ejb.spec.BusinessLocalsMetaData;
import org.jboss.metadata.ejb.spec.BusinessRemotesMetaData;
import org.jboss.metadata.ejb.spec.ContainerTransactionMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.InitMethodMetaData;
import org.jboss.metadata.ejb.spec.InitMethodsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingMetaData;
import org.jboss.metadata.ejb.spec.InterceptorBindingsMetaData;
import org.jboss.metadata.ejb.spec.InterceptorClassesMetaData;
import org.jboss.metadata.ejb.spec.MethodMetaData;
import org.jboss.metadata.ejb.spec.MethodParametersMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodMetaData;
import org.jboss.metadata.ejb.spec.RemoveMethodsMetaData;
import org.jboss.metadata.ejb.spec.SecurityIdentityMetaData;
import org.jboss.metadata.ejb.spec.SubscriptionDurability;
import org.jboss.metadata.javaee.jboss.AnnotationMetaData;
import org.jboss.metadata.javaee.jboss.AnnotationPropertiesMetaData;
import org.jboss.metadata.javaee.jboss.AnnotationPropertyMetaData;
import org.jboss.metadata.javaee.jboss.AnnotationsMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbackMetaData;
import org.jboss.metadata.javaee.spec.LifecycleCallbacksMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferenceMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationReferencesMetaData;
import org.jboss.metadata.javaee.spec.PortComponent;
import org.jboss.metadata.javaee.spec.ResourceInjectionTargetMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.spec.RunAsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleMetaData;
import org.jboss.metadata.javaee.spec.SecurityRolesMetaData;
import org.jboss.wsf.spi.metadata.j2ee.PortComponentMD;
import org.jboss.wsf.spi.metadata.j2ee.PortComponentSpec;

public class Ejb3DescriptorHandler
extends Ejb3AnnotationHandler {
    private static final Logger log = Logger.getLogger(Ejb3DescriptorHandler.class);
    protected JBossMetaData dd;
    protected List<JBossEnterpriseBeanMetaData> ejbs = new ArrayList<JBossEnterpriseBeanMetaData>();

    public Ejb3DescriptorHandler(Ejb3Deployment deployment, ClassFile cf, JBossMetaData dd) {
        super(deployment, cf);
        assert (dd != null) : "dd is null";
        this.dd = dd;
    }

    public Ejb3DescriptorHandler(Ejb3Deployment deployment, JBossMetaData dd) {
        super(deployment);
        assert (dd != null) : "dd is null";
        this.dd = dd;
    }

    private Interceptors createInterceptorsFromInterceptorBinding(Interceptors original, InterceptorBindingMetaData binding) throws ClassNotFoundException {
        InterceptorClassesMetaData classes;
        InterceptorsImpl impl;
        assert (binding != null) : "binding is null";
        if (binding.isTotalOrdering()) {
            impl = new InterceptorsImpl();
            classes = binding.getInterceptorOrder();
        } else {
            impl = InterceptorsImpl.getImpl((Interceptors)original);
            classes = binding.getInterceptorClasses();
        }
        if (classes != null) {
            for (String name : classes) {
                Class<?> clazz = this.di.getClassLoader().loadClass(name);
                impl.addValue(clazz);
            }
        }
        return impl;
    }

    private List<JBossEnterpriseBeanMetaData> findEjbsByClass(JBossMetaData dd, String className) {
        assert (dd != null) : "dd is null";
        assert (className != null) : "className is null";
        ArrayList<JBossEnterpriseBeanMetaData> result = new ArrayList<JBossEnterpriseBeanMetaData>();
        JBossEnterpriseBeansMetaData enterpriseBeans = dd.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return result;
        }
        for (JBossEnterpriseBeanMetaData bean : enterpriseBeans) {
            if (bean.getEjbClass() == null || !bean.getEjbClass().equals(className)) continue;
            result.add(bean);
        }
        return result;
    }

    @Override
    public boolean isEjb() {
        if (super.isEjb()) {
            return true;
        }
        JBossEnterpriseBeansMetaData enterpriseBeans = this.dd.getEnterpriseBeans();
        if (enterpriseBeans == null) {
            return false;
        }
        return this.findEjbsByClass(this.dd, this.cf.getName()).size() > 0;
    }

    private Class<?> loadClass(EJBContainer container, String name) {
        if (name == null) {
            return container.getBeanClass();
        }
        try {
            return this.di.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void populateBaseInfo() throws Exception {
        super.populateBaseInfo();
        List<JBossEnterpriseBeanMetaData> ejbsByClass = this.findEjbsByClass(this.dd, this.cf.getName());
        for (int i = 0; i < this.ejbNames.size(); ++i) {
            String ejbNameFromAnnotation = (String)this.ejbNames.get(i);
            this.ejbs.add(this.dd.getEnterpriseBean(ejbNameFromAnnotation));
            boolean removed = false;
            int j = 0;
            while (!removed && j < ejbsByClass.size()) {
                JBossEnterpriseBeanMetaData ejbByClass = ejbsByClass.get(j);
                if (ejbByClass.getEjbName().equals(ejbNameFromAnnotation)) {
                    ejbsByClass.remove(j);
                    continue;
                }
                ++j;
            }
        }
        for (JBossEnterpriseBeanMetaData enterpriseBean : ejbsByClass) {
            String ejbName = enterpriseBean.getEjbName();
            this.ejbs.add(enterpriseBean);
            this.ejbNames.add(ejbName);
            this.ejbType = this.getEjbType(enterpriseBean);
        }
    }

    protected Ejb3AnnotationHandler.EJB_TYPE getEjbType(JBossEnterpriseBeanMetaData enterpriseBean) {
        if (enterpriseBean.isSession()) {
            if (((JBossSessionBeanMetaData)enterpriseBean).isStateless()) {
                return Ejb3AnnotationHandler.EJB_TYPE.STATELESS;
            }
            if (((JBossSessionBeanMetaData)enterpriseBean).isStateful()) {
                return Ejb3AnnotationHandler.EJB_TYPE.STATEFUL;
            }
        } else {
            if (enterpriseBean.isEntity()) {
                return Ejb3AnnotationHandler.EJB_TYPE.ENTITY;
            }
            if (enterpriseBean.isMessageDriven()) {
                return Ejb3AnnotationHandler.EJB_TYPE.MESSAGE_DRIVEN;
            }
            if (enterpriseBean.isService()) {
                return Ejb3AnnotationHandler.EJB_TYPE.SERVICE;
            }
            if (enterpriseBean.isConsumer()) {
                return Ejb3AnnotationHandler.EJB_TYPE.CONSUMER;
            }
        }
        return Ejb3AnnotationHandler.EJB_TYPE.UNKNOWN;
    }

    public List<Container> getContainers(Ejb3Deployment deployment, Map<String, Container> preexistingContainers) throws Exception {
        ArrayList<Container> containers = new ArrayList<Container>();
        JBossEnterpriseBeansMetaData allXmlEjbs = this.dd.getEnterpriseBeans() != null ? this.dd.getEnterpriseBeans() : new JBossEnterpriseBeansMetaData();
        this.ejbNames = new ArrayList();
        for (JBossEnterpriseBeanMetaData ejb : allXmlEjbs) {
            String ejbName = ejb.getEjbName();
            if (preexistingContainers.get(ejbName) != null) continue;
            this.ejbNames.add(ejbName);
            this.ejbs.add(ejb);
        }
        for (int ejbIndex = 0; ejbIndex < this.ejbNames.size(); ++ejbIndex) {
            EJBContainer container;
            String ejbName = (String)this.ejbNames.get(ejbIndex);
            JBossEnterpriseBeanMetaData enterpriseBean = this.ejbs.get(ejbIndex);
            this.ejbType = this.getEjbType(enterpriseBean);
            this.className = enterpriseBean.getEjbClass();
            if (this.className == null) {
                log.warn((Object)("Descriptor based bean has no ejb-class defined: " + ejbName));
                continue;
            }
            this.ejbClass = this.di.getClassLoader().loadClass(this.className);
            if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATELESS) {
                container = this.getStatelessContainer(ejbIndex, (JBossSessionBeanMetaData)enterpriseBean);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.STATEFUL) {
                container = this.getStatefulContainer(ejbIndex, (JBossSessionBeanMetaData)enterpriseBean);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.MESSAGE_DRIVEN) {
                container = this.getMDB(ejbIndex, (JBossMessageDrivenBeanMetaData)enterpriseBean);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.SERVICE) {
                container = this.getServiceContainer(ejbIndex, (JBossServiceBeanMetaData)enterpriseBean);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            } else if (this.ejbType == Ejb3AnnotationHandler.EJB_TYPE.CONSUMER) {
                container = this.getConsumerContainer(ejbIndex, (JBossConsumerBeanMetaData)enterpriseBean);
                container.setJaccContextId(this.getJaccContextId());
                containers.add(container);
            }
            log.debug((Object)("found EJB3: ejbName=" + ejbName + ", class=" + this.className + ", type=" + (Object)((Object)this.ejbType)));
        }
        return containers;
    }

    @Override
    protected StatefulContainer getStatefulContainer(int ejbIndex, JBossSessionBeanMetaData enterpriseBean) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        StatefulContainer container = super.getStatefulContainer(ejbIndex, enterpriseBean);
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        StatefulImpl annotation = new StatefulImpl(ejbName);
        if (enterpriseBean != null && !this.isAnnotatedBean()) {
            this.addClassAnnotation(container, (Annotation)annotation);
        }
        if (enterpriseBean instanceof JBossSessionBeanMetaData) {
            this.addInterfaces(container, enterpriseBean);
        } else {
            log.trace((Object)("Not analyzing interfaces on " + enterpriseBean));
        }
        this.addDescriptorAnnotations(container, (JBossEnterpriseBeanMetaData)enterpriseBean, ejbName, true);
        return container;
    }

    private void addHomeAnnotations(EJBContainer container, JBossSessionBeanMetaData sessionBean) throws Exception {
        RemoteHomeImpl annotation;
        if (sessionBean.getHome() != null) {
            annotation = new RemoteHomeImpl(this.di.getClassLoader().loadClass(sessionBean.getHome()));
            this.addClassAnnotation(container, annotation.annotationType(), (Annotation)annotation);
        }
        if (sessionBean.getLocalHome() != null) {
            annotation = new LocalHomeImpl(this.di.getClassLoader().loadClass(sessionBean.getLocalHome()));
            this.addClassAnnotation(container, annotation.annotationType(), (Annotation)annotation);
        }
    }

    @Override
    protected EJBContainer getStatelessContainer(int ejbIndex, JBossSessionBeanMetaData enterpriseBean) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        EJBContainer container = super.getStatelessContainer(ejbIndex, enterpriseBean);
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        StatelessImpl annotation = new StatelessImpl(ejbName);
        if (enterpriseBean != null && !this.isAnnotatedBean()) {
            this.addClassAnnotation(container, Stateless.class, (Annotation)annotation);
        }
        if (enterpriseBean instanceof JBossSessionBeanMetaData) {
            this.addInterfaces(container, enterpriseBean);
        } else {
            log.debug((Object)("Not analyzing interfaces on " + enterpriseBean));
        }
        this.addDescriptorAnnotations(container, (JBossEnterpriseBeanMetaData)enterpriseBean, ejbName);
        return container;
    }

    @Override
    protected ServiceContainer getServiceContainer(int ejbIndex, JBossServiceBeanMetaData service) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        ServiceContainer container = super.getServiceContainer(ejbIndex, service);
        ServiceImpl annotation = new ServiceImpl((Service)container.resolveAnnotation(Service.class));
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        if (service != null && !this.isAnnotatedBean()) {
            if (service.getObjectName() != null) {
                annotation.setObjectName(service.getObjectName());
            }
            if (service.getEjbName() != null) {
                annotation.setName(service.getEjbName());
            }
            if (service.getXmbean() != null) {
                annotation.setXMBean(service.getXmbean());
            }
            this.addClassAnnotation(container, Service.class, (Annotation)annotation);
        }
        this.addInterfaces(container, (JBossSessionBeanMetaData)service);
        this.addDescriptorAnnotations(container, (JBossEnterpriseBeanMetaData)service, ejbName);
        this.addServiceAnnotations(container, service);
        return container;
    }

    @Override
    protected ConsumerContainer getConsumerContainer(int ejbIndex, JBossConsumerBeanMetaData consumer) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        ConsumerContainer container = super.getConsumerContainer(ejbIndex, consumer);
        ConsumerImpl annotation = new ConsumerImpl((Consumer)container.resolveAnnotation(Consumer.class));
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        if (consumer != null && !this.isAnnotatedBean()) {
            ActivationConfigPropertyImpl property;
            if (consumer.getMessageDestination() != null) {
                property = new ActivationConfigPropertyImpl("destination", consumer.getMessageDestination());
                annotation.addActivationConfig((ActivationConfigProperty)property);
            }
            if (consumer.getMessageDestinationType() != null) {
                property = new ActivationConfigPropertyImpl("destinationType", consumer.getMessageDestinationType());
                annotation.addActivationConfig((ActivationConfigProperty)property);
            }
            this.addClassAnnotation(container, Consumer.class, (Annotation)annotation);
        }
        this.addDescriptorAnnotations(container, (JBossEnterpriseBeanMetaData)consumer, ejbName);
        this.addConsumerAnnotations(container, consumer);
        return container;
    }

    @Override
    protected String getMDBDomainName(int ejbIndex) {
        return this.defaultMDBDomain;
    }

    @Override
    protected MDB getMDB(int ejbIndex, JBossMessageDrivenBeanMetaData enterpriseBean) throws Exception {
        String ejbName = (String)this.ejbNames.get(ejbIndex);
        MDB container = super.getMDB(ejbIndex, enterpriseBean);
        container.setAssemblyDescriptor(this.dd.getAssemblyDescriptor());
        if (enterpriseBean instanceof JBossMessageDrivenBeanMetaData) {
            this.addMDBAnnotations(container, ejbName, enterpriseBean);
        }
        this.addDescriptorAnnotations(container, (JBossEnterpriseBeanMetaData)enterpriseBean, ejbName);
        return container;
    }

    @Override
    protected String getAspectDomain(int ejbIndex, String defaultDomain) {
        String aopDomainName;
        JBossEnterpriseBeanMetaData enterpriseBean = this.ejbs.get(ejbIndex);
        if (enterpriseBean != null && (aopDomainName = enterpriseBean.getAopDomainName()) != null) {
            log.debug((Object)("Found aop-domain-name element for annotation " + aopDomainName + " for ejbName " + enterpriseBean.getEjbName()));
            return aopDomainName;
        }
        return super.getAspectDomain(ejbIndex, defaultDomain);
    }

    protected boolean isAnnotatedBean() {
        return super.isEjb() || super.isJBossBeanType();
    }

    private void addMDBAnnotations(MDB container, String ejbName, JBossMessageDrivenBeanMetaData mdb) {
        if (mdb != null) {
            ActivationConfigMetaData activationConfig;
            if (mdb.getResourceAdapterName() != null) {
                ResourceAdapterImpl adapter = new ResourceAdapterImpl(mdb.getResourceAdapterName());
                this.addClassAnnotation(container, ResourceAdapter.class, (Annotation)adapter);
            }
            ArrayList<ActivationConfigPropertyImpl> properties = new ArrayList<ActivationConfigPropertyImpl>();
            if (mdb.isJMS()) {
                SubscriptionDurability subscriptionDurability;
                if (mdb.getAcknowledgeMode() != null) {
                    properties.add(new ActivationConfigPropertyImpl("acknowledgeMode", mdb.getAcknowledgeMode()));
                }
                if (mdb.getMessageDestinationType() != null) {
                    properties.add(new ActivationConfigPropertyImpl("destinationType", mdb.getMessageDestinationType()));
                }
                if ((subscriptionDurability = mdb.getSubscriptionDurability()) != null) {
                    String durable = "false";
                    if (subscriptionDurability.equals((Object)SubscriptionDurability.Durable)) {
                        durable = "true";
                    }
                    properties.add(new ActivationConfigPropertyImpl("subscriptionDurability", durable));
                    if (subscriptionDurability.equals((Object)SubscriptionDurability.Durable)) {
                        properties.add(new ActivationConfigPropertyImpl("subscriptionName", "subscriptionName"));
                    }
                }
                if (mdb.getDestinationJndiName() != null) {
                    properties.add(new ActivationConfigPropertyImpl("destination", mdb.getDestinationJndiName()));
                } else if (mdb.getMessageDestinationLink() != null) {
                    log.warn((Object)"Message destination link on a MDB is not yet implemented, specify a jndi name in jboss.xml");
                }
                if (mdb.getMdbSubscriptionId() != null) {
                    properties.add(new ActivationConfigPropertyImpl("subscriptionName", mdb.getMdbSubscriptionId()));
                }
                if (mdb.getMdbUser() != null) {
                    properties.add(new ActivationConfigPropertyImpl("user", mdb.getMdbUser()));
                }
                if (mdb.getMdbPassword() != null) {
                    properties.add(new ActivationConfigPropertyImpl("password", mdb.getMdbPassword()));
                }
            }
            if ((activationConfig = mdb.getActivationConfig()) != null && activationConfig.getActivationConfigProperties() != null) {
                for (ActivationConfigPropertyMetaData property : activationConfig.getActivationConfigProperties()) {
                    properties.add(new ActivationConfigPropertyImpl(property.getName(), property.getValue()));
                }
            }
            ActivationConfigPropertyImpl[] propsArray = new ActivationConfigPropertyImpl[properties.size()];
            properties.toArray(propsArray);
            MessageDrivenImpl annotation = new MessageDrivenImpl(ejbName, (ActivationConfigProperty[])propsArray);
            if (mdb.getMessagingType() != null) {
                try {
                    annotation.setMessageListenerInterface(container.getClassloader().loadClass(mdb.getMessagingType()));
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
            }
            if (this.isAnnotatedBean()) {
                annotation.merge(this.ejbClass.getAnnotation(MessageDriven.class));
            }
            this.addClassAnnotation(container, MessageDriven.class, (Annotation)annotation);
            this.addDefaultActivationConfig(container, mdb);
        }
    }

    private void addDefaultActivationConfig(MDB container, JBossMessageDrivenBeanMetaData mdb) {
        ActivationConfigMetaData defaultActivationConfig = mdb.getDefaultActivationConfig();
        if (defaultActivationConfig != null) {
            DefaultActivationSpecsImpl activationAnnotation = new DefaultActivationSpecsImpl();
            for (ActivationConfigPropertyMetaData property : defaultActivationConfig.getActivationConfigProperties()) {
                activationAnnotation.addActivationConfigProperty((ActivationConfigProperty)new ActivationConfigPropertyImpl(property.getName(), property.getValue()));
            }
            DefaultActivationSpecs existingAnnotation = this.ejbClass.getAnnotation(DefaultActivationSpecs.class);
            if (existingAnnotation != null) {
                activationAnnotation.merge(existingAnnotation);
            }
            this.addClassAnnotation(container, DefaultActivationSpecs.class, (Annotation)activationAnnotation);
        }
    }

    private void addInterfaces(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws ClassNotFoundException {
        if (enterpriseBean != null) {
            String classname;
            String token;
            StringTokenizer classes;
            ArrayList localClasses = new ArrayList();
            ArrayList remoteClasses = new ArrayList();
            ArrayList<String> localClassNames = new ArrayList<String>();
            ArrayList<String> remoteClassNames = new ArrayList<String>();
            BusinessLocalsMetaData businessLocals = enterpriseBean.getBusinessLocals();
            BusinessRemotesMetaData businessRemotes = enterpriseBean.getBusinessRemotes();
            String local = enterpriseBean.getLocal();
            String remote = enterpriseBean.getRemote();
            if (businessLocals != null) {
                localClassNames.addAll((Collection<String>)businessLocals);
            }
            if (businessRemotes != null) {
                remoteClassNames.addAll((Collection<String>)businessRemotes);
            }
            if (local != null) {
                classes = new StringTokenizer(local, ",");
                while (classes.hasMoreTokens()) {
                    token = classes.nextToken();
                    classname = token.trim();
                    localClassNames.add(classname);
                }
            }
            if (remote != null) {
                classes = new StringTokenizer(remote, ",");
                while (classes.hasMoreTokens()) {
                    token = classes.nextToken();
                    classname = token.trim();
                    remoteClassNames.add(classname);
                }
            }
            for (String localClassName : localClassNames) {
                Class<?> localClass = this.di.getClassLoader().loadClass(localClassName);
                if (!localClass.isInterface()) {
                    throw new RuntimeException("Specified class for @Local " + localClass.getName() + " is not an interface");
                }
                log.debug((Object)("Adding @Local interface " + localClass.getName() + " as specified in metadata"));
                localClasses.add(localClass);
            }
            for (String remoteClassName : remoteClassNames) {
                Class<?> remoteClass = this.di.getClassLoader().loadClass(remoteClassName);
                if (!remoteClass.isInterface()) {
                    throw new RuntimeException("Specified class for @Remote " + remoteClass.getName() + " is not an interface");
                }
                log.debug((Object)("Adding @Remote interface " + remoteClass.getName() + " as specified in metadata"));
                remoteClasses.add(remoteClass);
            }
            if (localClasses.size() > 0) {
                Class[] lIntfs = new Class[localClasses.size()];
                lIntfs = localClasses.toArray(lIntfs);
                this.addClassAnnotation(container, Local.class, (Annotation)new LocalImpl(lIntfs));
            }
            if (remoteClasses.size() > 0) {
                Class[] rIntfs = new Class[remoteClasses.size()];
                rIntfs = remoteClasses.toArray(rIntfs);
                this.addClassAnnotation(container, Remote.class, (Annotation)new RemoteImpl(rIntfs));
            }
        }
    }

    private void addDescriptorAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName) throws Exception {
        this.addDescriptorAnnotations(container, enterpriseBean, ejbName, false);
    }

    private void addDescriptorAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName, boolean isStateful) throws Exception {
        Class<?>[] remoteAndBusinessRemoteInterfaces;
        if (enterpriseBean instanceof JBossGenericBeanMetaData && (remoteAndBusinessRemoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(container)).length == 0) {
            enterpriseBean.setLocalJndiName(enterpriseBean.getMappedName());
            enterpriseBean.setMappedName(null);
        }
        this.addTransactionAnnotations(container, enterpriseBean, ejbName);
        this.addAssemblyAnnotations(container, enterpriseBean, ejbName);
        this.addSecurityAnnotations(container, enterpriseBean, ejbName);
        this.addEjbAnnotations(container, enterpriseBean);
        this.addEjb21Annotations(container, isStateful);
        this.addWebServiceAnnotations(container, enterpriseBean);
    }

    private void addEjb21Annotations(EJBContainer container, boolean isStateful) throws Exception {
        if (SessionBean.class.isAssignableFrom(this.ejbClass)) {
            Class annotationClass;
            Object annotation;
            MethodMetaData method = new MethodMetaData();
            method.setEjbName(container.getEjbName());
            if (this.hasPublicMethod(this.ejbClass, "ejbCreate")) {
                annotation = isStateful ? new InitImpl() : new PostConstructImpl();
                annotationClass = annotation.annotationType();
                method.setMethodName("ejbCreate");
                this.addAnnotations(annotationClass, (Annotation)annotation, container, method);
            }
            annotation = new PostActivateImpl();
            annotationClass = PostActivate.class;
            method.setMethodName("ejbActivate");
            this.addAnnotations(annotationClass, (Annotation)annotation, container, method);
            annotation = new PrePassivateImpl();
            annotationClass = PrePassivate.class;
            method.setMethodName("ejbPassivate");
            this.addAnnotations(annotationClass, (Annotation)annotation, container, method);
            annotation = new PreDestroyImpl();
            annotationClass = PreDestroy.class;
            method.setMethodName("ejbRemove");
            this.addAnnotations(annotationClass, (Annotation)annotation, container, method);
            annotation = new ResourceImpl();
            annotationClass = Resource.class;
            method.setMethodName("setSessionContext");
            this.addAnnotations(annotationClass, (Annotation)annotation, container, method);
        }
    }

    private void addAssemblyAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName) throws Exception {
        JBossAssemblyDescriptorMetaData assembly = this.dd.getAssemblyDescriptor();
        if (assembly != null) {
            this.addExcludeAnnotations(container, assembly.getExcludeList(), ejbName);
        }
        if (enterpriseBean instanceof JBossSessionBeanMetaData) {
            JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)enterpriseBean;
            this.addInitAnnotations(container, sessionBean.getInitMethods(), ejbName);
            this.addRemoveAnnotations(container, sessionBean.getRemoveMethods(), ejbName);
        }
    }

    private void addExcludeAnnotations(EJBContainer container, ExcludeListMetaData list, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        if (list != null && list.getMethods() != null) {
            for (MethodMetaData method : list.getMethods()) {
                if (!method.getEjbName().equals(ejbName)) continue;
                DenyAllImpl annotation = new DenyAllImpl();
                this.addAnnotations(DenyAll.class, (Annotation)annotation, container, method);
            }
        }
    }

    private void addInitAnnotations(EJBContainer container, InitMethodsMetaData list, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        if (list != null) {
            for (InitMethodMetaData initMethod : list) {
                NamedMethodMetaData method = initMethod.getBeanMethod();
                InitImpl annotation = new InitImpl();
                this.addAnnotations(Init.class, (Annotation)annotation, container, method);
            }
        }
    }

    private void addRemoveAnnotations(EJBContainer container, RemoveMethodsMetaData list, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        if (list != null) {
            for (RemoveMethodMetaData removeMethod : list) {
                NamedMethodMetaData method = removeMethod.getBeanMethod();
                RemoveImpl annotation = new RemoveImpl(removeMethod.isRetainIfException());
                this.addAnnotations(Remove.class, (Annotation)annotation, container, method);
            }
        }
    }

    private void addSecurityAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        SecurityDomainImpl annotation;
        String securityDomain;
        JBossAssemblyDescriptorMetaData assembly = this.dd.getAssemblyDescriptor();
        if (assembly != null) {
            MethodPermissionsMetaData methodPermissions;
            SecurityRolesMetaData securityRoles = assembly.getSecurityRoles();
            if (securityRoles != null && securityRoles.size() > 0) {
                ArrayList<String> roleList = new ArrayList<String>();
                for (SecurityRoleMetaData securityRole : securityRoles) {
                    roleList.add(securityRole.getRoleName());
                }
                DeclareRolesImpl annotation2 = new DeclareRolesImpl(roleList.toArray(new String[roleList.size()]));
                this.addClassAnnotation(container, DeclareRoles.class, (Annotation)annotation2);
            }
            if ((methodPermissions = assembly.getMethodPermissions()) != null) {
                for (MethodPermissionMetaData permission : methodPermissions) {
                    for (MethodMetaData method : permission.getMethods()) {
                        PermitAllImpl annotation3;
                        if (!method.getEjbName().equals(ejbName)) continue;
                        if (permission.isNotChecked()) {
                            annotation3 = new PermitAllImpl();
                            this.addAnnotations(PermitAll.class, (Annotation)annotation3, container, method);
                            continue;
                        }
                        annotation3 = new RolesAllowedImpl();
                        for (String roleName : permission.getRoles()) {
                            annotation3.addValue(roleName);
                        }
                        log.debug((Object)("Adding @" + RolesAllowed.class.getSimpleName() + " for method " + method.getMethodName() + "(" + method.getMethodParams() + ") of EJB " + method.getEjbName() + ": " + Arrays.asList(annotation3.value())));
                        this.addAnnotations(RolesAllowed.class, (Annotation)annotation3, container, method);
                    }
                }
            }
        }
        if (enterpriseBean != null && enterpriseBean.getSecurityDomain() != null) {
            securityDomain = enterpriseBean.getSecurityDomain();
            annotation = new SecurityDomainImpl(securityDomain);
            if (this.dd.getUnauthenticatedPrincipal() != null) {
                annotation.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
            }
            this.addClassAnnotation(container, annotation.annotationType(), (Annotation)annotation);
        } else if (this.dd.getSecurityDomain() != null) {
            securityDomain = this.dd.getSecurityDomain();
            annotation = new SecurityDomainImpl(securityDomain);
            if (this.dd.getUnauthenticatedPrincipal() != null) {
                annotation.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
            }
            this.addClassAnnotation(container, annotation.annotationType(), (Annotation)annotation);
        } else if (this.dd.getUnauthenticatedPrincipal() != null) {
            SecurityDomainImpl override;
            SecurityDomain annotation4 = this.ejbClass.getAnnotation(SecurityDomain.class);
            if (annotation4 != null) {
                override = new SecurityDomainImpl(annotation4.value());
                override.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
            } else {
                override = new SecurityDomainImpl();
                override.setUnauthenticatedPrincipal(this.dd.getUnauthenticatedPrincipal());
            }
            this.addClassAnnotation(container, override.annotationType(), (Annotation)override);
        }
    }

    private void addTransactionAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        JBossAssemblyDescriptorMetaData descriptor;
        if (enterpriseBean != null) {
            MethodAttributesMetaData attributes;
            TransactionManagementType transactionType = enterpriseBean.getTransactionType();
            if (transactionType != null) {
                TransactionManagementImpl annotation = new TransactionManagementImpl();
                annotation.setValue(transactionType);
                this.addClassAnnotation(container, TransactionManagement.class, (Annotation)annotation);
            }
            if ((attributes = enterpriseBean.getMethodAttributes()) != null) {
                for (MethodAttributeMetaData method : attributes) {
                    TransactionTimeoutImpl timeoutAnnotation = new TransactionTimeoutImpl(method.getTransactionTimeout());
                    this.addAnnotations(TransactionTimeout.class, (Annotation)timeoutAnnotation, container, method.getMethodName(), null);
                }
            }
        }
        if ((descriptor = this.dd.getAssemblyDescriptor()) != null && descriptor.getContainerTransactions() != null) {
            for (ContainerTransactionMetaData transaction : descriptor.getContainerTransactions()) {
                for (MethodMetaData method : transaction.getMethods()) {
                    if (!method.getEjbName().equals(ejbName)) continue;
                    TransactionAttributeImpl annotation = new TransactionAttributeImpl();
                    annotation.setType(transaction.getTransAttribute());
                    this.addAnnotations(TransactionAttribute.class, (Annotation)annotation, container, method);
                }
            }
        }
    }

    private void addInterceptorBindingAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, String ejbName) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        boolean definesInterceptors = false;
        InterceptorBindingsMetaData interceptorBindings = this.dd.getAssemblyDescriptor().getInterceptorBindings();
        if (interceptorBindings != null) {
            for (InterceptorBindingMetaData binding : interceptorBindings) {
                if (!binding.getEjbName().equals(ejbName)) continue;
                if (binding.getMethod() == null) {
                    this.addClassLevelInterceptorBindingAnnotations(container, binding);
                    definesInterceptors = true;
                    continue;
                }
                definesInterceptors = this.addMethodLevelInterceptorBindingAnnotations(container, binding);
            }
        }
    }

    private void addClassLevelInterceptorBindingAnnotations(EJBContainer container, InterceptorBindingMetaData binding) throws ClassNotFoundException {
        Interceptors interceptors = (Interceptors)container.resolveAnnotation(Interceptors.class);
        if (binding != null) {
            Interceptors impl = this.createInterceptorsFromInterceptorBinding(interceptors, binding);
            this.addClassAnnotation(container, impl.annotationType(), (Annotation)impl);
        }
        boolean exclude = false;
        if (binding != null) {
            exclude = binding.isExcludeDefaultInterceptors();
        }
        if (exclude && container.resolveAnnotation(ExcludeDefaultInterceptors.class) == null) {
            this.addClassAnnotation(container, ExcludeDefaultInterceptors.class, (Annotation)new ExcludeDefaultInterceptorsImpl());
        }
    }

    private boolean addMethodLevelInterceptorBindingAnnotations(EJBContainer container, InterceptorBindingMetaData binding) throws ClassNotFoundException {
        return false;
    }

    private void addEjbAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean) throws Exception {
        if (enterpriseBean != null) {
            if (enterpriseBean instanceof JBossSessionBeanMetaData) {
                this.addHomeAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
                this.addJndiAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
            }
            this.addInterceptorMethodAnnotations(container, enterpriseBean);
            this.handleResourceRefs(container, enterpriseBean.getResourceReferences());
            this.addMessageDestinationAnnotations(container, enterpriseBean.getMessageDestinationReferences());
            this.addSecurityIdentityAnnotation(container, enterpriseBean.getSecurityIdentity());
            this.addDependencies(container, enterpriseBean);
            this.addPoolAnnotations(container, enterpriseBean);
            this.addXmlAnnotations(container, enterpriseBean);
            if (enterpriseBean instanceof JBossSessionBeanMetaData) {
                this.addConcurrentAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
                this.addClusterAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
                this.addCacheAnnotations(container, (JBossSessionBeanMetaData)enterpriseBean);
            }
        }
    }

    private void addWebServiceAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean) {
        PortComponent pc;
        if (enterpriseBean != null && enterpriseBean instanceof JBossSessionBeanMetaData && (pc = ((JBossSessionBeanMetaData)enterpriseBean).getPortComponent()) != null) {
            PortComponentMD annotation = new PortComponentMD();
            annotation.setAuthMethod(pc.getAuthMethod());
            annotation.setPortComponentName(pc.getPortComponentName());
            annotation.setPortComponentURI(pc.getPortComponentURI());
            annotation.setSecureWSDLAccess(pc.getSecureWSDLAccess());
            annotation.setTransportGuarantee(pc.getTransportGuarantee());
            this.addClassAnnotation(container, PortComponentSpec.class, (Annotation)annotation);
        }
    }

    private void addConcurrentAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws Exception {
        if (enterpriseBean.isConcurrent() != null) {
            if (enterpriseBean.isConcurrent().booleanValue()) {
                SerializedConcurrentAccessImpl annotation = new SerializedConcurrentAccessImpl();
                this.addClassAnnotation(container, SerializedConcurrentAccess.class, (Annotation)annotation);
            } else {
                container.getAnnotations().disableAnnotation(SerializedConcurrentAccess.class.getName());
            }
        }
    }

    private void addPoolAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean) throws Exception {
        if (enterpriseBean.getPoolConfig() != null) {
            PoolConfigMetaData config = enterpriseBean.getPoolConfig();
            PoolImpl poolAnnotation = new PoolImpl();
            if (config.getValue() != null && !config.getValue().trim().equals("")) {
                poolAnnotation.setValue(config.getValue());
            }
            if (config.getValue() == null || config.getValue().trim().equals("")) {
                poolAnnotation.setValue("ThreadlocalPool");
            }
            if (config.getMaxSize() != null) {
                poolAnnotation.setMaxSize(config.getMaxSize().intValue());
            }
            if (config.getTimeout() != null) {
                poolAnnotation.setTimeout((long)config.getTimeout().intValue());
            }
            this.addClassAnnotation(container, Pool.class, (Annotation)poolAnnotation);
        }
    }

    private void addXmlAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean) throws Exception {
        AnnotationsMetaData annotations = enterpriseBean.getAnnotations();
        if (annotations == null) {
            return;
        }
        for (AnnotationMetaData xmlAnnotation : annotations) {
            Class<?> annotationClass = this.di.getClassLoader().loadClass(xmlAnnotation.getAnnotationClass());
            Class<?> annotationImplementationClass = this.di.getClassLoader().loadClass(xmlAnnotation.getAnnotationImplementationClass());
            Annotation annotation = (Annotation)annotationImplementationClass.newInstance();
            AnnotationPropertiesMetaData properties = xmlAnnotation.getProperties();
            if (properties != null) {
                for (AnnotationPropertyMetaData property : properties) {
                    Field field = annotationImplementationClass.getDeclaredField(property.getName());
                    this.setAnnotationPropertyField(field, annotation, property.getPropertyValue());
                }
            }
            if (xmlAnnotation.getInjectionTarget() == null) {
                this.addClassAnnotation(container, annotationClass, annotation);
                continue;
            }
            MethodMetaData method = new MethodMetaData();
            method.setMethodName(xmlAnnotation.getInjectionTarget().getInjectionTargetName());
            this.addAnnotations(annotationClass, annotation, container, method);
        }
    }

    protected void setAnnotationPropertyField(Field field, Object annotation, String value) throws Exception {
        if (field.getType() == String.class) {
            field.set(annotation, value);
        } else if (field.getType() == Long.class || field.getType() == Long.TYPE) {
            field.setLong(annotation, Long.parseLong(value));
        } else if (field.getType() == Integer.class || field.getType() == Integer.TYPE) {
            field.setInt(annotation, Integer.parseInt(value));
        } else if (field.getType() == Class.class) {
            field.set(annotation, this.di.getClassLoader().loadClass(value));
        } else if (field.getType() == Boolean.class || field.getType() == Boolean.TYPE) {
            field.setBoolean(annotation, Boolean.parseBoolean(value));
        } else {
            throw new IllegalArgumentException("unsupported field type " + field.getType() + " on field " + field);
        }
    }

    private void addCacheAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws Exception {
        if (enterpriseBean.getCacheConfig() != null) {
            CacheConfig existingConfig;
            CacheConfigImpl configAnnotation;
            CacheConfigMetaData config = enterpriseBean.getCacheConfig();
            if (config.getValue() != null && !config.getValue().equals("")) {
                String cacheValue = config.getValue();
                CacheImpl cacheAnnotation = new CacheImpl(cacheValue);
                this.addClassAnnotation(container, Cache.class, (Annotation)cacheAnnotation);
                if (cacheValue.equals("SimpleStatefulCache") && !this.ejbClass.isAnnotationPresent(PersistenceManager.class)) {
                    PersistenceManagerImpl persistenceAnnotation = new PersistenceManagerImpl();
                    if (config.getPersistenceManager() != null) {
                        persistenceAnnotation.setValue(config.getPersistenceManager());
                    }
                    this.addClassAnnotation(container, PersistenceManager.class, (Annotation)persistenceAnnotation);
                }
            }
            if (config.getName() != null) {
                configAnnotation = new CacheConfigImpl();
                configAnnotation.setName(config.getName());
                if (config.getMaxSize() != null) {
                    configAnnotation.setMaxSize(config.getMaxSize().intValue());
                }
                if (config.getIdleTimeoutSeconds() != null) {
                    configAnnotation.setIdleTimeoutSeconds((long)config.getIdleTimeoutSeconds().intValue());
                }
                if (config.getReplicationIsPassivation() != null) {
                    configAnnotation.setReplicationIsPassivation(Boolean.parseBoolean(config.getReplicationIsPassivation()));
                }
                if (config.getRemoveTimeoutSeconds() != null) {
                    configAnnotation.setRemovalTimeoutSeconds((long)config.getRemoveTimeoutSeconds().intValue());
                }
                if ((existingConfig = this.ejbClass.getAnnotation(CacheConfig.class)) != null) {
                    configAnnotation.merge(existingConfig);
                }
                this.addClassAnnotation(container, CacheConfig.class, (Annotation)configAnnotation);
            } else {
                configAnnotation = new CacheConfigImpl();
                if (config.getMaxSize() != null) {
                    configAnnotation.setMaxSize(config.getMaxSize().intValue());
                }
                if (config.getIdleTimeoutSeconds() != null) {
                    configAnnotation.setIdleTimeoutSeconds((long)config.getIdleTimeoutSeconds().intValue());
                }
                if (config.getRemoveTimeoutSeconds() != null) {
                    configAnnotation.setRemovalTimeoutSeconds((long)config.getRemoveTimeoutSeconds().intValue());
                }
                if ((existingConfig = this.ejbClass.getAnnotation(CacheConfig.class)) != null) {
                    configAnnotation.merge(existingConfig);
                }
                this.addClassAnnotation(container, CacheConfig.class, (Annotation)configAnnotation);
            }
        }
    }

    private void addClusterAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws Exception {
        ClusterConfigMetaData config = enterpriseBean.getClusterConfig();
        if (config != null) {
            String policy;
            ClusteredImpl clusteredAnnotation = new ClusteredImpl();
            if (config.getBeanLoadBalancePolicy() != null) {
                policy = config.getBeanLoadBalancePolicy();
                clusteredAnnotation.setLoadBalancePolicy(policy);
            }
            if (config.getHomeLoadBalancePolicy() != null) {
                policy = config.getHomeLoadBalancePolicy();
                clusteredAnnotation.setHomeLoadBalancePolicy(policy);
            }
            if (config.getPartitionName() != null) {
                clusteredAnnotation.setPartition(config.getPartitionName());
            }
            this.addClassAnnotation(container, Clustered.class, (Annotation)clusteredAnnotation);
        }
    }

    private void addDependencies(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean) throws Exception {
        Set depends = enterpriseBean.getDepends();
        if (depends != null && depends.size() > 0) {
            DependsImpl annotation = new DependsImpl();
            Iterator dependencies = enterpriseBean.getDepends().iterator();
            while (dependencies.hasNext()) {
                annotation.addDependency((String)dependencies.next());
            }
            this.addClassAnnotation(container, Depends.class, (Annotation)annotation);
        }
        if (enterpriseBean.getIgnoreDependency() != null) {
            for (ResourceInjectionTargetMetaData ignore : enterpriseBean.getIgnoreDependency().getInjectionTargets()) {
                IgnoreDependencyImpl annotation = new IgnoreDependencyImpl();
                MethodMetaData method = new MethodMetaData();
                method.setMethodName(ignore.getInjectionTargetName());
                this.addAnnotations(IgnoreDependency.class, (Annotation)annotation, container, method);
            }
        }
    }

    private void addServiceAnnotations(EJBContainer container, JBossServiceBeanMetaData service) throws ClassNotFoundException {
        if (service == null) {
            return;
        }
        String management = service.getManagement();
        if (management != null) {
            ManagementImpl annotation = new ManagementImpl(this.di.getClassLoader().loadClass(management));
            this.addClassAnnotation(container, Management.class, (Annotation)annotation);
        }
    }

    private void addConsumerAnnotations(EJBContainer container, JBossConsumerBeanMetaData consumer) throws ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        List propertiesList;
        MethodAttributesMetaData currentMessage;
        if (consumer == null) {
            return;
        }
        List producers = consumer.getProducers();
        List localProducers = consumer.getLocalProducers();
        if (producers != null && producers.size() > 0 || localProducers != null && localProducers.size() > 0) {
            ProducerImpl annotation;
            ProducersImpl producersAnnotation = new ProducersImpl();
            if (producers != null) {
                for (ProducerMetaData producer : producers) {
                    annotation = new ProducerImpl(this.di.getClassLoader().loadClass(producer.getClassName()));
                    if (producer.getConnectionFactory() != null) {
                        annotation.setConnectionFactory(producer.getConnectionFactory());
                    }
                    producersAnnotation.addProducer((Producer)annotation);
                }
            }
            if (localProducers != null) {
                for (ProducerMetaData producer : localProducers) {
                    annotation = new ProducerImpl(this.di.getClassLoader().loadClass(producer.getClassName()));
                    if (producer.getConnectionFactory() != null) {
                        annotation.setConnectionFactory(producer.getConnectionFactory());
                    }
                    producersAnnotation.addProducer((Producer)annotation);
                }
            }
            this.addClassAnnotation(container, Producers.class, (Annotation)producersAnnotation);
        }
        if ((currentMessage = consumer.getCurrentMessage()) != null) {
            CurrentMessageImpl annotation = new CurrentMessageImpl();
            for (MethodAttributeMetaData method : currentMessage) {
                this.addAnnotations(CurrentMessage.class, annotation, container, method);
            }
        }
        if ((propertiesList = consumer.getMessageProperties()) != null) {
            for (MessagePropertiesMetaData properties : propertiesList) {
                String interfac;
                MessagePropertiesImpl annotation = new MessagePropertiesImpl();
                String delivery = properties.getDelivery();
                if (delivery != null && delivery.equals("Persistent")) {
                    annotation.setDelivery(DeliveryMode.PERSISTENT);
                } else {
                    annotation.setDelivery(DeliveryMode.NON_PERSISTENT);
                }
                Integer priority = properties.getPriority();
                if (priority != null) {
                    annotation.setDelivery(DeliveryMode.PERSISTENT);
                }
                if ((interfac = properties.getClassName()) != null) {
                    Class<?> clazz = this.di.getClassLoader().loadClass(interfac);
                    annotation.setInterface(clazz);
                }
                MethodAttributeMetaData method = properties.getMethod();
                this.addAnnotations(MessageProperties.class, annotation, container, method);
            }
        }
    }

    private void addJndiAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws ClassNotFoundException {
        this.addLocalJndiAnnotations(container, enterpriseBean);
        this.addRemoteJndiAnnotations(container, enterpriseBean);
    }

    private void addLocalJndiAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws ClassNotFoundException {
        String localHomeJndiName;
        String localJndiName = enterpriseBean.getLocalJndiName();
        if (localJndiName != null) {
            LocalBindingImpl localBinding = new LocalBindingImpl(localJndiName);
            this.addClassAnnotation(container, LocalBinding.class, (Annotation)localBinding);
        }
        if ((localHomeJndiName = enterpriseBean.getLocalHomeJndiName()) != null) {
            LocalHomeBindingImpl localHomeBinding = new LocalHomeBindingImpl(localHomeJndiName);
            this.addClassAnnotation(container, LocalHomeBinding.class, (Annotation)localHomeBinding);
        }
    }

    private void addRemoteJndiAnnotations(EJBContainer container, JBossSessionBeanMetaData enterpriseBean) throws ClassNotFoundException {
        String jndiName;
        String homeJndiName = enterpriseBean.getHomeJndiName();
        if (homeJndiName != null && !homeJndiName.trim().equals("")) {
            RemoteHomeBindingImpl homeBinding = new RemoteHomeBindingImpl(homeJndiName);
            this.addClassAnnotation(container, RemoteHomeBinding.class, (Annotation)homeBinding);
        }
        if ((jndiName = enterpriseBean.getJndiName()) != null && !jndiName.trim().equals("")) {
            RemoteBindingImpl remoteBindingAnnotation = new RemoteBindingImpl();
            remoteBindingAnnotation.setJndiBinding(jndiName);
            this.addClassAnnotation(container, RemoteBinding.class, (Annotation)remoteBindingAnnotation);
            log.debug((Object)("Adding " + RemoteBinding.class.getName() + " to " + container.toString() + ": " + remoteBindingAnnotation.toString()));
            return;
        }
        List bindingsList = enterpriseBean.getRemoteBindings();
        if (bindingsList == null || bindingsList.size() == 0) {
            this.addSimpleJndiAnnotations(container, (JBossEnterpriseBeanMetaData)enterpriseBean);
            return;
        }
        AnnotationRepository annotations = container.getAnnotations();
        annotations.disableAnnotation(RemoteBinding.class.getName());
        ArrayList<RemoteBindingImpl> bindingAnnotationsList = new ArrayList<RemoteBindingImpl>();
        for (RemoteBindingMetaData binding : bindingsList) {
            RemoteBindingImpl bindingAnnotation = new RemoteBindingImpl();
            if (binding.getJndiName() != null) {
                bindingAnnotation.setJndiBinding(binding.getJndiName());
            }
            if (binding.getClientBindUrl() != null) {
                bindingAnnotation.setBindUrl(binding.getClientBindUrl());
            }
            if (binding.getInterceptorStack() != null) {
                bindingAnnotation.setStack(binding.getInterceptorStack());
            }
            bindingAnnotationsList.add(bindingAnnotation);
        }
        RemoteBindingsImpl bindingsAnnotation = new RemoteBindingsImpl(bindingAnnotationsList);
        this.addClassAnnotation(container, RemoteBindings.class, (Annotation)bindingsAnnotation);
    }

    private void addSimpleJndiAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean) throws ClassNotFoundException {
        RemoteBindingImpl remoteBinding = null;
        String jndiName = enterpriseBean.getMappedName();
        if (jndiName != null) {
            remoteBinding = new RemoteBindingImpl();
            remoteBinding.setJndiBinding(jndiName);
            this.addClassAnnotation(container, RemoteBinding.class, (Annotation)remoteBinding);
        }
        if (remoteBinding != null) {
            RemoteBinding existingBinding = this.ejbClass.getAnnotation(RemoteBinding.class);
            if (existingBinding != null) {
                remoteBinding.merge(existingBinding);
            }
            this.addClassAnnotation(container, RemoteBinding.class, (Annotation)remoteBinding);
        }
    }

    private void handleResourceRefs(EJBContainer container, ResourceReferencesMetaData resourceRefList) {
        if (resourceRefList == null) {
            return;
        }
        for (ResourceReferenceMetaData ref : resourceRefList) {
            ResourceManagerMetaData resourceManager;
            if (ref.getResourceName() == null || (resourceManager = this.dd.getResourceManager(ref.getResourceName())) == null) continue;
            ref.setJndiName(resourceManager.getResJndiName());
            ref.setMappedName(resourceManager.getResJndiName());
        }
    }

    private void addMessageDestinationAnnotations(EJBContainer container, MessageDestinationReferencesMetaData refs) {
        if (refs == null) {
            return;
        }
        for (MessageDestinationReferenceMetaData ref : refs) {
            MessageDestinationMetaData destination;
            JBossAssemblyDescriptorMetaData descriptor;
            if (ref.getMappedName() != null && !ref.getMappedName().equals("") || (descriptor = this.dd.getAssemblyDescriptor()) == null || (destination = descriptor.getMessageDestination(ref.getLink())) == null) continue;
            ref.setMappedName(destination.getJndiName());
        }
    }

    private void addInterceptorMethodAnnotations(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean) {
        if (enterpriseBean instanceof JBossSessionBeanMetaData) {
            JBossSessionBeanMetaData sessionBean = (JBossSessionBeanMetaData)enterpriseBean;
            this.addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getAroundInvokes(), AroundInvoke.class, "around-invoke-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPostConstructs(), PostConstruct.class, "post-construct-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPostActivates(), PostActivate.class, "post-activate-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPrePassivates(), PrePassivate.class, "pre-passivate-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, sessionBean.getPreDestroys(), PreDestroy.class, "pre-destroy-method");
        } else if (enterpriseBean instanceof JBossMessageDrivenBeanMetaData) {
            JBossMessageDrivenBeanMetaData messageDriven = (JBossMessageDrivenBeanMetaData)enterpriseBean;
            this.addInterceptorMethodAnnotation(container, enterpriseBean, messageDriven.getAroundInvokes(), AroundInvoke.class, "around-invoke-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, messageDriven.getPostConstructs(), PostConstruct.class, "post-construct-method");
            this.addInterceptorMethodAnnotation(container, enterpriseBean, messageDriven.getPreDestroys(), PreDestroy.class, "pre-destroy-method");
        }
    }

    private void addInterceptorMethodAnnotation(EJBContainer container, Class<?> cls, String methodName, Class<? extends Annotation> ann, String xmlName) {
        Method found = null;
        for (Method rm : cls.getDeclaredMethods()) {
            if (!rm.getName().equals(methodName)) continue;
            if (ann == AroundInvoke.class) {
                if (!InterceptorInfoRepository.checkValidBusinessSignature(rm)) continue;
                found = rm;
                break;
            }
            if (!InterceptorInfoRepository.checkValidBeanLifecycleSignature(rm)) continue;
            found = rm;
            break;
        }
        if (found == null) {
            log.warn((Object)("No method found within " + cls.getName() + " with name " + methodName + " with the right signature for " + xmlName + "was found"));
            return;
        }
        if (container.resolveAnnotation(found, ann) == null) {
            log.debug((Object)("adding " + ann.getName() + " method annotation to " + found));
            container.getAnnotations().addAnnotation((Member)found, ann, this.getInterceptorImpl(ann));
        }
    }

    private void addInterceptorMethodAnnotation(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, AroundInvokesMetaData callbacks, Class<? extends Annotation> ann, String xmlName) {
        if (callbacks == null) {
            return;
        }
        for (AroundInvokeMetaData callback : callbacks) {
            Class<?> callbackClass = this.loadClass(container, callback.getClassName());
            this.addInterceptorMethodAnnotation(container, callbackClass, callback.getMethodName(), ann, xmlName);
        }
    }

    private void addInterceptorMethodAnnotation(EJBContainer container, JBossEnterpriseBeanMetaData enterpriseBean, LifecycleCallbacksMetaData callbacks, Class<? extends Annotation> ann, String xmlName) {
        if (callbacks == null) {
            return;
        }
        for (LifecycleCallbackMetaData callback : callbacks) {
            Class<?> callbackClass = this.loadClass(container, callback.getClassName());
            this.addInterceptorMethodAnnotation(container, callbackClass, callback.getMethodName(), ann, xmlName);
        }
    }

    private Object getInterceptorImpl(Class<?> ann) {
        if (ann == AroundInvoke.class) {
            return new AroundInvokeImpl();
        }
        if (ann == PostConstruct.class) {
            return new PostConstructImpl();
        }
        if (ann == PostActivate.class) {
            return new PostActivateImpl();
        }
        if (ann == PrePassivate.class) {
            return new PrePassivateImpl();
        }
        if (ann == PreDestroy.class) {
            return new PreDestroyImpl();
        }
        return null;
    }

    private void addSecurityIdentityAnnotation(EJBContainer container, SecurityIdentityMetaData identity) {
        if (identity != null && !identity.isUseCallerId()) {
            String runAsPrincipal;
            RunAsMetaData runAs = identity.getRunAs();
            RunAsImpl annotation = null;
            if (runAs != null) {
                annotation = new RunAsImpl(runAs.getRoleName());
                this.addClassAnnotation(container, annotation.annotationType(), (Annotation)annotation);
            }
            if ((runAsPrincipal = identity.getRunAsPrincipal()) != null) {
                RunAsPrincipalImpl principalAnnotation = new RunAsPrincipalImpl(runAsPrincipal);
                this.addClassAnnotation(container, principalAnnotation.annotationType(), (Annotation)principalAnnotation);
            }
        }
    }

    @Deprecated
    protected void overrideAnnotations(EJBContainer container, Member m, String annotation, Object value) {
    }

    private void addClassAnnotation(EJBContainer container, Annotation annotation) {
        this.addClassAnnotation(container, annotation.annotationType(), annotation);
    }

    private void addClassAnnotation(EJBContainer container, Class<? extends Annotation> annotationClass, Annotation annotation) {
        log.debug((Object)("adding class annotation " + annotationClass.getName() + " to " + container + " " + annotation));
        container.getAnnotations().addClassAnnotation(annotationClass, (Object)annotation);
    }

    private <A extends Annotation> void addAnnotations(Class<A> annotationClass, A annotation, EJBContainer container, MethodAttributeMetaData method) {
        this.addAnnotations(annotationClass, annotation, container, method.getMethodName(), null);
    }

    private void addAnnotations(Class<? extends Annotation> annotationClass, Annotation annotation, EJBContainer container, String methodName, MethodParametersMetaData params) {
        try {
            AnnotationRepository annotations = container.getAnnotations();
            if (methodName.equals("*")) {
                log.debug((Object)("adding " + annotationClass.getName() + " annotation to " + this.ejbClass.getName() + "." + methodName));
                for (Method declaredMethod : this.ejbClass.getDeclaredMethods()) {
                    annotations.addAnnotation((Member)declaredMethod, annotationClass, (Object)annotation);
                    this.overrideAnnotations(container, declaredMethod, annotationClass.getName(), annotation);
                }
            } else if (params == null) {
                Field member;
                int methodIndex;
                Method[] methods = this.ejbClass.getMethods();
                boolean foundMethod = false;
                for (methodIndex = 0; methodIndex < methods.length; ++methodIndex) {
                    if (!methods[methodIndex].getName().equals(methodName)) continue;
                    log.debug((Object)("adding " + annotationClass.getName() + " method annotation to " + methods[methodIndex]));
                    annotations.addAnnotation((Member)methods[methodIndex], annotationClass, (Object)annotation);
                    this.overrideAnnotations(container, methods[methodIndex], annotationClass.getName(), annotation);
                    foundMethod = true;
                }
                if (!foundMethod) {
                    methods = this.ejbClass.getDeclaredMethods();
                    for (methodIndex = 0; methodIndex < methods.length; ++methodIndex) {
                        if (!methods[methodIndex].getName().equals(methodName)) continue;
                        log.debug((Object)("adding " + annotationClass.getName() + " method annotation to " + methods[methodIndex]));
                        annotations.addAnnotation((Member)methods[methodIndex], annotationClass, (Object)annotation);
                        this.overrideAnnotations(container, methods[methodIndex], annotationClass.getName(), annotation);
                        foundMethod = true;
                    }
                }
                if (!foundMethod && (member = this.ejbClass.getDeclaredField(methodName)) != null) {
                    log.debug((Object)("adding " + annotationClass.getName() + " field annotation to " + member));
                    annotations.addAnnotation((Member)member, annotationClass, (Object)annotation);
                    this.overrideAnnotations(container, member, annotationClass.getName(), annotation);
                }
            } else {
                Object[] methodSignature = new Class[params.size()];
                int paramIndex = 0;
                for (String param : params) {
                    Class paramClass = PrimitiveClassLoadingUtil.loadClass((String)param, (ClassLoader)this.di.getClassLoader());
                    methodSignature[paramIndex++] = paramClass;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Looking for method " + methodName + Arrays.toString(methodSignature) + " on class " + this.ejbClass));
                }
                Method member = ClassHelper.getPrivateMethod((Class)this.ejbClass, (String)methodName, (Class[])methodSignature);
                log.debug((Object)("adding " + annotationClass.getName() + " method annotation to " + member));
                annotations.addAnnotation((Member)member, annotationClass, (Object)annotation);
                this.overrideAnnotations(container, member, annotationClass.getName(), annotation);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to create annotation for method/field " + methodName + " for EJB " + container.getEjbName(), e);
        }
    }

    private void addAnnotations(Class<? extends Annotation> annotationClass, Annotation annotation, EJBContainer container, NamedMethodMetaData method) {
        this.addAnnotations(annotationClass, annotation, container, method.getMethodName(), method.getMethodParams());
    }

    private void addAnnotations(Class<? extends Annotation> annotationClass, Annotation annotation, EJBContainer container, MethodMetaData method) throws ClassNotFoundException, NoSuchMethodException, NoSuchFieldException {
        this.addAnnotations(annotationClass, annotation, container, method.getMethodName(), method.getMethodParams());
    }

    private boolean hasPublicMethod(Class<?> cls, String methodName) {
        assert (cls != null) : "cls is null";
        assert (methodName != null) : "methodName is null";
        for (Method m : cls.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return true;
        }
        return false;
    }
}

