/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.marshal.compress;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import org.jboss.remoting.marshal.UnMarshaller;
import org.jboss.remoting.marshal.VersionedUnMarshaller;
import org.jboss.remoting.marshal.http.HTTPUnMarshaller;
import org.jboss.remoting.marshal.serializable.SerializableUnMarshaller;
import org.jboss.remoting.serialization.SerializationManager;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class CompressingUnMarshaller
extends SerializableUnMarshaller {
    public static final String DATATYPE = "compressible";
    private UnMarshaller wrappedUnMarshaller;
    private static final long serialVersionUID = 3843451434770746776L;

    public CompressingUnMarshaller() {
    }

    public CompressingUnMarshaller(UnMarshaller unMarshaller) {
        this.wrappedUnMarshaller = unMarshaller;
    }

    @Override
    public InputStream getMarshallingStream(InputStream inputStream) throws IOException {
        SelfCleaningGZipInputStream gzis = new SelfCleaningGZipInputStream(inputStream);
        DecomposableBufferedInputStream bis = new DecomposableBufferedInputStream(gzis);
        return bis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object read(InputStream inputStream, Map metadata, int version) throws IOException, ClassNotFoundException {
        SelfCleaningGZipInputStream gzis = null;
        DecomposableBufferedInputStream bis = null;
        if (inputStream instanceof DecomposableBufferedInputStream) {
            bis = (DecomposableBufferedInputStream)inputStream;
            gzis = (SelfCleaningGZipInputStream)bis.getWrappedStream();
        } else {
            gzis = new SelfCleaningGZipInputStream(inputStream);
            bis = new DecomposableBufferedInputStream(gzis);
        }
        SerializationManager manager = SerializationStreamFactory.getManagerInstance(this.getSerializationType());
        ObjectInputStream ois = manager.createInput(bis, this.getClassLoader());
        try {
            if (this.wrappedUnMarshaller != null) {
                Object object;
                if (this.wrappedUnMarshaller instanceof HTTPUnMarshaller) {
                    HashMap map = new HashMap();
                    if (metadata != null) {
                        map.putAll(metadata);
                    }
                    map.put("Content-Length", Integer.toString(Integer.MAX_VALUE));
                    metadata = map;
                }
                if (this.wrappedUnMarshaller instanceof VersionedUnMarshaller) {
                    object = ((VersionedUnMarshaller)this.wrappedUnMarshaller).read(ois, metadata, version);
                    return object;
                }
                object = this.wrappedUnMarshaller.read(ois, metadata);
                return object;
            }
            Object object = super.read(ois, metadata, version);
            return object;
        }
        finally {
            gzis.end();
        }
    }

    @Override
    public UnMarshaller cloneUnMarshaller() throws CloneNotSupportedException {
        return new CompressingUnMarshaller(this.wrappedUnMarshaller);
    }

    static class DecomposableBufferedInputStream
    extends BufferedInputStream {
        DecomposableBufferedInputStream(InputStream in, int size) {
            super(in, size);
        }

        DecomposableBufferedInputStream(InputStream in) {
            super(in);
        }

        InputStream getWrappedStream() {
            return this.in;
        }
    }

    static class SelfCleaningGZipInputStream
    extends GZIPInputStream {
        SelfCleaningGZipInputStream(InputStream in) throws IOException {
            super(in);
        }

        void refreshInflater() {
            this.inf = new Inflater(true);
            this.crc.reset();
        }

        void end() throws IOException {
            while (this.available() > 0) {
                this.read();
            }
            this.inf.end();
        }
    }
}

