/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aspects.dbc.condition.parser;

import org.jboss.aspects.dbc.condition.parser.BooleanExpression;
import org.jboss.aspects.dbc.condition.parser.ExistsExpression;
import org.jboss.aspects.dbc.condition.parser.Expression;
import org.jboss.aspects.dbc.condition.parser.ExpressionVisitor;
import org.jboss.aspects.dbc.condition.parser.ForAllExpression;
import org.jboss.aspects.dbc.condition.parser.ImpliesExpression;
import org.jboss.aspects.dbc.condition.parser.JavaExpression;
import org.jboss.aspects.dbc.condition.parser.LoopExpression;

public class BeanshellGenerator
implements ExpressionVisitor {
    Expression expr;
    StringBuffer code;
    int indent;

    public BeanshellGenerator(Expression expr) {
        this.expr = expr;
    }

    public String createBeanshellCode() {
        this.code = new StringBuffer();
        this.expr.accept(this);
        return this.code.toString();
    }

    public void visit(Expression expr) {
        expr.accept(this);
    }

    public void visit(BooleanExpression expr) {
        if (expr.isTopLevel()) {
            this.code.append("return (" + expr.getExpression() + ");\n");
        } else {
            this.code.append(expr.getExpression());
        }
    }

    public void visit(ForAllExpression expr) {
        this.createLoopCode(expr, false);
    }

    public void visit(ExistsExpression expr) {
        this.createLoopCode(expr, true);
    }

    public void visit(ImpliesExpression expr) {
        this.indent();
        this.code.append("if (");
        expr.getLhs().accept(this);
        this.code.append("){\n");
        ++this.indent;
        this.indent();
        this.code.append("if(!(");
        expr.getRhs().accept(this);
        this.code.append(")){\n");
        ++this.indent;
        this.indent();
        this.code.append("return false;\n");
        --this.indent;
        this.indent();
        this.code.append("}\n");
        --this.indent;
        this.indent();
        this.code.append("}\n");
        if (expr.isTopLevel()) {
            this.code.append("return true;\n");
        }
    }

    public void visit(JavaExpression expr) {
        this.code.append(expr.getJava());
        this.code.append("\nreturn true;\n");
    }

    private void indent() {
        for (int i = 0; i < this.indent * 2; ++i) {
            this.code.append(" ");
        }
    }

    private void createLoopCode(LoopExpression expr, boolean breakType) {
        String declaration = expr.getDeclaration();
        String collection = expr.getCollection();
        Expression body = expr.getBody();
        this.indent();
        this.code.append("for (" + declaration + " : " + collection + "){\n");
        ++this.indent;
        if (body instanceof BooleanExpression) {
            this.indent();
            this.code.append("if (");
            if (!breakType) {
                this.code.append("!");
            }
            this.code.append("(");
            body.accept(this);
            this.code.append(")){\n");
            ++this.indent;
            this.indent();
            this.code.append("return " + breakType + ";\n");
            --this.indent;
            this.indent();
            this.code.append("}\n");
        } else if (body instanceof ImpliesExpression) {
            body.accept(this);
        } else {
            body.accept(this);
        }
        --this.indent;
        this.indent();
        this.code.append("}\n");
        if (expr.isTopLevel()) {
            this.indent();
            this.code.append("return " + !breakType + ";\n");
        }
    }
}

