/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.interceptors.aop;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.jboss.aop.joinpoint.Invocation;
import org.jboss.aop.joinpoint.MethodInvocation;
import org.jboss.ejb3.context.CurrentInvocationContext;
import org.jboss.ejb3.context.base.BaseInvocationContext;

public class InvocationContextInterceptor {
    private static final String INVOCATION_CONTEXT_KEY = InvocationContextInterceptor.class.getName() + ".invocationContext";

    public static InvocationContext getInvocationContext(Invocation invocation) {
        InvocationContext ctx = (InvocationContext)((Object)invocation.getResponseAttachment((Object)INVOCATION_CONTEXT_KEY));
        if (ctx == null) {
            throw new IllegalStateException("InvocationContextInterceptor must be in the interceptor chain");
        }
        ctx.invocation = invocation;
        return ctx;
    }

    public String getName() {
        return "InvocationContextInterceptor";
    }

    public Object fillMethod(Invocation invocation) throws Throwable {
        assert (invocation instanceof MethodInvocation) : "InvocationContextInterceptor.fillMethod only works on method invocation " + invocation;
        MethodInvocation mi = (MethodInvocation)invocation;
        InvocationContext ctx = InvocationContextInterceptor.getInvocationContext(invocation);
        ctx.setBusinessMethodInvocation(mi.getMethod(), mi.getArguments());
        return invocation.invokeNext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object setup(Invocation invocation) throws Throwable {
        InvocationContext ctx = new InvocationContext(invocation);
        invocation.addResponseAttachment((Object)INVOCATION_CONTEXT_KEY, (Object)ctx);
        try {
            Object object = invocation.invokeNext();
            return object;
        }
        finally {
            invocation.getResponseContextInfo().remove(INVOCATION_CONTEXT_KEY);
        }
    }

    private static class InvocationContext
    extends BaseInvocationContext {
        private Invocation invocation;

        private InvocationContext(Invocation invocation) {
            super(null, null);
            this.invocation = invocation;
        }

        public Map<String, Object> getContextData() {
            return CurrentInvocationContext.get().getContextData();
        }

        public Object getTarget() {
            return this.invocation.getTargetObject();
        }

        public Object proceed() throws Exception {
            try {
                return this.invocation.invokeNext();
            }
            catch (Exception e) {
                throw e;
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }

        private void setBusinessMethodInvocation(Method method, Object[] params) {
            this.setMethod(method);
            this.setParameters(params);
        }

        public void setParameters(Object[] params) {
            super.setParameters(params);
            ((MethodInvocation)this.invocation).setArguments(params);
        }

        public String toString() {
            Method method = this.getMethod();
            Object[] params = method != null ? this.getParameters() : null;
            return "[target=" + this.getTarget() + ", method=" + method + ", parameters=" + Arrays.toString(params) + ", contextData=" + this.getContextData() + "]";
        }
    }
}

