/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.ejb.Schedule;
import javax.ejb.Schedules;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.EjbProcessorUtils;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.common.ejb.IScheduleTarget;
import org.jboss.metadata.ejb.spec.NamedMethodMetaData;
import org.jboss.metadata.ejb.spec.ScheduleMetaData;
import org.jboss.metadata.ejb.spec.TimerMetaData;

public class SchedulesProcessor
extends AbstractFinderUser
implements Processor<IScheduleTarget, Method> {
    public SchedulesProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(Schedules.class);
    }

    public void process(IScheduleTarget scheduleTargetBeanMetaData, Method method) {
        Schedules schedulesAnnotation = (Schedules)this.finder.getAnnotation((AnnotatedElement)method, Schedules.class);
        if (schedulesAnnotation == null) {
            return;
        }
        Schedule[] schedules = schedulesAnnotation.value();
        if (schedules == null) {
            return;
        }
        for (Schedule schedule : schedules) {
            TimerMetaData timerMetadata = new TimerMetaData();
            timerMetadata.setInfo(schedule.info());
            timerMetadata.setPersistent(schedule.persistent());
            timerMetadata.setTimezone(schedule.timezone());
            NamedMethodMetaData timeoutMethod = new NamedMethodMetaData();
            timeoutMethod.setMethodName(method.getName());
            timeoutMethod.setMethodParams(EjbProcessorUtils.getMethodParameters(method));
            timerMetadata.setTimeoutMethod(timeoutMethod);
            ScheduleMetaData scheduleMetadata = new ScheduleMetaData(schedule);
            timerMetadata.setSchedule(scheduleMetadata);
            scheduleTargetBeanMetaData.addTimer(timerMetadata);
        }
    }
}

