/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.config;

import java.util.concurrent.CountDownLatch;
import org.apache.cxf.BusFactory;
import org.jboss.logging.Logger;

public class CXFInitializer {
    private static Logger logger = Logger.getLogger(CXFInitializer.class);
    private static CountDownLatch defaultBusCDL = new CountDownLatch(1);

    public void create() throws Exception {
        Thread defaultBusInitThread = new Thread((Runnable)new DefautBusInitializer(defaultBusCDL), "JBossWS-CXF-DefaultBus-Init");
        defaultBusInitThread.setDaemon(true);
        defaultBusInitThread.start();
    }

    public void destroy() throws Exception {
    }

    public static void waitForDefaultBusAvailability() {
        boolean trace = logger.isTraceEnabled();
        if (trace) {
            logger.trace((Object)(Thread.currentThread() + " will wait for default bus availability..."));
        }
        try {
            defaultBusCDL.await();
            if (trace) {
                logger.trace((Object)("Default bus now available: " + BusFactory.getDefaultBus((boolean)false)));
            }
        }
        catch (InterruptedException e) {
            logger.error((Object)"Interrupted while waiting for default bus to be set!");
            throw new RuntimeException(e);
        }
    }

    private class DefautBusInitializer
    implements Runnable {
        private CountDownLatch cdl;

        public DefautBusInitializer(CountDownLatch cdl) {
            this.cdl = cdl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long start = System.currentTimeMillis();
            try {
                BusFactory.getDefaultBus();
                if (logger.isTraceEnabled()) {
                    logger.info((Object)("Default bus started in " + (System.currentTimeMillis() - start) + " ms by " + Thread.currentThread()));
                }
            }
            finally {
                this.cdl.countDown();
            }
        }
    }
}

