/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.cxf.configuration.ConfiguredBeanLocator;
import org.apache.cxf.helpers.CastUtils;
import org.springframework.beans.Mergeable;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringBeanLocator
implements ConfiguredBeanLocator {
    ApplicationContext context;

    public SpringBeanLocator(ApplicationContext ctx) {
        this.context = ctx;
    }

    public List<String> getBeanNamesOfType(Class<?> type) {
        return Arrays.asList(this.context.getBeanNamesForType(type, false, true));
    }

    public <T> T getBeanOfType(String name, Class<T> type) {
        return type.cast(this.context.getBean(name, type));
    }

    public <T> Collection<? extends T> getBeansOfType(Class<T> type) {
        return CastUtils.cast(this.context.getBeansOfType(type, false, true).values());
    }

    public <T> boolean loadBeansOfType(Class<T> type, ConfiguredBeanLocator.BeanLoaderListener<T> listener) {
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.context.getBeanNamesForType(type, false, true)));
        Collections.reverse(list);
        for (String s : list) {
            Object o;
            Class beanType;
            Class<T> t;
            if (!listener.loadBean(s, t = (beanType = this.context.getType(s)).asSubclass(type)) || !listener.beanLoaded(s, type.cast(o = this.context.getBean(s)))) continue;
            return true;
        }
        return false;
    }

    public boolean hasConfiguredPropertyValue(String beanName, String propertyName, String searchValue) {
        ConfigurableApplicationContext ctxt = (ConfigurableApplicationContext)this.context;
        BeanDefinition def = ctxt.getBeanFactory().getBeanDefinition(beanName);
        if (!ctxt.getBeanFactory().isSingleton(beanName) || def.isAbstract()) {
            return false;
        }
        Collection ids = null;
        PropertyValue pv = def.getPropertyValues().getPropertyValue(propertyName);
        if (pv != null) {
            Object value = pv.getValue();
            if (!(value instanceof Collection)) {
                throw new RuntimeException("The property " + propertyName + " must be a collection!");
            }
            if (value instanceof Mergeable) {
                if (!((Mergeable)value).isMergeEnabled()) {
                    ids = (Collection)value;
                }
            } else {
                ids = (Collection)value;
            }
        }
        if (ids != null) {
            for (Object o : ids) {
                if (!(o instanceof TypedStringValue ? searchValue.equals(((TypedStringValue)o).getValue()) : searchValue.equals((String)o))) continue;
                return true;
            }
        }
        return false;
    }
}

