/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.embedded.impl.shrinkwrap;

import java.util.Arrays;
import javax.naming.Context;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.ejb3.embedded.api.EJBDeploymentException;
import org.jboss.ejb3.embedded.api.JBossEJBContainer;
import org.jboss.ejb3.embedded.api.shrinkwrap.ShrinkWrapEJBContainer;
import org.jboss.ejb3.embedded.spi.JBossEJBContainerProvider;
import org.jboss.kernel.Kernel;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.vdf.api.ShrinkWrapDeployer;

public class ShrinkWrapEJBContainerImpl
implements ShrinkWrapEJBContainer {
    private final JBossEJBContainer delegate;
    private final ShrinkWrapDeployer shrinkWrapDeployer;

    public ShrinkWrapEJBContainerImpl(JBossEJBContainerProvider delegate) throws IllegalArgumentException {
        if (delegate == null) {
            throw new IllegalArgumentException("EJB Container delegate must be specified");
        }
        Kernel kernel = delegate.getMCServer().getKernel();
        ShrinkWrapDeployer shrinkWrapDeployer = (ShrinkWrapDeployer)kernel.getController().getContextByClass(ShrinkWrapDeployer.class).getTarget();
        assert (shrinkWrapDeployer != null) : "ShrinkWrapDeployer found in Kernel was null";
        this.delegate = delegate;
        this.shrinkWrapDeployer = shrinkWrapDeployer;
    }

    public void deploy(Archive<?> ... archives) throws EJBDeploymentException, IllegalArgumentException {
        if (archives == null) {
            throw new IllegalArgumentException("archives must be supplied");
        }
        try {
            this.shrinkWrapDeployer.deploy(archives);
        }
        catch (DeploymentException e) {
            throw EJBDeploymentException.newInstance((String)("Could not deploy " + Arrays.asList(archives)), (Throwable)e);
        }
    }

    public void undeploy(Archive<?> ... archives) throws EJBDeploymentException, IllegalArgumentException {
        if (archives == null) {
            throw new IllegalArgumentException("archives must be supplied");
        }
        try {
            this.shrinkWrapDeployer.undeploy(archives);
        }
        catch (DeploymentException e) {
            throw EJBDeploymentException.newInstance((String)("Could not undeploy " + Arrays.asList(archives)), (Throwable)e);
        }
    }

    public void close() {
        this.delegate.close();
    }

    public Context getContext() {
        return this.delegate.getContext();
    }
}

