/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server.managed;

import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jboss.ha.core.channelfactory.ProtocolData;
import org.jboss.ha.core.channelfactory.ProtocolParameter;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.CompositeMetaType;
import org.jboss.metatype.api.types.ImmutableCompositeMetaType;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.CollectionValue;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.metatype.spi.values.MetaMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocolStackConfigMapper
extends MetaMapper<ProtocolData[]> {
    public static final CompositeMetaType PROTOCOL_PARAMETER_TYPE;
    public static final CompositeMetaType PROTOCOL_PARAMETER_MAP_TYPE;
    public static final CompositeMetaType PROTOCOL_STACK_CONFIG_TYPE;
    public static final CollectionMetaType TYPE;

    public MetaType getMetaType() {
        return TYPE;
    }

    public Type mapToType() {
        return List.class;
    }

    public MetaValue createMetaValue(MetaType metaType, ProtocolData[] data) {
        MetaValue[] dataElements = new MetaValue[data.length];
        for (int i = 0; i < data.length; ++i) {
            HashMap<String, Object> protocolValue = new HashMap<String, Object>();
            protocolValue.put("name", SimpleValueSupport.wrap((Serializable)((Object)data[i].getProtocolName())));
            ProtocolData cfr_ignored_0 = data[i];
            protocolValue.put("description", SimpleValueSupport.wrap((Serializable)((Object)ProtocolData.getDescription())));
            protocolValue.put("className", SimpleValueSupport.wrap((Serializable)((Object)data[i].getClassName())));
            ProtocolParameter[] params = data[i].getParametersAsArray();
            HashMap<String, CompositeValueSupport> paramValues = new HashMap<String, CompositeValueSupport>();
            for (int j = 0; j < params.length; ++j) {
                HashMap<String, SimpleValue> paramValue = new HashMap<String, SimpleValue>();
                paramValue.put("value", SimpleValueSupport.wrap((Serializable)((Object)params[j].getValue())));
                paramValues.put(params[j].getName(), new CompositeValueSupport(PROTOCOL_PARAMETER_TYPE, paramValue));
            }
            protocolValue.put("protocolParameters", new MapCompositeValueSupport(paramValues, (MetaType)PROTOCOL_PARAMETER_MAP_TYPE));
            dataElements[i] = new MapCompositeValueSupport(protocolValue, (MetaType)PROTOCOL_STACK_CONFIG_TYPE);
        }
        return new CollectionValueSupport(TYPE, dataElements);
    }

    public ProtocolData[] unwrapMetaValue(MetaValue metaValue) {
        if (metaValue == null) {
            return null;
        }
        if (!(metaValue instanceof CollectionValue)) {
            throw new IllegalArgumentException(metaValue + " is not a " + CollectionValue.class.getSimpleName());
        }
        MetaValue[] elements = ((CollectionValue)metaValue).getElements();
        ProtocolData[] protocolData = new ProtocolData[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            CompositeValue protocolValue = (CompositeValue)elements[i];
            String protName = (String)((Object)((SimpleValue)protocolValue.get("name")).getValue());
            String protClass = (String)((Object)((SimpleValue)protocolValue.get("className")).getValue());
            CompositeValue paramsValue = (CompositeValue)protocolValue.get("protocolParameters");
            Set paramNames = paramsValue.getMetaType().keySet();
            ArrayList<ProtocolParameter> protParams = new ArrayList<ProtocolParameter>(paramNames.size());
            for (String paramName : paramNames) {
                CompositeValue paramValue = (CompositeValue)paramsValue.get(paramName);
                String paramVal = (String)((Object)((SimpleValue)paramValue.get("value")).getValue());
                protParams.add(new ProtocolParameter(paramName, paramVal));
            }
            protocolData[i] = new ProtocolData(protName, protClass, protParams);
        }
        return protocolData;
    }

    static {
        String[] paramItemNames = new String[]{"description", "value"};
        String[] paramItemDescs = new String[]{"description of the meaning of the attribute", "the value of the configuration parameter"};
        MetaType[] paramItemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING};
        PROTOCOL_PARAMETER_TYPE = new ImmutableCompositeMetaType(ProtocolParameter.class.getName(), "Protocol Parameters", paramItemNames, paramItemDescs, paramItemTypes);
        PROTOCOL_PARAMETER_MAP_TYPE = new MapCompositeMetaType((MetaType)PROTOCOL_PARAMETER_TYPE);
        String[] configItemNames = new String[]{"name", "description", "className", "protocolParameters"};
        String[] configItemDescs = new String[]{"the name of the protocol", "description of the protocol", "fully-qualified name of the protocol implementation class", "set of configuration parameters for the protocol"};
        MetaType[] configItemTypes = new MetaType[]{SimpleMetaType.STRING, SimpleMetaType.STRING, SimpleMetaType.STRING, PROTOCOL_PARAMETER_MAP_TYPE};
        PROTOCOL_STACK_CONFIG_TYPE = new ImmutableCompositeMetaType(ProtocolData.class.getName(), "Protocol Stack Configuration", configItemNames, configItemDescs, configItemTypes);
        TYPE = new CollectionMetaType(List.class.getName(), (MetaType)PROTOCOL_STACK_CONFIG_TYPE);
    }
}

